<?php
namespace app\shared\logic\platform;
use app\shared\model\GiftCard;
use app\shared\model\User;
use app\shared\model\GiftCardOrder;
use think\exception\ValidateException;
use app\BaseController;
class GiftCardForm extends  Base
{
    //获取数据
    public  function index(){
        $query=GiftCard::where(['acid'=>$this->acid,'is_delete'=>0]);
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select();
        foreach ($list as $key => &$value) {
            $value['price_list']=@json_decode($value['price_list'],1);
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        try {
            $data=request()->post();
            $rule = [
                'id|ID'=>'require',
                'title|标题'=>'require',
                'cover|封面'=>'require',
                'price_list|价格表'=>'require',
                'detail|详情'=>'require',
                'status|状态'=>'require|in:0,1',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $price_list=[];
        foreach(json_decode($data['price_list'],1) as $value){
            if(!(isset($value['price'])||isset($value['give_price']))){
                return fetchJson([],'价格表出错',1);
            }
            if(empty($value['price'])||empty($value['give_price'])){
                return fetchJson([],'价格表金额不得为空',1);
            }
            $price_list[]=[
                'price'=>$value['price'],
                'give_price'=>$value['give_price'],
            ];
        }
        if(!$price_list){
             return fetchJson([],'价格表不得为空',1);
        }
        $form=GiftCard::where(['id'=>$data['id']])->find();
        if(!$form){
            $form=new GiftCard();
            $form->acid=$this->acid;
        }
        $form->title=$data['title'];
        $form->cover=$data['cover'];
        $form->status=$data['status'];
        $form->detail=$data['detail'];
        $form->price_list=json_encode($price_list);
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         GiftCard::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //订单列表
    public function orderList(){
        $that=new UserForm();
        $query=GiftCardOrder::alias('o')
        ->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')
        ->where(['o.acid'=>$this->acid]);
        $status=input('status')?input('status'):0;
        if($status!=-10){
            $query->where('o.status','in','1,2');
        }
        $count=$query->count();
        $list=$query->page($this->page)->limit(10)->order('o.id DESC')->field('o.*,u.nickname,u.avatar_url')->select();
        foreach($list as &$value){
            $value['snapshoot']=@json_decode($value['snapshoot'],1);
        }
        return fetchJson([
            'count'=>$count,
            'list'=>$list
        ]);
    }

}