<?php
namespace app\shared\logic\platform;
use app\shared\model\DoorDevice;
use think\exception\ValidateException;
use app\BaseController;
class DoorDeviceForm extends  Base
{
    //获取数据
    public  function index(){
        $query=DoorDevice::where(['acid'=>$this->acid,'is_delete'=>0]);
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->select();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=DoorDevice::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'device_sn|设备号'=>'require',
                'device_pwd|设备密码'=>'require',
                'name|名称'=>'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new DoorDevice();
            $form->acid=$this->acid;
        }
        $form->device_sn=$data['device_sn'];
        $form->device_pwd=$data['device_pwd'];
        $form->name=$data['name'];
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         DoorDevice::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
}