<?php
namespace app\shared\logic\platform;
use app\shared\model\Coupon;
use app\shared\model\CouponUser;
use app\shared\model\User;
use think\exception\ValidateException;
use app\BaseController;
class CouponForm extends  Base
{
    //获取数据
    public  function index(){
        $query=Coupon::where(['acid'=>$this->acid,'is_delete'=>0]);
        if($send_type=input('send_type')){
            $query->where('send_type',$send_type);
        }
        if($type=input('type')){
            $query->where('type',$type);
        }
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select();
        foreach ($list as $key => &$value) {
            $value['start_time']=date('Y-m-d',$value['start_time']);
            $value['end_time']=date('Y-m-d',$value['end_time']);
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        try {
            $data=request()->post();
            $rule = [
                'id|ID'=>'require',
                'name|名称'=>'require',
                'send_type|发放类型'=>'require|in:1,2,3,4,5,6', //1新人注册、2转发、3领券中心、4拼桌邀请,5中秋博饼,6平台优惠券
                'type|类型'=>'require|in:1,2,3,4,5', //1茶室预订2茶艺师,3商城,4扫码点单,5货柜优惠券
                'status|状态'=>'require|in:1,0',
                'start_time|开始时间'=>'require|date',
                'end_time|结束时间'=>'require|date',
                'price|优惠金额'=>'require|>:0.01',
                'full_price|满足金额'=>'require|>=:0',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=Coupon::where(['id'=>$data['id']])->find();
        if(!$form){
            $form=new Coupon();
            $form->acid=$this->acid;
        }
        $form->cover=input('cover');
        $form->send_type=$data['send_type'];
        $form->type=$data['type'];
        $form->name=$data['name'];
        $form->status=$data['status'];
        $form->start_time=strtotime($data['start_time']);
        $form->end_time=strtotime($data['end_time'])+86399;
        $form->price=$data['price'];
        $form->full_price=$data['full_price'];
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         Coupon::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //优惠券发放
    public function distribution(){
        try {
            $data=request()->post();
            $rule = [
                'id|ID'=>'require|number',
                'user_id|用户ID'=>'require|number',
                'num|数量'=>'require|number',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $coupon=Coupon::where(['id'=>$data['id']])->find();
        if(!$coupon){
            return fetchJson([],'暂无优惠券',1);    
        }
        $user=User::where(['id'=>$data['user_id']])->find();
        if(!$user){
            return fetchJson([],'暂无用户',1);      
        }
        if($data['num']<0){
            return fetchJson([],'数量不得为负数',1);
        }
        if($data['num']>50){
            return fetchJson([],'单次发放不得超过50张',1);
        }
        for($i=0; $i<$data['num']; $i++) { 
            $form=new CouponUser();
            $form->save([
                'acid'=>$this->acid,
                'coupon_id'=>$coupon['id'],
                'user_id'=>$user['id'],
                'type'=>$coupon['type'],
            ]);
        }
        return fetchJson([],'发放成功'); 
    }
}