<?php
namespace app\shared\logic\platform;
use app\shared\model\Counter;
use app\shared\model\CounterChest;
use app\shared\model\Goods;
use app\shared\model\Store;
use think\exception\ValidateException;
use app\BaseController;
class CounterForm extends  Base
{
    //柜子
    public  function index(){
        $query=Counter::where(['acid'=>$this->acid,'is_delete'=>0]);
        if($store_id=input('store_id')){
            $query->where('store_id',$store_id);
        }
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit(2)
        ->order('sort DESC')
        ->select()
        ->toArray();
        $form=new \counter\Yunshoukex();
        
        foreach ($list as $key => &$value) {
            if($value['type']==2){
                $counter_config=Store::where('id',$value['store_id'])->value('counter_config');
                $counter_config=@json_decode($counter_config,true);
                $appid=$counter_config['appid'];
                $appkey=$counter_config['appkey'];
                $formliubao=new \counter\Ksepton($appid,$appkey);
                $res=$formliubao->queryMachineList();
                $queryMachineList=[];
                if($res['code']==0){
                    $queryMachineList=$res['data'];
                    $queryMachineList=array_column($queryMachineList,'is_online','machine_id');
                }
                $value['is_online']=0;
                if(isset($queryMachineList[$value['deviceId']])){
                    if($queryMachineList[$value['deviceId']]=="在线"){
                        $value['is_online']=1;
                    }
                }
            }else{
                $res=$form->deviceOnline($value['deviceId']);
                $value['is_online']=isset($res['data']['is_online'])?$res['data']['is_online']:0;
            }
            
            $res=$form->deviceMacSim($value['deviceId']);
            $value['flow_sum']=isset($res['data']['left_count'])?$res['data']['left_count']:0;
            $counter_chest_list=CounterChest::alias('c_c')
            ->leftJoin([Goods::getTable()=>'g'],'c_c.goods_id=g.id')
            ->where(['c_c.counter_id'=>$value['id'],'c_c.is_delete'=>0])
            ->order('c_c.motoNum ASC')
            ->column('c_c.*,g.cover,g.name,g.price');
            foreach($counter_chest_list as &$v){
                $v['cover']=get_file_url($v['cover']);
            }
            $value['counter_chest_list']=$counter_chest_list;
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=Counter::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'store_id|商户ID'=>'require|number',
                'name|名称'=>'require',
                'deviceId|设备ID'=>'require',
                'sort|排序'=>'require|number',
                'status|状态'=>'require|in:0,1'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $number=0;
        if(!$form){
            $form=new Counter();
            $form->acid=$this->acid;
            $number=input('number');
            $form->save();
        }
        $form->type=input('type');
        $form->store_id=$data['store_id'];
        $form->name=$data['name'];
        $form->deviceId=$data['deviceId'];
        $form->status=$data['status'];
        $form->sort=$data['sort'];
        $form->address=input('address');
        $form->qrcode_url=qrcodeUrl($this->acid,$wxappPath="mall/goods/list?id=".$form->store_id."&counter_id=".$form->id."&parent_id=-1",$dirname="counter_qr",$filename='counter_id_'.$form->id);
        $form->save();
        if($number){
            $counterChest=[];
            for($i=1;$i<=$number;$i++){
                $counterChest[]=[
                    'acid'=>$form->acid,
                    'store_id'=>$form->store_id,
                    'counter_id'=>$form->id,
                    'motoNum'=>$i,
                    'deviceId'=>$form->deviceId
                ];
            }
            CounterChest::insertAll($counterChest);
        }
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         Counter::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         CounterChest::where(['acid'=>$this->acid,'counter_id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
}