<?php
namespace app\shared\logic\platform;
use app\shared\model\Counter;
use app\shared\model\CounterChest;
use app\shared\model\Goods;
use app\shared\model\Store;
use think\exception\ValidateException;
use app\BaseController;
class CounterChestForm extends  Base
{
    //获取数据
    public  function index(){
        $query=CounterChest::where(['acid'=>$this->acid,'is_delete'=>0]);
        if($counter_id=input('counter_id')){
            $query->where('counter_id',$counter_id);
        }
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('motoNum ASC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
           if($value['type']==1){
             $goods=Goods::where('id',$value['goods_id'])->field('cover,name,price')->find();
             $value['goods']=[
                'cover_url'=>get_file_url($goods['cover']),
                'name'=>$goods['name'],
                'price'=>$goods['price']
             ];
           }
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=CounterChest::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'counter_id|柜子ID'=>'require|number',
                'type|商品类型'=>'require|number',
                'motoNum|柜子编号'=>'require|number',
                'status|状态'=>'require|in:0,1'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new CounterChest();
            $form->acid=$this->acid;
        }
        $form->counter_id=$data['counter_id'];
        $form->motoNum=$data['motoNum'];
        $form->type=$data['type'];
        if(input('goods_id')){
            $form->goods_id=$data['goods_id'];
        }
        if($stock=input('stock')){
            $form->stock=$stock;
        }
        $counter=Counter::where('id',$form->counter_id)->field('deviceId,store_id')->find();
        $form->deviceId=$counter['deviceId'];
        $form->store_id=$counter['store_id'];
        $form->status=$data['status'];
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         CounterChest::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //打开柜子
    public function deviceOpendoor(){
         try {
            $data=request()->post();
            $rule = [
                'counter_id|柜子ID'=>'require|number',
                'motoNum|柜子编号'=>'requireIf:type,1',
                'type|类型'=>'require|in:1,2'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $device=Counter::where('id',$data['counter_id'])->field('type,deviceId,store_id')->find();
        if($device['type']==2){
            $counter_config=Store::where('id',$device['store_id'])->value('counter_config');
            $counter_config=@json_decode($counter_config,true);
            $appid=$counter_config['appid'];
            $appkey=$counter_config['appkey'];
            if($data['type']==1){
                $form=new \counter\Ksepton($appid,$appkey);
                $res=$form->payDelivery($device['deviceId'],$data['motoNum']);
                return fetchJson([],$res['msg'],$res['code']);
            }else{
                $form=new \counter\Ksepton($appid,$appkey);
                $motoNums=CounterChest::where(['acid'=>$this->acid,'is_delete'=>0,'deviceId'=>$device['deviceId']])->column('motoNum');
                $motoNums=implode(',',$motoNums);
                $res=$form->payMultiDelivery($device['deviceId'],$motoNums);
                return fetchJson([],$res['msg'],$res['code']);
            }
        }else{
            if($data['type']==1){
                $form=new \counter\Yunshoukex();
                $res=$form->deviceOpendoor($device['deviceId'],$data['motoNum']);
                return fetchJson([],$res['msg'],$res['code']);
            }else{
                $form=new \counter\Yunshoukex();
                $res=$form->deviceOpenalldoor($device['deviceId']);
                return fetchJson([],$res['msg'],$res['code']);
            }
        }
    }
}