<?php
namespace app\shared\logic\platform;
use app\shared\model\Conversion;
use app\shared\model\Card;
use app\shared\model\Coupon;
use app\shared\model\User;
use app\shared\model\Store;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\model\Option;
use think\facade\Db;
class ConversionForm extends  Base
{

    //获取数据
    public  function index(){
        $status=input('status');
        $query=Conversion::alias('c')
        ->leftJoin([User::getTable()=>'u'],'c.user_id=u.id')
        ->leftJoin([Store::getTable()=>'s'],'c.store_id=s.id')
        ->where(['c.acid'=>$this->acid,'c.is_delete'=>0]);
        if($status!=-1){
            $query->where('c.status',$status);
        }
        if($keyword=input('keyword')){
            $query->where('c.code','like',"%{$keyword}%");
        }
        $count=$query->field('c.*,u.avatar_url,u.nickname,u.account,s.name store_name')->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
            if($value['user_id']==0){
                $value['account']='';
                $value['avatar_url']='';
                $value['nickname']='';
            }
            if($value['store_id']==0){
                 $value['store_name']='平台兑换';
            }
            $value['qrcode_url']='https://api.pwmqr.com/qrcode/create/?url='.$value['code'];
            if($value['card_ids']){
                 $value['card_list']=Card::where('id','in',$value['card_ids'])->column('id,title,cover');
            }else{
                 $value['card_list']=[];
            }
            if($value['coupon_ids']){
                $value['coupon_list']=Coupon::where('id','in',$value['coupon_ids'])->column('id,name,type');
            }else{
                $value['coupon_list']=[];
            }
            if($value['status']==1){
                $value['finish_time']=!empty($value['finish_time'])?date('Y-m-d H:i:s',$value['finish_time']):$value['update_time'];
            }else{
                $value['finish_time']='';
            }
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function create(){
        try {
            $data=request()->post();
            $rule = [
                'card_ids|会员卡ID'=>'require',
                'coupon_ids|兑换优惠券ID'=>'require',
                'money|兑换金额'=>'require',
                'num|数量'=>'require|number'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if($data['num']>50){
            return fetchJson([],'一次生成最多只支持50条',1);
        }
        $conversion_arr=[];
        $time=time();
        $store_id=input('store_id')?input('store_id'):0;
        for ($i=0; $i <$data['num'] ; $i++){ 
            $conversion_arr[]=[
                'acid'=>$this->acid,
                'store_id'=>$store_id,
                'card_ids'=>$data['card_ids'],
                'coupon_ids'=>$data['coupon_ids'],
                'money'=>$data['money'],
                'code'=>Conversion::createCode(),
                'create_time'=>$time,
                'update_time'=>$time,
            ];
        }
        Db::name(Conversion::TABLE_NAME)
        ->limit(100)
        ->insertAll($conversion_arr);
        return fetchJson([],'创建成功');
    }
    //删除
    public function delete(){
         $ids=input('id');
         $ids=explode(',',$ids);
         Conversion::where(['acid'=>$this->acid,'status'=>0])->where('id','in',$ids)->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    public function setting(){
       if(input('is_find')){
            $info=Option::get_data($this->acid,'shared','app_plugin_conversion_dec');
            return fetchJson([
                'dec'=>$info
            ],'设置成功');
       }
       Option::set_data($this->acid,'shared','app_plugin_conversion_dec',input('dec'));
       return fetchJson([],'设置成功');
    }
}
