<?php
namespace app\shared\logic\platform;
use app\shared\model\Companion;
use app\shared\model\GoodsCat;
use app\shared\model\GoodsAttr;
use app\shared\model\CircleTopic;
use think\exception\ValidateException;
use app\BaseController;
class CompanionForm extends  Base
{
    //获取数据
    public  function index(){
        $query=Companion::where(['is_delete'=>0]);
        if($keyword=input('keyword')){
            $query->where('name','like',"%{$keyword}%");
        }
        if($category_id=input('category_id')){
            $query->where('category_id',$category_id);
        }
        if($acid=input('acid')){
            $query->where('acid',$acid);
        }
        $status=input('status');
        if($status>-1){
            $query->where('status',$status);
        }
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select();
        foreach ($list as $key => &$value) {
            $value['start_time']=date('Y-m-d',$value['start_time']);
            $value['end_time']=date('Y-m-d',$value['end_time']);
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        try {
          $data=request()->post();
          $rule = [
              'id|ID' => 'require',
              'user_id|用户ID' => 'require',
              'category_id|分类ID'=>'require',
              'title|标题'=>'require',
              'describe|描述'=>'require',
              'date|开始日期'=>'require|date',
              'start_time|开始时间'=>'require|date',
              'end_time|结束时间'=>'require|date',
              'place|地点'=>'require',
              'address|地址'=>'require',
              'people_type|参与人形式'=>'require',
              'man_num|男生人数'=>'require',
              'woman_num|女生人数'=>'require',
              'pay_types|支付类型'=>'require',
              'consume_types|消费类型'=>'require',
              'cash_price|押金费用'=>'require',
              'price|活动费用'=>'require',
              'organizer_type|玩家类型'=>'require',
              'username|用户姓名'=>'require',
              'tel|联系电话'=>'require',
              'wx_num|微信号'=>'require',
              'status|状态'=>'require|in:0,1',
              'lat|维度'=>'require',
              'lng|经度'=>'require',
          ];
          $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=Companion::where(['id'=>$data['id']])->find();
        if(!$form){
            $form=new Companion();
        }
        $form->save([
          'user_id'=>$data['user_id'],
          'category_id'=>$data['category_id'],
          'title'=>$data['title'],
          'describe'=>$data['describe'],
          'date'=>$data['date'],
          'start_time'=>strtotime($data['start_time']),
          'end_time'=>strtotime($data['end_time']),
          'place'=>$data['place'],
          'address'=>$data['address'],
          'people_type'=>$data['people_type'],
          'man_num'=>$data['man_num'],
          'woman_num'=>$data['woman_num'],
          'pay_types'=>$data['pay_types'],
          'consume_types'=>$data['consume_types'],
          'cash_price'=>$data['cash_price'],
          'price'=>$data['price'],
          'organizer_type'=>$data['organizer_type'],
          'username'=>$data['username'],
          'tel'=>$data['tel'],
          'wx_num'=>$data['wx_num'],
          'status'=>$data['status'],
          'lat'=>$data['lat'],
          'lng'=>$data['lng'],
        ]);
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         Companion::where(['id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
}