<?php
namespace app\shared\logic\platform;
use app\shared\model\Store;
use app\shared\model\WeixinUser;
use app\shared\model\StoreCleaning;
use app\shared\model\HouseOrder;
use app\shared\model\StoreCleaningOrder;
use think\exception\ValidateException;
use app\BaseController;
class CleaningForm extends  Base
{
    //获取数据
    public  function index(){
        $query=StoreCleaning::alias('c')
        ->leftJoin([Store::getTable()=>'s'],'c.store_id=s.id')
        ->where(['c.acid'=>$this->acid,'c.is_delete'=>0]);
        if($store_id=input('store_id')){
            $query->where('c.store_id',$store_id);
        }
        if($keyword=input('keyword')){
            $query->where('c.account|c.username|c.openid','like',"%{$keyword}%");
        }
        $count=$query->count();
        $list= $query
        ->page($this->page)
        ->limit($this->limit)
        ->field('c.*,s.name store_name')
        ->select()
        ->toArray();
        foreach($list as &$value){
            $user=WeixinUser::where(['acid'=>$this->acid,'mobile'=>$value['account']])->field('nickname,avatar_url')->find();
            $value['avatar_url']=$user['avatar_url'];
            $value['nickname']="【{$value['store_name']}】".$user['nickname'];
            $value['cleaning_num']=StoreCleaningOrder::where('cleaning_id',$value['id'])->whereMonth('create_time')->count();
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]); 
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=StoreCleaning::where(['id'=>$id])->find();
        try{
            $data=request()->post();
            $rule = [
                'username|姓名'=>'require',
                'account|电话'=>'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new StoreCleaning();
            $form->acid=$this->acid;
        }
        $form->store_id=$data['store_id'];
        $form->username=$data['username'];
        $form->account=$data['account'];
        $form->openid=input('openid');
        $form->is_delete=0;
        $form->status=input('status');
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         StoreCleaning::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    public function orderList(){
        $query=StoreCleaningOrder::alias('a')
        ->leftJoin([StoreCleaning::getTable()=>'b'],'a.cleaning_id=b.id')
        ->leftJoin([HouseOrder::getTable()=>'c'],'a.order_id=c.id')
        ->where(['a.acid'=>$this->acid,'a.is_delete'=>0]);
        if($store_id=input('store_id')){
            $query->where('a.store_id',$store_id);
        }
        if($cleaning_id=input('cleaning_id')){
            $query->where('a.cleaning_id',$cleaning_id);
        }
        $start_date=input('start_date');
        $end_date=input('end_date');
        if($start_date&&$end_date){
            $query->whereBetweenTime('a.create_time',$start_date,$end_date);
        }
        $query->field('a.*,b.username,b.account,c.order_no,c.status orderStatus,c.update_time cleaning_over_time,c.price,c.pay_price,c.snapshoot');
        $count=$query->count();
        $list= $query
        ->page($this->page)
        ->limit($this->limit)
        ->order('a.id DESC')
        ->select();
        foreach ($list as &$value){
            if($value['orderStatus']==4){
                $value['status']=2;
                $value['time']=timetodate($value['cleaning_over_time']-$value['cleaning_time']);
                $value['cleaning_over_time']=date('Y-m-d H:i:s',$value['cleaning_over_time']);
            }else{
                $value['cleaning_over_time']="";
                $value['time']='';
            }
            $value['cleaning_time']=date('Y-m-d H:i:s',$value['cleaning_time']);
            $snapshoot=@json_decode($value['snapshoot'],1);
            $value['houseName']=$snapshoot['name'];
            $value['houseCover']=$snapshoot['cover'];
            unset($value['snapshoot']);
            unset($value['orderStatus']);
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]); 
    }
}