<?php
namespace app\shared\logic\platform;
use app\shared\model\CardCoupon;
use app\shared\model\CardCouponOrder;
use app\shared\model\HouseOrder;
use app\shared\model\User;
use think\exception\ValidateException;
use app\BaseController;
class CardCouponForm extends  Base
{
    //获取数据
    public  function index(){
        $query=CardCoupon::alias('c')
        ->leftJoin([User::getTable()=>'u'],'c.user_id=u.id')
		->where(['c.acid'=>$this->acid,'c.is_delete'=>0]);
		if($keyword=input('keyword')){
			$query->where('u.account|c.code','like',"%{$keyword}%");
		}
        if($type=input('type')){
            $query->where('c.type',$type);
        }
		$query->field('c.*,u.nickname,u.avatar_url,u.account');
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select();
        foreach ($list as $key => &$value) {
        	if($value['end_time']<time()){
        		$value['status']=0;
        	}
            $value['start_time']=date('Y-m-d',$value['start_time']);
            $value['end_time']=date('Y-m-d',$value['end_time']);
            $value['snapshoot']=@json_decode($value['snapshoot'],1);
            if($value['type']==2){
                $value['code']='';
            }
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        try {
            $data=request()->post();
            $rule = [
                'id|ID'=>'require',
                'num|数量'=>'require|>=:0',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=CardCoupon::where(['id'=>$data['id'],'status'=>1])->find();
        if(!$form){
            return fetchJson([],'暂无美团券');
        }
        $count=HouseOrder::where(['acid'=>$this->acid,'is_pay'=>0,'status'=>0,'card_coupon_id'=>$form->id])->count();
    	if($count){
    		return fetchJson([],'该美团券用户已经在未付款订单中使用，随时可能会付款，暂不可修改',1);
    	}
        $form->num=$data['num'];
        $form->status=$form->num<=0?0:$form->status;
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         CardCoupon::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
}