<?php
namespace app\shared\logic\platform;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\model\BypassAccount;
use app\shared\model\Role;
class BypassAccountForm extends  Base
{
    //列表
    public  function index(){
        $query=BypassAccount::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>0]);
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')->select();
        foreach ($list as $key => &$value) {
        	$value['role']=Role::where('id',$value['role_id'])->value('name');
            $value['password']='';
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
    	try {
	        $data=request()->post();
	        $rule = [
	            'id|ID' =>'require|number',
	            'name|名称' =>'require',
	            'role_id|角色ID' =>'require',
	            'account|账号' =>'require',
                'username|姓名' =>'require',
	            'logo|LOGO' =>'require',
	            'status|状态' =>'require',
	        ];
	        $this->validate($data,$rule);
	    } catch (ValidateException $e){
	        return fetchJson([],$e->getError(),1);
	    }
	    $form=BypassAccount::where(['acid'=>$this->acid,'store_id'=>0,'id'=>$data['id']])->find();
	    if(!$form){
            $form=new BypassAccount();
            $form->acid=$this->acid;
	    	$form->store_id=0;
            if(BypassAccount::where(['acid'=>$this->acid,'store_id'=>0,'account'=>$data['account'],'is_delete'=>0])->count()){
            	return fetchJson([],'该账号已存在',1);
            }
        }else{
        	if(BypassAccount::where(['acid'=>$this->acid,'store_id'=>0,'account'=>$data['account'],'is_delete'=>0])->where('id','<>',$form->id)->count()){
        		 return fetchJson([],'该账号已存在',1);
        	}
        }
        $form->account=$data['account'];
        $form->phone=$data['account'];
        if(input('password')){
        	 $form->password=md5($data['password']);
        }
	    $form->name=$data['name'];
        $form->username=$data['username'];
	    $form->logo=$data['logo'];
	    $form->status=$data['status'];
	    $form->role_id=$data['role_id'];
	    $form->tel=input('tel');
	    $form->save();
	    return fetchJson([],'保存成功');
	}
	//删除
	public function delete(){
		$id=input('id');
		BypassAccount::where(['id'=>$id])->update(['is_delete'=>1]);
	    return fetchJson([],'保存成功');
	}
	//状态变更
    public function change(){
        $data = request()->only(['id', 'status']);
        $rule = [
            'id|ID' => 'require|integer',
            'status|状态' => 'in:0,10', //0启用10禁用
        ];
        try {
            $this->validate($data, $rule);
        } catch (ValidateException $e) {
            return fetchJson([], $e->getError(), 1);
        }
        //TODO 操作权限
        BypassAccount::update(['status'=>$data['status']],['id'=>$data['id'],'store_id'=>0,'acid'=>$this->acid]);
        return fetchJson([],'保存成功');
    }

    //列表
    public  function storeIndex(){
        $data = request()->only(['store_id']);
        $rule = [
            'store_id|商户ID' => 'require|integer|>:0',
        ];
        try {
            $this->validate($data, $rule);
        } catch (ValidateException $e) {
            return fetchJson([], $e->getError(), 1);
        }
        $query=BypassAccount::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$data['store_id']]);
        $count=$query->count();
        $list=$query->page($this->page)
            ->limit($this->limit)
            ->order('id DESC')->withoutField('password')->select();
        foreach ($list as $key => &$value) {
            $value['role']=Role::where('id',$value['role_id'])->value('name');
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function storeEdit(){
        try {
            $data=request()->post();
            $rule = [
                'id|ID' =>'require|number',
                'store_id|主办方ID' =>'require|number',
                'name|名称' =>'require',
                'role_id|角色ID' =>'require|integer',
                'account|账号' =>'require',
                'logo|LOGO' =>'require',
                'status|状态' =>'require|in:0,10',
                'password|密码' =>'length:6,20',
                'tel|手机号' =>'require|mobile',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form = BypassAccount::where(['id'=>$data['id'],'acid'=>$this->acid,'store_id'=>$data['store_id'],'is_delete'=>0])->find();
        if(!$form){
            $form=new BypassAccount();
            $form->acid=$this->acid;
            $form->store_id=$data['store_id'];
            $form->password=md5($data['account']);
            if(BypassAccount::where(['acid'=>$this->acid,'store_id'=>$data['store_id'],'account'=>$data['account'],'is_delete'=>0])->find()){
                return fetchJson([],'该账号已存在',1);
            }
        }else{
            if($form->account!=$data['account']){
                if(BypassAccount::where(['acid'=>$this->acid,'store_id'=>$data['store_id'],'account'=>$data['account'],'is_delete'=>0])->where('id','<>',$form->id)->find()){
                    return fetchJson([],'该账号已存在',1);
                }
            }
        }
        $form->account=$data['account'];
        if(!empty($data['password'])){
            $form->password=md5($data['password']);
        }
        $form->name=$data['name'];
        $form->logo=$data['logo'];
        $form->status=$data['status'];
        $form->role_id=$data['role_id'];
        $form->tel=$data['tel'];
        $form->phone=$data['tel'];
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function storeDelete(){
        $data = request()->only(['id']);
        $rule = [
            'id|ID' => 'require|integer',
        ];
        try {
            $this->validate($data, $rule);
        } catch (ValidateException $e) {
            return fetchJson([], $e->getError(), 1);
        }
        BypassAccount::where(['id'=>$data['id'],'acid'=>$this->acid])->update(['is_delete'=>1]);
        return fetchJson([],'删除成功');
    }
    //状态变更
    public function storeChange(){
        $data = request()->only(['id', 'status']);
        $rule = [
            'id|ID' => 'require|integer',
            'status|状态' => 'in:0,10', //0启用10禁用
        ];
        try {
            $this->validate($data, $rule);
        } catch (ValidateException $e) {
            return fetchJson([], $e->getError(), 1);
        }
        //TODO 操作权限
        BypassAccount::update(['status'=>$data['status']],['id'=>$data['id'],'acid'=>$this->acid]);
        return fetchJson([],'保存成功');
    }
    //信息
    public function info(){
        $data=BypassAccount::where('id',$this->admin->id)->field('name,logo,account')->find();
        return fetchJson($data);
    }
    //信息
    public function infoSave(){
        try {
            $data=request()->post();
            $rule = [
                'name|名称' =>'require',
                'account|账号' =>'require',
                'logo|LOGO' =>'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=BypassAccount::where('id',$this->admin->id)->find();
        if(BypassAccount::where(['acid'=>$this->acid,'store_id'=>0,'account'=>$data['account'],'is_delete'=>0])->where('id','<>',$form->id)->count()){
             return fetchJson([],'该账号已存在',1);
        }
        $form->account=$data['account'];
        $form->name=$data['name'];
        $form->logo=$data['logo'];
        if(input('password')){
             $form->password=md5($data['password']);
        }
        $form->save();
        return fetchJson([],'保存成功');
    }
}
