<?php
namespace app\shared\logic\platform;
use app\shared\model\Bill;
use app\shared\model\User;
use app\shared\model\Store;
use app\shared\model\HouseOrder;
use app\shared\model\CardOrder;
use app\shared\model\GoodsOrder;
use app\repast\model\GoodsOrder as RepastGoodsOrder;
use app\shared\model\StoreRechargeOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\CompanionOrder;
use app\shared\model\Withdraw;
use app\shared\model\TeaSpecialist;
use app\shared\model\RechargeOrder;
use think\exception\ValidateException;
use app\BaseController;
class BillForm extends  Base
{
    //获取数据
    public  function index(){
        $query=Bill::where(['acid'=>$this->acid,'is_delete'=>0]);
        $type=input('type');
        if($type>0){
            $query->where('type',$type); 
        }
        $store_id=input('store_id');
        if($store_id){
            $query=$query->where(['form_id'=>$store_id,'account_type'=>2]);
        }else{
           $account_type=input('account_type');
           if($account_type>0){
              $query->where('account_type',$account_type);    
           }
        }
        $start_time=input('start_time');
        $end_time=input('end_time');
        if($start_time&&$end_time){
          $query->whereBetweenTime('create_time',$start_time,$end_time);
        }
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
           if($value['account_type']==3){
              $user=User::where('id',$value['form_id'])->field('avatar_url,nickname,account')->find();
              $value['logo']=$user['avatar_url'];
              $value['name']=$user['nickname'];
              $value['account']=$user['account'];
           }
           if($value['account_type']==2){
              $store=Store::where('id',$value['form_id'])->field('logo,name,account')->find();
              $value['logo']=get_file_url($store['logo']);
              $value['name']=$store['name'];
              $value['account']=$store['account'];  
           }
           if($value['account_type']==4){
              $teaSpecialist=TeaSpecialist::where('id',$value['form_id'])->field('avatar_url,nickname,account')->find();
              $value['logo']=$teaSpecialist['avatar_url'];
              $value['name']=$teaSpecialist['nickname'];
              $value['account']=$teaSpecialist['account']; 
           }
           switch ($value['type']) {
             case '1'://茶室
               $value['order']=HouseOrder::where('id',$value['order_id'])->find();
               break;
            case '2'://充值
                if($value['order_id']==0){
                    $value['order']['title']="后台充值";
                }else{
                    $value['order']=RechargeOrder::where('id',$value['order_id'])->find();  
                } 
               break;
             case '3'://提现
               $value['order']=Withdraw::where('id',$value['order_id'])->find();
               break;

             case '6'://茶室续单
               $order=HouseOrderContinue::where('id',$value['order_id'])->find();
               $value['order']=HouseOrder::where('id',$order['order_id'])->find();
               $value['order']['order_no']=$value['order']['order_no'].'  |续单订单号'.$order['order_no'];
               $value['order']['start_time']=$order['start_time'];
               $value['order']['end_time']=$order['end_time'];
               break;
             case '9'://茶室
               $value['order']=HouseOrder::where('id',$value['order_id'])->find();
               break;  
             case '8'://会员卡
               $order=CardOrder::where('id',$value['order_id'])->find();
               $order['xml_array']=@json_decode($order['xml_array'],1);
               $value['order']=$order;
               break;
             case '7'://商品订单
               $order=GoodsOrder::where('id',$value['order_id'])->find();
               $order['xml_array']=@json_decode($order['xml_array'],1);
               $value['order']=$order;
               break;  
             case '13'://门店充值
               $order=StoreRechargeOrder::where('id',$value['order_id'])->find();
               $order['xml_array']=@json_decode($order['xml_array'],1);
               $value['order']=$order;
               break;
             case '14'://商户储值卡茶室消费
               $value['order']=HouseOrder::where('id',$value['order_id'])->find();
                break;    
             case '18'://扫码点单
               $order=RepastGoodsOrder::where('id',$value['order_id'])->find();
               $order['xml_array']=@json_decode($order['xml_array'],1);
               $value['order']=$order;
               break;
             case '20'://商户储值卡茶室消费
               $order=HouseOrderContinue::where('id',$value['order_id'])->find();
               $value['order']=HouseOrder::where('id',$order['order_id'])->find();
               $value['order']['order_no']=$value['order']['order_no'].'  |续单订单号'.$order['order_no'];
               $value['order']['start_time']=$order['start_time'];
               $value['order']['end_time']=$order['end_time'];
                break;
             case '25'://约搭拼场
                $value['order']=CompanionOrder::where('id',$value['order_id'])->find();
                if(!$value['order']){
                    $value['order']=HouseOrder::where('id',$value['order_id'])->find();
                }
                break;                      
             default:
              $value['order']=[
                'price'=>'',
                'order'=>'',
              ];
               break;
           }
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }

}