<?php
namespace app\shared\logic\platform;
use app\shared\model\Agreement;
use think\exception\ValidateException;
use app\BaseController;
class AgreementForm extends  Base
{
    //获取数据
    public  function index(){
        $type=input('type')?input('type'):1;
        $query=Agreement::where(['acid'=>$this->acid,'is_delete'=>0,'type'=>$type]);
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=Agreement::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'title|名称'=>'require',
                'content|内容'=>'require',
                'type|类型'=>'number|in:1,2,3'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new Agreement();
            $form->acid=$this->acid;
        }
        $form->title=$data['title'];
        $form->type=$data['type'];
        $form->content=$data['content'];
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         Agreement::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
}