<?php
namespace app\shared\logic\pay;
use app\shared\model\HouseOrder;
use app\shared\model\TeaSpecialistOrder;
use app\shared\model\TeaSpecialist;
use app\shared\model\App;
use app\shared\model\House;
use app\shared\model\Option;
use app\shared\model\User;
use app\shared\model\HouseRoom;
use app\shared\model\HouseRoomStock;
use app\shared\model\CouponUser;
use app\shared\model\Bill;
use app\shared\model\Store;
class TeaSpecialistOrderForm
{
    //获取数据
    public  function saveOrder($order_no='',$xml_array=[]){
        $order=TeaSpecialistOrder::where('order_no',$order_no)->find();
        if(!$order){
            echo "success";
            exit();
        }
        if($order->is_pay==1){
          if($order->pay_type==1){
                echo "success";
                exit();
            }else{
                return "success";
            }
        }
        $order->pay_time=time();
        $order->status=1;
        $order->xml_array=json_encode($xml_array);
        $order->is_pay=1;
        $order->save();
        $user=User::where('id',$order->house_order_id)->find();
        // //优惠券
        CouponUser::where(['id'=>$order->coupon_user_id])->update(['is_use'=>1,'use_time'=>time()]);
        self::decUserBill($order);
        $app=App::where(['id'=>$order->acid])->find()->toArray();
        $wx_template_new_tea_specia_order_inform=Option::get_data($order->acid,'platform','wx_template_new_tea_specia_order_inform');
        $app['wx_template_tea_specia_order_inform']=$wx_template_new_tea_specia_order_inform?$wx_template_new_tea_specia_order_inform:Option::get_data($order->acid,'platform','wx_template_tea_specia_order_inform');
        $teaSpecialist=TeaSpecialist::where(['id'=>$order->tea_specialist_id])->column('wx_open_id,account,id');
        $openid=array_column($teaSpecialist,'wx_open_id');
        $phones=array_column($teaSpecialist,'account');
        $app['acid']=$order['acid'];
        //发送茶艺师人员
        $weixin=new \weixin\Wechat();
        $data=[
            "keyword1" =>[
              "value"  =>$user['nickname'],//客人姓名
              "color"  =>"#173177"
            ],
            "keyword2" =>[
              "value"  =>$user['account'],//客人电话
              "color"  =>"#173177"
            ],
            "keyword3" =>[
              "value"  =>"共享茶室",//房间
              "color"  =>"#173177"
            ],
            "thing16"=>[
                'value'=>$user['nickname'],//客人姓名
            ],
            "phone_number8"=>[
                'value'=>$user['account'],//联系电话
            ],
            "thing12"=>[
                'value'=>"共享茶室-茶艺师服务",//客人姓名
            ],
            "time4"=>[
                'value'=>date('Y-m-d H:i',$order->start_time).'~'.date('Y-m-d H:i',$order->end_time),
            ],
        ];
        $res=$weixin->sendWxopenTemplatePro($app,$app['wx_template_tea_specia_order_inform'],$openid,"teaMasterPort/navBar/Footer",$data);
        $res2=$weixin->atroomMsg($phones,$data,2);
        return "success";
    }
    //减少用账单
    public function decUserBill($order=[]){
        $user=User::where('id',$order['user_id'])->find();
        if($order->pay_type==2){
            $user->money-=$order['pay_price'];
            $user->save();
        }
        (new Bill())->save([
            'acid'=>$order->acid,
            'type'=>Bill::TYPE_TEASPECIALIST,
            'account_type'=>Bill::ACCOUNT_TYPE_USER,
            'form_id'=>$order['user_id'],
            'order_id'=>$order['id'],
            'price'=>$order['pay_price'],
            'price_type'=>$order['pay_type'],
            'balance'=>$user->money,
            'status'=>-1,
            'des'=>'用户: '.$user->nickname.'茶艺师预约'
        ]);
    }
}