<?php

namespace app\shared\logic\pay;
use app\shared\model\StoreRechargeOrder;
use think\exception\ValidateException;
use app\shared\model\User;
use app\shared\model\Store;
use app\shared\model\StoreUserMoney;
use app\shared\model\Bill;
use app\shared\model\Card;
use app\shared\model\CardUser;
use app\shared\model\Coupon;
use app\shared\model\StoreCoupon;
use app\shared\model\App;
use app\shared\model\WxpayAccounting;
use wechatpay\WechatPay;
use app\BaseController;
use think\facade\Db;
class StoreRechargeOrderForm{
	//支付回调
	public function saveOrder($order_no=null,$xml_array=[]){
		      $order=StoreRechargeOrder::where('order_no',$order_no)->find();
          if(!$order){
            echo "success";
            exit();
          }
          if($order->is_pay==1){
            echo "success";
            exit();
          }
          $order->is_pay=1;
          $order->pay_time=time();
          $order->xml_array=json_encode($xml_array);
          $order->status=1;
          $order->save();
          $user=User::where('id',$order->user_id)->find();
          $store=Store::where('id',$order['store_id'])->find();
          $money=$order->money+$order->give_price;
          
          $storeUser=StoreUserMoney::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'user_id'=>$order->user_id])->find();
          if(!$storeUser){
            $storeUser=new StoreUserMoney();
            $storeUser->acid=$order->acid;
            $storeUser->user_id=$order->user_id;
            $storeUser->store_id=$order->store_id;
            $storeUser->money=0;
            $storeUser->tea_money=0;
          }
          $storeUser->money=$storeUser->money+$money;
          $storeUser->tea_money+=$order->give_tea_price;
          $storeUser->save();
          $des="用户:【{$user['nickname']}】充值[{$store->name}] 储值卡金额";
          if($order->give_tea_price){
            $des="用户:【{$user['nickname']}】充值[{$store->name}] 储值卡金额 获得茶叶金{$order->give_tea_price}";
          }
          (new Bill())->save([
              'acid'=>$order->acid,
              'type'=>Bill::TYPE_STORE_USER_RECHARGE,
              'account_type'=>Bill::ACCOUNT_TYPE_USER,
              'form_id'=>$order->user_id,
              'order_id'=>$order->id,
              'price'=>$money,
              'price_type'=>1,
              'balance'=>$storeUser->money,
              'status'=>1,
              'des'=>$des
          ]);
          
          self::addStoreBill($order,$store);
          //赠送商户优惠券
          StoreCoupon::giveUserCoupon($order->user_id,5,$order->acid,$order->coupon_ids);  
          self::addPlatformCardCoupon($order);
          echo "success";
	}
  //添加平台会员卡跟优惠券
  public function addPlatformCardCoupon($order=[]){
         $card_list=Card::where('id','in',$order->card_ids)->where(['acid'=>$order->acid,'is_delete'=>0])->select();
         foreach ($card_list as $card){
            $cardUser=CardUser::where([
                'card_id'=>$card->id,
                'user_id'=>$order->user_id,
                'acid'=>$order->acid
            ])->find();
            if($card->month<=0){
                $card->month=1;
            }
            if(!$cardUser){
                $cardUser=new CardUser();
                $cardUser->card_id=$card->id;
                $cardUser->user_id=$order->user_id;
                $cardUser->acid=$order->acid;
                $cardUser->start_time=time();
                $cardUser->end_time=strtotime(date("Y-m-d",strtotime("+{$card->month} month")));
                $cardUser->status=1;
                $cardUser->hour=$card->hour;
            }else{
                $time=strtotime(date("Y-m-d",strtotime("+{$card->month} month")))-strtotime(date("Y-m-d",time()));
                if($cardUser->end_time<time()){
                    $cardUser->end_time=time()+$time;
                }else{
                    $cardUser->end_time+=$time;
                }
                $cardUser->status=1;
                $cardUser->hour+=$card->hour;
            }
            $cardUser->level=$card->level;
            $cardUser->save();
         }
         if($order->platform_coupon_ids){
            Coupon::giveUserCoupon($order->user_id,4,$order->acid,$order->platform_coupon_ids);
         }
  }
  //增加商户账单
  public function addStoreBill($order=[],$store=[]){
        $fee=($store->fee*0.01)*$order['money'];
        $fee=$fee>0?$fee:0;
        if($order['pay_type']==1&&$order['sub_account_status']==1){
            return false;
        }else{
            (new Bill())->save([
              'acid'=>$order['acid'],
              'type'=>Bill::TYPE_STORE_USER_RECHARGE,
              'account_type'=>Bill::ACCOUNT_TYPE_STORE,
              'form_id'=>$order['store_id'],
              'order_id'=>$order['id'],
              'price'=>$order['money']-$fee,
              'price_type'=>1,
              'status'=>1,
              'fee'=>$fee,
              'des'=>'商户: 【'.$store->name.'】用户充值余额收入'
            ]);
        }  
        $store->money+=$order['money']-$fee;
        $store->save();
    }
}