<?php
namespace app\shared\logic\pay;
use app\shared\model\PartnerOrder;
use app\shared\model\PartnerUser;
use app\shared\model\Partner;
use app\shared\model\PartnerUserBill;
use app\shared\model\User;
use app\shared\model\Bill;
class PartnerOrderForm
{
    //获取数据
    public  function saveOrder($order_no='',$xml_array=[]){
        $order=PartnerOrder::where('order_no',$order_no)->find();
        if(!$order)return '';
        if($order->is_pay==1){
           if($order->pay_type==1){
                echo "success";
                exit();
            }else{
                return "success";
            }
        }
        $order->is_pay=1;
        $order->status=1;
        $order->pay_time=time();
        $order->xml_array=json_encode($xml_array);
        $order->save();
        $partnerUser=PartnerUser::where([
            'partner_id'=>$order->partner_id,
            'user_id'=>$order->user_id,
            'acid'=>$order->acid
        ])->find();
        if($order->month<=0){
            $order->month=1;
        }
        if(!$partnerUser){
            $partnerUser=new PartnerUser();
            $partnerUser->partner_id=$order->partner_id;
            $partnerUser->user_id=$order->user_id;
            $partnerUser->acid=$order->acid;
            $partnerUser->start_time=time();
            $partnerUser->end_time=$order->month<=1?-1:$partnerUser->start_time+($order->month*86400);
            $partnerUser->money=$order->money;
            $partnerUser->everyday_hour=$order->everyday_hour;
            $partnerUser->give_lngot=$order->sum_lngot;
            $partnerUser->everyday_lngot=$order->everyday_lngot;
            //$user_parent_id=User::where(['id'=>$order->user_id])->value('parent_id');
            // $parent=PartnerUser::where(['user_id'=>$user_parent_id])->find();
            // if($parent){
            //     $partnerUser->parent_id=$parent->id;
            //     self::shareBill($order,$parent);
            // }
        }else{
            $time=($order->month*86400);
            if($order->month<=-1){
                $partnerUser->end_time=-1;
            }else{
                if($partnerUser->status==0){
                    $partnerUser->end_time=time()+$time;
                }else{
                    $partnerUser->end_time+=$time;
                }
            }
            $partnerUser->money+=$order->money;
            $partnerUser->give_lngot+=$order->sum_lngot;
            $partnerUser->everyday_lngot=$order->everyday_lngot;
        }
        $partnerUser->status=1;
        $partnerUser->title=$order->title;
        $partnerUser->save();
        self::decUserBill($order,$partnerUser);
        if($order->pay_type==1){
            echo "success";
            exit();
        }else{
            return "success";
        }
    }
     //减少用户账单
    public function decUserBill($order=[],$partnerUser=[]){
        $user=User::where('id',$order['user_id'])->find();
        if($order->pay_type==2){
            $user->money-=$order['price'];
            $user->save();
        }
        $balance=$user->money;
        (new Bill())->save([
            'acid'=>$order->acid,
            'type'=>Bill::TYPE_PARTNER,
            'account_type'=>Bill::ACCOUNT_TYPE_USER,
            'form_id'=>$order['user_id'],
            'order_id'=>$order['id'],
            'price'=>$order['price'],
            'price_type'=>$order['pay_type'],
            'balance'=>$balance,
            'status'=>-1,
            'des'=>'用户: '.$user['nickname'].'成为合伙人'
        ]);
        $partner=Partner::where(['id'=>$partnerUser->partner_id])->find();
        $partnerUser->give_lngot-=$partner->first_lngot;
        $partnerUser->sum_lngot+=$partner->first_lngot;
        $partnerUser->save();
        (new PartnerUserBill())->save([
            'acid'=>$order->acid,
            'user_id'=>$partnerUser->id,
            'order_id'=>$order->id,
            'title'=>'成为合伙人',
            'lngot'=>$partner->first_lngot,
            'price'=>0,
            'status'=>1
        ]);
    }
    

}