<?php
namespace app\shared\logic\pay;
use app\shared\model\HouseOrder;
use app\shared\model\ShareOrder;
use app\shared\model\House;
use app\shared\model\WeixinUser;
use app\shared\model\User;
use app\shared\model\Option;
use app\shared\model\App;
use app\shared\model\HouseRoom;
use app\shared\model\CouponUser;
use app\shared\model\StoreCoupon;
use app\shared\model\StoreCouponUser;
use app\shared\model\StoreCleaning;
use app\shared\model\CardUserOrder;
use app\shared\model\CardUser;
use app\shared\model\CardCoupon;
use app\shared\model\CardCouponOrder;
use app\shared\model\StoreUserMoney;
use app\shared\model\HouseStock;
use app\shared\model\HouseStockOem;
use app\shared\model\HouseRoomStock;
use app\shared\model\Bill;
use app\shared\model\Store;
use app\shared\model\PartnerUser;
use app\shared\model\PartnerUserOrder;
use app\shared\model\PartnerUserBill;
use app\shared\model\Electricity;
use app\shared\model\ElectricityLine;
use app\shared\model\LumiElectricityConfig;
use app\shared\model\Companion;
use app\shared\model\CompanionCategory;
use app\shared\model\CompanionOrder;
use think\facade\Cache;
use app\plugin\model\stock\User as StockUser;
use app\plugin\model\stock\House as StockHouse;
use app\plugin\model\stock\HouseUser as StockHouseUser;
use app\plugin\model\stock\HouseUserOrder as StockHouseUserOrder;
class HouseOrderOemForm
{
    
     public function timePus($start_time='',$end_time='',$book_interval_status=1){
         $dateHi=[];
         $start_time_H=strtotime(date('Y-m-d H',$start_time).':00');
         if($start_time>$start_time_H&&$start_time<$start_time_H+1800){
            $start_time=$start_time_H;
         }
         if($start_time>$start_time_H+1800&&$start_time<$start_time_H+3600){
            $start_time=$start_time_H+1800;
         }
         $end_time_H=strtotime(date('Y-m-d H',$end_time).':00');
         if($end_time<$end_time_H+1800){
            if($end_time>($end_time_H+900)){
                $end_time=$end_time_H+1800;
            }
         }
         if($end_time>$end_time_H+1800&&$end_time<$end_time_H+3600){
            if($end_time>($end_time_H+1800+900)){
                 $end_time=$end_time_H+3600;
            }
         }
         $numB=($end_time-$start_time)/1800;
         if($book_interval_status){
            $numB=$numB+1;
            $x=0;
         }else{
            $x=0;
         }
         for ($j=$x;$j<$numB;$j++){
           $time=$start_time+(1800*$j);
           //$dateHi[date('Y-m-d H:i',$time)]=$time;
           $dateHi[]=$time;
         }
         return $dateHi;
    }
    //获取数据
    public  function saveOrder($order_no='',$xml_array=[]){
        $order=HouseOrder::where('order_no',$order_no)->find();
        if(!$order){
            echo "success";
            exit();
        }
        if($order->is_pay==1){
           if($order->pay_type==1){
                echo "success";
                exit();
            }else{
                return "success";
            }
        }
        $order->pay_time=time();
        $order->status=1;
		$order->pay_price=$order->pay_price>0?$order->pay_price:0;
        $order->xml_array=json_encode($xml_array);
        $order->is_pay=1;
        $order->save();
        //优惠券
        CouponUser::where(['id'=>$order->coupon_user_id])->update(['is_use'=>1,'use_time'=>time(),'order_id'=>$order->id]);
        $storeCouponUser=StoreCouponUser::where(['id'=>$order->store_coupon_user_id])->find();
        if($storeCouponUser){
            $order->price-=$storeCouponUser->discounts_price;
            $order->save();
            if($storeCouponUser->type==4){
                $storeCouponUser->verifier_code=StoreCouponUser::createCode();
            }
            $storeCouponUser->save(['is_use'=>1,'use_time'=>time(),'order_id'=>$order->id]);
        }
        $is_hotel=0;
        if(isset($order->type)){
            if($order->type==2){
                $is_hotel=1;
            }
        }
        if($is_hotel){
            $monthDate=monthDate($order->start_time,$order->end_time);
            $house_price=House::where('id',$order->house_id)->value('price');
            $stockInsert=[];
            foreach($monthDate as $day){
                $stock=HouseRoomStock::where([
                    'acid'=>$order->acid,
                    'date'=>$day,
                    'house_id'=>$order->house_id,
                    'store_id'=>$order->store_id,
                ])->find(); 
                if($stock){
                    $stock->status=1;
                    $stock->house_type=1;
                    $stock->order_id=$order->id;
                    $stock->save();
                }else{
                     $stockInsert[]=[
                        'acid'=>$order->acid,
                        'date'=>$day,
                        'house_id'=>$order->house_id,
                        'store_id'=>$order->store_id,
                        'status'=>1,
                        'price'=>$house_price,
                        'house_type'=>1,
                        'order_id'=>$order->id,
                        'create_time'=>time(),
                        'update_time'=>time(),
                    ];
                }
            }
            HouseRoomStock::insertAll($stockInsert);
        }else{
            $book_interval_status=Store::where('id',$order->store_id)->value('book_interval_status');
            $book_interval_status=$book_interval_status==0?0:1;
            
            $oem=HouseStockOem::where('order_id',$order->id)->find();
            if(!$oem){
                $oem=new HouseStockOem();
                $oem->save([
                    'acid'=>$order->acid,
                    'house_id'=>$order->house_id,
                    'store_id'=>$order->store_id,
                    'start_time'=>$order->start_time,
                    'end_time'=>$order->end_time,
                    'order_id'=>$order->id,
                ]);
            }
        }
        self::decUserBill($order);
        self::sendSubscribe($order);
        //卡券处理
        $cardCoupon=CardCoupon::where(['id'=>$order->card_coupon_id])->find();
        if($cardCoupon){
            if($cardCoupon->start_time<time()&&$cardCoupon->end_time>time()){
                $cardCoupon->num-=1;
                if($cardCoupon->num<=0){
                    $cardCoupon->status=0;
                }
            }else{
                 $cardCoupon->status=0;
            }
            $cardCoupon->save();
            CardCouponOrder::where(['order_id'=>$order->id])->update(['status'=>1,'use_time'=>time()]);
        }
        //更新合伙人订单状态
        self::partnerOrderBill($order);
        self::thatIsOrder($order);

        
        
        $snapshoot=@json_decode($order->snapshoot,1);
        $title=isset($snapshoot['name'])?$snapshoot['name']:'';
        self::createCompanion($order);
        \app\shared\model\Message::pushMsg($order->acid,\app\shared\model\Message::ACCOUNT_TYPE_USER,\app\shared\model\Message::TYPE_HOUSE,$order->id,$order->user_id,$title,'空间下单通知');
        if($order->pay_type==1){
            echo "success";
            exit();
        }else{
            $order->sub_account_status=0;
            $order->save();
            return "success";
        }
    }
    private function createCompanion($order=[])
    {
        try {
            $snapshoot=@json_decode($order->snapshoot,1);
            $title=isset($snapshoot['name'])?$snapshoot['name']:'';
            if(isset($order->is_formation)){
                if($order->is_formation==1){
                    $user=User::where('id',$order->user_id)->field('nickname,account')->find();
                    $store=Store::where('id',$order->store_id)->field('area_id')->find();
                    $categoryName=CompanionCategory::where('id',$order->formation_category)->value('name');
                    $form=new Companion();
                    $data=[
                      'acid'=>$order->acid,
                      'user_id'=>$order->user_id,
                      'store_id'=>$order->store_id,
                      'house_order_id'=>$order->id,
                      'city_id'=>$store['area_id'],
                      'category_name'=>$categoryName,
                      'category_id'=>$order->formation_category,
                      'title'=>$title.'空间组局',
                      'describe'=>$snapshoot['store_info']['name'].'空间组局',
                      'date'=>date('Y-m-d',$order->start_time),
                      'start_time'=>$order->start_time,
                      'end_time'=>$order->end_time,
                      'place'=>$snapshoot['store_info']['address'],
                      'address'=>'',
                      'people_type'=>4,
                      'man_num'=>$order->formation_num,
                      'woman_num'=>$order->formation_num,
                      'pay_types'=>1,//微信支付
                      'consume_types'=>1,
                      'tel'=>$user['account'],
                      'cash_price'=>0,
                      'price'=>$order->pay_price/$order->formation_num,
                      'organizer_type'=>1,//玩家
                      'username'=>$user['nickname'],
                      'status'=>1,
                      'lat'=>isset($snapshoot['store_info']['lat'])?$snapshoot['store_info']['lat']:'',
                      'lng'=>isset($snapshoot['store_info']['lng'])?$snapshoot['store_info']['lng']:'',
                    ];
                    $form->save($data);
                    $companionOrder=new CompanionOrder();
                    $companionOrder->acid=$order->acid;
                    $companionOrder->pay_price=0;
                    $companionOrder->order_no=CompanionOrder::crateOrderNo();
                    $companionOrder->user_id=$order->user_id;
                    $companionOrder->username=$user['nickname'];
                    $companionOrder->start_time=$order->start_time;
                    $companionOrder->end_time=$order->start_time;
                    $companionOrder->store_id=$order->store_id;
                    $companionOrder->status=2;
                    $companionOrder->pay_type=2;
                    $companionOrder->sex="男";
                    $data['start_time']=date('Y-m-d H:i',$data['start_time']);
                    $data['end_time']=date('Y-m-d H:i',$data['end_time']);
                    $companionOrder->save([
                        'companion_id'=>$form->id,
                        'snapshoot'=>json_encode($data,JSON_UNESCAPED_UNICODE)
                    ]);
                }
            }
        } catch (Exception $e) {
            
        }
        
    }
    //更新合伙人订单状态
    public function partnerOrderBill($order=[]){
        $partnerOrder=PartnerUserOrder::where(['order_id'=>$order->id])->find();
        if($partnerOrder){
            $partnerOrder->status=1;
            $partnerOrder->save();
            $partnerUser=PartnerUser::where(['id'=>$partnerOrder->user_partner_id])->find();
            if($partnerUser){
                $partnerUser->money-=$partnerOrder->price;
                $partnerUser->money=$partnerUser->money<0?0:$partnerUser->money;
                $partnerUser->save();
                (new PartnerUserBill())->save([
                    'acid'=>$order->acid,
                    'user_id'=>$order->user_id,
                    'order_id'=>$order->id,
                    'title'=>'空间订单消费',
                    'price'=>$partnerOrder->price,
                    'status'=>-1
                ]);
            }
        }
    }
    //增加商户账单
    public function addStoreBill($order=[]){
        $store=Store::where('id',$order['store_id'])->find();
        $fee=($store->fee*0.01)*$order['price'];
        $fee=$fee>0?$fee:0;//手续费
        $orderPrice=$order->price-$fee; //总金额   
        $stockHouse=StockHouseUser::alias('h_u')
               ->leftJoin([StockHouse::getTable()=>'h'],'h_u.stock_house_id=h.id')
               ->where(['h_u.acid'=>$order->acid,'h.house_id'=>$order->house_id,'h_u.is_delete'=>0,'h.is_delete'=>0])
               ->field('h_u.stock_user_id,h_u.ratio,h.house_id,h_u.stock_house_id')
               ->select()
               ->toArray();
        //分红金额
        $sharePrice=0;           
        foreach($stockHouse as $hu){
           (new StockHouseUserOrder())->save([
              'acid'=>$order->acid,
              'type'=>1,
              'order_id'=>$order->id,
              'stock_house_id'=>$hu['stock_house_id'],
              'stock_user_id'=>$hu['stock_user_id'],
              'ratio'=>$hu['ratio'],
              'price'=>$hu['ratio']*$orderPrice*0.01, 
            ]);
           $user=StockUser::where('id',$hu['stock_user_id'])->field('money,total_price')->find();
           if($user){
             $user->money+=$hu['ratio']*$orderPrice*0.01;
             $user->total_price+=$hu['ratio']*$orderPrice*0.01;
             $user->save();
           }
           $sharePrice+=$hu['ratio']*$orderPrice*0.01;
        }  
        if($sharePrice>0){
            (new Bill())->save([
                'acid'=>$order['acid'],
                'type'=>Bill::TYPE_HOUSE,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order['store_id'],
                'order_id'=>$order['id'],
                'price'=>$orderPrice-$sharePrice,
                'price_type'=>$order['pay_type'],
                'status'=>1,
                'fee'=>$fee,
                'des'=>'商户: 【'.$store->name.'】空间收入其中股东分红扣除'.$sharePrice.'元'
            ]);
            $store->money+=$orderPrice-$sharePrice;
        }else{
            (new Bill())->save([
                'acid'=>$order['acid'],
                'type'=>Bill::TYPE_HOUSE,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order['store_id'],
                'order_id'=>$order['id'],
                'price'=>$orderPrice-$sharePrice,
                'price_type'=>$order['pay_type'],
                'status'=>1,
                'fee'=>$fee,
                'des'=>'商户: 【'.$store->name.'】空间收入'
            ]);
            $store->money+=$orderPrice-$sharePrice;
        }        
        $store->save();
    }
    //减少用账单
    public function decUserBill($order=[]){
        $user=User::where('id',$order['user_id'])->find();
        
        if($order->pay_type==2){
            $user->money-=$order['pay_price'];
            $user->save();
        }
        $balance=$user->money;
        if($order->pay_type==3){
            $userStore=StoreUserMoney::where(['store_id'=>$order->store_id,'user_id'=>$order->user_id])->find();
            if($userStore){
                
                $userStore->money-=$order['pay_price'];
                $userStore->save();
                $balance=$userStore->money;
            }
        }
        $cardUserOrder=CardUserOrder::where(['order_id'=>$order['id'],'type'=>1])->find();
        if($cardUserOrder){
            $cardUserOrder->status=1;
            $cardUserOrder->save();
            $cardUser=CardUser::where('id',$cardUserOrder->card_user_id)->find();
            if($cardUser){
                $cardUser->hour-=$cardUserOrder['hour'];
                $cardUser->hour=$cardUser->hour<0?0:$cardUser->hour;
                $cardUser->save();
            }
        }
        if($order['pay_price']>0){
            (new Bill())->save([
                'acid'=>$order->acid,
                'type'=>$order->pay_type==3?Bill::TYPE_STORE_USER_HOUSE:Bill::TYPE_HOUSE,
                'account_type'=>Bill::ACCOUNT_TYPE_USER,
                'form_id'=>$order['user_id'],
                'order_id'=>$order['id'],
                'price'=>$order['pay_price'],
                'price_type'=>$order['pay_type'],
                'balance'=>$balance,
                'status'=>-1,
                'des'=>'用户: 【'.$user->nickname.'】空间预订'
            ]);
        }
    }
    public function  shareOrder($order=[]){
        if($order->pay_type==3){
            return 0;
        }
        $share_setting=Option::get_data($order->acid,'platform','app_share_setting');
        $share_setting=@json_decode($share_setting,1);
        if(isset($share_setting['status'])){
             if($share_setting['status']){
                //一级
                $parent1_id=User::where('id',$order->user_id)->value('parent_id');
                if($share_setting['one']>0){
                    if($parent1_id){
                        $price=$share_setting['one']*0.01*$order->price;
                        self::shareUserMoney($order,$parent1_id,$price,$order->user_id);
                    }
                }
                //二级
                if($share_setting['two']>0){
                    if($parent1_id){
                        $parent2_id=User::where('id',$parent1_id)->value('parent_id');
                        $price=$share_setting['one']*0.01*$order->price;
                        if($parent2_id){
                            self::shareUserMoney($order,$parent2_id,$price,$parent1_id);
                        }
                    }
                }
             }
        }
    }
    public function shareUserMoney($order=[],$user_id=0,$price=0,$child_userid=0){
        if($order->pay_type==3){
            return 0;
        }
        if($price>0){
            $user=User::where('id',$user_id)->find();
            if(!$user){
                return false;
            }
            $user->price+=$price;
            $user->total_price+=$price;
            $user->save();
            $shareOrder=new ShareOrder();
            $shareOrder->save([
                'acid'=>$order->acid,
                'user_id'=>$user_id,
                'form_user_id'=>$child_userid,
                'user_type'=>ShareOrder::USER_TYPE_USER,
                'type'=>ShareOrder::TYPE_HOUSE,
                'order_id'=>$order->id,
                'price'=>$price,
                'status'=>2,
                'pay_time'=>time()
            ]);
            (new Bill())->save([
                'acid'=>$order->acid,
                'type'=>Bill::TYPE_SHARE,
                'account_type'=>Bill::ACCOUNT_TYPE_USER,
                'form_id'=>$user_id,
                'order_id'=>$shareOrder->id,
                'price'=>$price,
                'price_type'=>$order['pay_type'],
                'status'=>1,
                'des'=>'分销佣金:空间预订'
            ]);
        }
    }
   public function sendSubscribe($order=[]){
        set_time_limit(0);
        $account=User::where(['id'=>$order->user_id])->value('account');
        $openid=WeixinUser::where(['mobile'=>$account])->value('wxapp_open_id');
        $snapshoot=@json_decode($order->snapshoot,1);
        $app=App::where('id',$order->acid)->field('id acid,wx_app_id,wx_app_secret,wxapp_app_id,wxapp_app_secret')->find();
        $app['wx_subscibe_book_finish']=Option::get_data($order->acid,'platform','wx_subscibe_book_finish');
        $app['wx_subscibe_book_overtime']=Option::get_data($order->acid,'platform','wx_subscibe_book_overtime');
        $app['wx_subscibe_book_inform']=Option::get_data($order->acid,'platform','wx_subscibe_book_inform');
        $app['wx_subscibe_book_sweep']=Option::get_data($order->acid,'platform','wx_subscibe_book_sweep');

        $wx_template_new_cleaning_inform=Option::get_data($order->acid,'platform','wx_template_new_cleaning_inform');
        $wx_template_new_cleaning_port_inform=Option::get_data($order->acid,'platform','wx_template_new_cleaning_port_inform');
        $app['wx_template_cleaning_inform']=$wx_template_new_cleaning_inform?$wx_template_new_cleaning_inform:Option::get_data($order->acid,'platform','wx_template_cleaning_inform');
        $app['wx_template_cleaning_port_inform']=$wx_template_new_cleaning_port_inform?$wx_template_new_cleaning_port_inform:Option::get_data($order->acid,'platform','wx_template_cleaning_port_inform');

        $store=Store::where('id',$order['store_id'])->field('name,openid,store_manager')->find();
        //缓存单个数据
        $listArray=[
            'wx_template'=>[
                'cleaning_inform'=>$app['wx_template_cleaning_inform']//保洁员openid
            ],
            'book_finish'=>0,
            'book_overtime'=>0,
            'book_inform'=>0,
            'order'=>[
                'openid'=>$openid,
                'page'=>'order/orderDetail?id='.$order->id,
                'order_no'=>$order->order_no,
                'title'=>$snapshoot['name'],
                'store_name'=>$store['name'],
                'start_time'=>$order->start_time,
                'end_time'=>$order->end_time,
                'remark'=>'备注',
                'phone'=>$order->tel,
                'cleaning_openid'=>$store['openid']
            ],
            'app'=>$app
        ];
        Cache::set('subscribeOrder'.$order->id,json_encode($listArray));
        $list=Cache::get('subscribeOrder');
        $list=@json_decode($list,1);
        $listArray=[];
        if(!$list){
            $listArray[]=[
                'start_time'=>$order->start_time,
                'end_time'=>$order->end_time,
                'order_id'=>$order->id,
            ];
        }else{
            foreach ($list as $key => $value){
                if(isset($value['end_time'])){
                    if($value['end_time']>time())
                      $listArray[]=$value;
                }
            }
            $listArray[]=[
                'start_time'=>$order->start_time,
                'end_time'=>$order->end_time,
                'order_id'=>$order->id,
            ];
        }
        Cache::set('subscribeOrder',json_encode($listArray));
        
        //发送保洁人员
        $weixin=new \weixin\Wechat();
        $data=[
            "keyword1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
              "color"  =>"#173177"
            ],
            "keyword2" =>[
              "value"  =>"商户".$store['name'],//保洁员：
              "color"  =>"#173177"
            ],
            "keyword3" =>[
              "value"  =>"用户{$account}下单提醒",//保洁类型：
              "color"  =>"#173177"
            ],
            "keyword4" =>[
              "value"  =>'订单时间'.date('m-d H:i',$order->start_time)."\r至".
              date('m-d H:i',$order->end_time), //保洁时间：
              "color"  =>"#173177"
            ],
            "thing7"=>[
                'value'=>$snapshoot['name'],//包厢名称
            ],
            "thing6"=>[
                'value'=>"商户".$store['name'],//门店名称
            ],
            "thing14"=>[
                'value'=>"用户{$account}下单提醒",//客户姓名
            ],
            "time10"=>[
                "value"  =>date('Y-m-d H:i',$order->start_time)//订单时间
            ],
            "time12"=>[
                "value"  =>date('Y-m-d H:i',$order->end_time)//订单时间
            ],
        ];
        $openidArr=explode(',', $store['openid']);

        $res=$weixin->sendWxopenTemplatePro($app,$app['wx_template_cleaning_inform'],$openidArr,"pages/index/index",$data);
        $res2=$weixin->atroomMsg($store['store_manager'],$data,3,$order['order_no']);
        self::sendCleaningTpl($app,$order,$account);
        
    }
    //保洁端用户下单提醒
    public function sendCleaningTpl($app,$order,$account=''){
        set_time_limit(0);
       
        $snapshoot=@json_decode($order->snapshoot,1);
        $store=Store::where('id',$order->store_id)->field('address,name')->find();
        //发送保洁人员
        $weixin=new \weixin\Wechat();
        $data=[
            "keyword1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
              "color"  =>"#173177"
            ],
            "keyword2" =>[
              "value"  =>"用户{$account}下单提醒",//房间地址：
              "color"  =>"#173177"
            ],
            "keyword3" =>[
              "value"  =>'订单时间'.date('m-d H:i',$order->start_time)."\r至".
              date('m-d H:i',$order->end_time), //保洁时间：
              "color"  =>"#173177"
            ],
            "thing1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
            ],
            "thing2" =>[
              "value"  =>"用户{$account}下单提醒",//房间地址：
            ],
            "time4" =>[
              "value"  => date('Y-m-d H:i',$order->start_time)."~".
              date('H:i',$order->end_time),//房间地址：
            ],
        ];
        
        $storeCleaning= StoreCleaning::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'is_delete'=>0,'status'=>1])->where('openid','<>','')->column('openid,account,id');
        $openidArr=array_column($storeCleaning,'openid');
        $phones=array_column($storeCleaning,'account');
        $res=$weixin->sendWxopenTemplatePro($app,$app['wx_template_cleaning_port_inform'],$openidArr,"pages/index/index",$data);
        $res2=$weixin->atroomMsg($phones,$data,1,$order['order_no']);
    }
    public function thatIsOrder($order=[]){
        $house=House::where(['id'=>$order->house_id])->find();
        if($house['electricityid']=="-1"||$house['electricityid']=="0"||$house['electricityid']==''){    
            //绿米
            $ahead_time=$house['ahead_time']*60;
            $forward_time=$house['forward_time']*60;
            self::lvjoinTask($house,$order,$order->start_time,$order->end_time);
            return 0;
        }

        $mac=$house['electricityid'];
        $smart_device=Store::where('id',$order->store_id)->value('smart_device');
        $smart_device=@json_decode($smart_device,1);
        //曼顿取电
        $config=[
            'appKey'=>$smart_device['electronic_mandun_appKey'],
            'appSecret'=>$smart_device['electronic_mandun_appSecret'],
            'uname'=>$smart_device['electronic_mandun_uname'],
            'passwd'=>$smart_device['electronic_mandun_passwd'],
            'projectCode'=>$smart_device['electronic_mandun_projectCode'],
            'api_url'=>$smart_device['electronic_mandun_apiUrl'],
        ];
        $lineList=ElectricityLine::where([
            'acid'=>$house['acid'],
            'store_id'=>$house['store_id'],
            'mac'=>$house['electricityid'],
            'house_id'=>$house['id'],
            'is_delete'=>0
         ])->column('line,ahead_time,forward_time');
        foreach ($lineList as $key => $value) {
           $ahead_time=$value['ahead_time']*60;
           $forward_time=$value['forward_time']*60;
           self::joinTask($order->acid,$house['is_network'],$house['lockid'],$order->id,1,$config,$house['electricityid'],$value['line'],($order->start_time-$ahead_time),($order->end_time+$forward_time));
        }
    }
    //加入任务
    public function joinTask($acid=1,$is_network,$lockid,$order_id,$type,$config,$mac,$line,$start_time,$end_time){
        $form=Electricity::where(['acid'=>$acid,'order_id'=>$order_id,'mac'=>$mac,'line'=>$line])->find();
        if(!$form){
            $form=new Electricity();
            $form->status=0;
            $form->mac=$mac;
            $form->line=$line;
        }
        $form->save([
          'acid'=>$acid,
          'config'=>json_encode($config),
          'order_id'=>$order_id,
          'lockid'=>$lockid,
          'start_time'=>$start_time,
          'end_time'=>$end_time
        ]);
        if($start_time<time()){
             $task=new \app\shared\controller\Task();
             $task->handleOther($form->id,$start_time,$end_time,3);
        }
    }
        //加入绿米任务
    public function lvjoinTask($house,$order,$start_time,$end_time){
        $lumi_electricity_config=LumiElectricityConfig::where([
            'acid'=>$order->acid,
            'store_id'=>$house['store_id'],
            'house_id'=>$house['id'],
            'is_delete'=>0
        ])->column('dev_did,dev_model,resource,ahead_time,forward_time,reset_time');
        $params=[];
        $lvmi_device=Store::where(['id'=>$house['store_id']])->value('lvmi_device');
        $lvmi_device=@json_decode($lvmi_device,1);
        $accessToken=isset($lvmi_device['accessToken'])?$lvmi_device['accessToken']:'';
        $storeConfig=Store::where('id',$house['store_id'])->value('lvmi_developer');
        $storeConfig=@json_decode($storeConfig,1);
        foreach ($lumi_electricity_config as &$vlm){
            $resources=[];
            $resource=@json_decode($vlm['resource'],1);
            foreach ($resource as $v){
              $resources[]=[
                'resourceId'=>$v['resuors'],
                'value'=>$v['status'],
              ];
              $ahead_time=$v['ahead_time']*60;
              $forward_time=$v['forward_time']*60;
              $config=json_encode([
                [
                    'subjectId'=>$vlm['dev_did'],
                    'resources'=>$resources,
                ]
              ]);
              $form=Electricity::where(['acid'=>$order->acid,'order_id'=>$order->id,'config'=>$config])->find();
              if(!$form){
                    $form=new Electricity();
                    $form->status=0;
              }
              $form->save([ 
                  'acid'=>$order->acid,
                  'lvmi_developer'=>json_encode($storeConfig,JSON_UNESCAPED_UNICODE),
                  'config'=>$config,
                  'order_id'=>$order->id,
                  'mac'=>$accessToken,
                  'line'=>-1,
                  'start_time'=>$start_time-$ahead_time,
                  'end_time'=>$end_time+$forward_time,
                  'reset_time'=>$vlm['reset_time']>0?$end_time+$forward_time+($vlm['reset_time']*60):0,
              ]);
              if($form->start_time<time()){
                  $task=new \app\shared\controller\Task();
                 $task->lvhandleOther($form->id,$form->start_time,$form->end_time);
              }
              
           }
        }
    }

}