<?php
namespace app\shared\logic\pay;
use app\shared\model\ShareOrder;
use app\shared\model\WeixinUser;
use app\shared\model\User;
use app\admin\model\Option;
use app\admin\model\App;
use app\shared\model\Bill;
use app\shared\model\CompanionOrder;
use app\plugin\model\stock\User as StockUser;
use app\plugin\model\stock\UserOrder as StockUserOrder;
use app\thousands\model\GoodsAttr;
use think\facade\Cache;
use think\facade\Db;
use app\shared\model\Message;
use wechatpay\WechatPay;
class CompanionOrderForm
{
     //获取数据
    public  function saveOrder($order_no='',$xml_array=[]){
    	$order=CompanionOrder::where('order_no',$order_no)->find();
        if(!$order)return '';
    	if($order->is_pay==1){
           if($order->pay_type==2){
                return "success";
            }else{
                echo "success";
                exit();
            }
        }
        $order->pay_time=time();
        $order->xml_array=json_encode($xml_array);
        if($order->pay_price==0){
            $order->status=1;
        }else{
            $order->status=2;
        }
    	$order->is_pay=1;
        $order->pay_time=time();
        // 启动事务
        Db::startTrans();
        try {
            $order->save();
            self::decUserBill($order);
            // 提交事务
            Db::commit();
            if($order->pay_type==2){
                return "success";
            }else{
                echo "success";
            }
        } catch (Exception $e) {
            // 回滚事务
            Db::rollback();
        }
    	
    }
    //减少用账单
    public function decUserBill($order=[]){
        $user=User::where('id',$order['user_id'])->find();
        if($order->pay_type==2){
            $user->money-=$order['pay_price'];
            $user->save();
        }
        $balance=$user->money;
        (new Bill())->save([
            'acid'=>$order->acid,
            'type'=>Bill::TYPE_COMPANION,
            'account_type'=>Bill::ACCOUNT_TYPE_USER,
            'form_id'=>$order->user_id,
            'order_id'=>$order->id,
            'price'=>$order->pay_price,
            'price_type'=>$order->pay_type,
            'balance'=>$balance,
            'status'=>-1,
            'des'=>'用户: 【'.$user->nickname.'】约搭订单'
        ]);
    }
}