<?php
namespace app\shared\controller;
//测试
use app\shared\model\HouseOrderContinue;
use app\shared\model\HouseOrder;
use app\shared\model\ShareOrder;
use app\shared\model\House;
use app\shared\model\User;
use app\shared\model\WeixinUser;
use app\shared\model\Option;
use app\shared\model\HouseRoom;
use app\shared\model\HouseStock;
use app\shared\model\Bill;
use app\shared\model\App;
use app\shared\model\Store;
use app\shared\model\StoreCleaning;
use app\shared\model\Electricity;
use app\shared\model\ElectricityLine;
use app\shared\model\LumiElectricityConfig;
use app\plugin\model\stock\User as StockUser;
use app\plugin\model\stock\House as StockHouse;
use app\plugin\model\stock\HouseUser as StockHouseUser;
use app\plugin\model\stock\HouseUserOrder as StockHouseUserOrder;
use app\shared\model\CardUserOrder;
use app\shared\model\District;
use app\shared\model\StoreRechargeOrder;
use app\shared\model\WxpayAccounting;
use wechatpay\WechatPay;
use slock\Slock;
use think\facade\Cache;
class Subaccount
{
   public function index(){
      self::houseOrder();
      self::storeRechargeOrder();
      self::houseOrderContinue();
   }
   public function houseOrder(){
      $list=HouseOrder::where(['is_pay'=>1,'sub_account_status'=>1,'status'=>3])->where('pay_time','<',time()-60)->order('id DESC')->select();
      foreach ($list as $order){
          $res=self::houseOrderBill($order);
          if($res['code']==0){
              $order->sub_account_status=2;
              $order->save();
          }else{
              $order->sub_account_status=3;
              $order->save();
          }
      }
   }
   public function houseOrderContinue(){
        $list=HouseOrderContinue::where(['is_pay'=>1,'sub_account_status'=>1])->where('pay_time','<',time()-60)->order('id DESC')->page(1)->limit(50)->select();
        foreach ($list as $order){
            $res=self::houseOrderContinueBill($order);
          if($res['code']==0){
              $order->sub_account_status=2;
              $order->save();
          }else{
              $order->sub_account_status=3;
              $order->save();
          }
        }
    }
    //商户充值订单
    public function storeRechargeOrder(){
         $list=StoreRechargeOrder::where(['is_pay'=>1,'sub_account_status'=>1])->where('pay_time','<',time()-60)->order('id DESC')->select();
         foreach ($list as $order){
            $xml_array=$order->xml_array;
            $res=self::storeRechargeBill($order);
            if($res['code']==0){
               $order->sub_account_status=2;
               $order->save();
            }else{
                  $order->sub_account_status=3;
                  $order->save();
            }
         }
    }

    //增加茶室账单
    private function houseOrderBill($order=[]){
            $store=Store::where('id',$order->store_id)->find();
            if($order->meituan_price>0){
                $order->price=$order->meituan_price;
            }
            if($store['is_actually_pay']==1){
                $fee=($store->fee*0.01)*$order->pay_price;
                $fee=$fee>0?$fee:0;//手续费
                $orderPrice=$order->pay_price-$fee; //总金额 
            }else{
                $fee=($store->fee*0.01)*$order->price;
                $fee=$fee>0?$fee:0;//手续费
                $orderPrice=$order->price-$fee; //总金额  
            }  
             
            $stockHouse=StockHouseUser::alias('h_u')
                   ->leftJoin([StockHouse::getTable()=>'h'],'h_u.stock_house_id=h.id')
                   ->where(['h_u.acid'=>$order->acid,'h.house_id'=>$order->house_id,'h_u.is_delete'=>0,'h.is_delete'=>0])
                   ->field('h_u.stock_user_id,h_u.ratio,h.house_id,h_u.stock_house_id')
                   ->select()
                   ->toArray();
            $wxpayAccounting=self::WxpayAccounting($store,$order,$order->pay_price,1);
            $wxfz_total_fee=0;
            $wxfz_sub_price=0;
            if($wxpayAccounting['code']==0){
                $wxfz_total_fee=$wxpayAccounting['data']->total_fee;
                $wxfz_sub_price=$wxpayAccounting['data']->sub_price;
            }else{
                return ['code'=>1,'msg'=>$wxpayAccounting];
            }
            //分红金额
            $sharePrice=0;           
            foreach($stockHouse as $hu){
                if(!StockHouseUserOrder::where([
                  'acid'=>$order->acid,
                  'type'=>1,
                  'order_id'=>$order->id,
                  'stock_house_id'=>$hu['stock_house_id'],
                  'stock_user_id'=>$hu['stock_user_id'],
                ])->count()){
                    (new StockHouseUserOrder())->save([
                      'acid'=>$order->acid,
                      'type'=>1,
                      'order_id'=>$order->id,
                      'stock_house_id'=>$hu['stock_house_id'],
                      'stock_user_id'=>$hu['stock_user_id'],
                      'ratio'=>$hu['ratio'],
                      'price'=>$hu['ratio']*$orderPrice*0.01, 
                    ]);
                   $user=StockUser::where('id',$hu['stock_user_id'])->field('id,money,total_price')->find();
                   if($user){
                     $user->money+=$hu['ratio']*$orderPrice*0.01;
                     $user->total_price+=$hu['ratio']*$orderPrice*0.01;
                     $user->save();
                   }
                   $sharePrice+=$hu['ratio']*$orderPrice*0.01;
               }
            }
            
            if($sharePrice>0){
                $store->money+=$orderPrice-$sharePrice;
                (new Bill())->save([
                    'acid'=>$order->acid,
                    'type'=>Bill::TYPE_HOUSE,
                    'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                    'form_id'=>$order->store_id,
                    'order_id'=>$order->id,
                    'price'=>$orderPrice-$sharePrice,
                    'price_type'=>$order->pay_type,
                    'balance'=>$store->money,
                    'status'=>1,
                    'fee'=>$fee,
                    'des'=>'商户: 【'.$store->name.'】进行了分账茶室收入其中股东分红扣除'.$sharePrice.'元'
                ]);            
            }else{
                $store->money+=$orderPrice-$sharePrice;
                (new Bill())->save([
                    'acid'=>$order->acid,
                    'type'=>Bill::TYPE_HOUSE,
                    'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                    'form_id'=>$order->store_id,
                    'order_id'=>$order->id,
                    'price'=>$orderPrice,
                    'price_type'=>$order->pay_type,
                    'balance'=>$store->money,
                    'status'=>1,
                    'fee'=>$fee,
                    'des'=>'商户: 【'.$store->name.'】进行分账茶室收入'
                ]);
            }        
            $store->save();
            return ['code'=>0,'msg'=>'分账成功'];
    }
    //增加商户充值账单
    public function storeRechargeBill($order=[]){
        $store=Store::where('id',$order->store_id)->find();
        $fee=($store->fee*0.01)*$order->money;
        $fee=$fee>0?$fee:0;
        $wxpayAccounting=self::WxpayAccounting($store,$order,$order->money,4);
        if($wxpayAccounting['code']==0){
           (new Bill())->save([
                'acid'=>$order->acid,
                'type'=>Bill::TYPE_STORE_USER_RECHARGE,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order->store_id,
                'order_id'=>$order->id,
                'price'=>$wxpayAccounting['data']->total_fee,
                'price_type'=>1,
                'status'=>1,
                'fee'=>$fee,
                'des'=>'商户: 【'.$store->name.'】用户充值收入'.$wxpayAccounting['data']->total_fee.'分账金额'.$wxpayAccounting['data']->sub_price
            ]);
        }else{
           return ['code'=>1,'msg'=>'分账不成功'];
        }  
        $store->money+=$order->money-$fee;
        $store->save();
        return ['code'=>0,'msg'=>'分账成功'];
    }
    //增加茶室续单分账账单
    public function houseOrderContinueBill($order=[]){
        $store=Store::where('id',$order->store_id)->find();
        if($store['is_actually_pay']==1){
            $fee=($store->fee*0.01)*$order->pay_price;
            $fee=$fee>0?$fee:0;//手续费
            $orderPrice=$order->pay_price-$fee; //总金额  
        }else{
            $fee=($store->fee*0.01)*$order->price;
            $fee=$fee>0?$fee:0;//手续费
            $orderPrice=$order->price-$fee; //总金额  
        }
        $stockHouse=StockHouseUser::alias('h_u')
               ->leftJoin([StockHouse::getTable()=>'h'],'h_u.stock_house_id=h.id')
               ->where(['h_u.acid'=>$order->acid,'h.house_id'=>$order->house_id,'h_u.is_delete'=>0,'h.is_delete'=>0])
               ->field('h_u.stock_user_id,h_u.ratio,h.house_id,h_u.stock_house_id')
               ->select()
               ->toArray();
        $wxpayAccounting=self::WxpayAccounting($store,$order,$order->pay_price,2);
        $wxfz_total_fee=0;
        $wxfz_sub_price=0;
        if($wxpayAccounting['code']==0){
          (new Bill())->save([
                'acid'=>$order->acid,
                'type'=>Bill::TYPE_HOUSE_CONTINUE,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order->store_id,
                'order_id'=>$order->id,
                'price'=>$wxpayAccounting['data']->total_fee,
                'price_type'=>$order->pay_type,
                'status'=>1,
                'fee'=>$fee,
                'des'=>'商户: 【'.$store->name.'】茶室收入'.$wxpayAccounting['data']->total_fee.'分账金额'.$wxpayAccounting['data']->sub_price
            ]);
           $order->sub_account_status=2;
           $order->save();
           $wxfz_total_fee=$wxpayAccounting['data']->total_fee;
           $wxfz_sub_price=$wxpayAccounting['data']->sub_price;
        }else{
           return ['code'=>1,'msg'=>'分账成功'];
        }          
        //分红金额
        $sharePrice=0;           
        foreach($stockHouse as $hu){
           (new StockHouseUserOrder())->save([
              'acid'=>$order->acid,
              'type'=>2,
              'order_id'=>$order->id,
              'stock_house_id'=>$hu['stock_house_id'],
              'stock_user_id'=>$hu['stock_user_id'],
              'ratio'=>$hu['ratio'],
              'price'=>$hu['ratio']*$orderPrice*0.01, 
            ]);
           $user=StockUser::where('id',$hu['stock_user_id'])->field('money,total_price')->find();
           if($user){
             $user->money+=$hu['ratio']*$orderPrice*0.01;
             $user->total_price+=$hu['ratio']*$orderPrice*0.01;
             $user->save();
           }
           $sharePrice+=$hu['ratio']*$orderPrice*0.01;
        }  
        if($sharePrice>0){
            $store->money+=$orderPrice-$sharePrice;
            (new Bill())->save([
                'acid'=>$order->acid,
                'type'=>Bill::TYPE_HOUSE_CONTINUE,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order->store_id,
                'order_id'=>$order->id,
                'price'=>$orderPrice-$sharePrice,
                'price_type'=>$order->pay_type,
                'balance'=>$store->money,
                'status'=>1,
                'fee'=>$fee,
                'des'=>'商户: 【'.$store->name.'】进行分账茶室续单收入其中股东分红扣除'.$sharePrice.'元'
            ]);
        }else{
            $store->money+=$orderPrice-$wxfz_sub_price;
            (new Bill())->save([
                'acid'=>$order->acid,
                'type'=>Bill::TYPE_HOUSE_CONTINUE,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order->store_id,
                'order_id'=>$order->id,
                'price'=>$orderPrice-$wxfz_sub_price,
                'price_type'=>$order->pay_type,
                'balance'=>$store->money,
                'status'=>1,
                'fee'=>$fee,
                'des'=>'商户: 【'.$store->name.'】进行分账茶室续单收入'
            ]);
        }        
        $store->save();
        return ['code'=>0,'msg'=>'分账成功'];
    }
    //分账
    public function WxpayAccounting($store,$order,$total_fee=1,$formType=1){
       if(!$order){
          return ['code'=>1];
       }
       
       $app=App::find($order->acid);
       if($app->wx_profit_sharing==0){
          return ['code'=>1];
       }
       
       if($app->wx_pay_type==1){
           $wx_config=[
              'appid'=>$app->wxapp_app_id,
              'mchid'=>$store['wx_mch_id'],
              'appsecret'=>$app->wxapp_app_secret,
              'key'=>$store['wx_key'],
              'sslcert'=>$store['wx_sslcert'],
              'sslkey'=>$store['wx_sslkey'],
              'sub_mch_id'=>$app->wx_mch_id,
              'wx_pay_type'=>$app->wx_pay_type,
           ];
       }else{
           $wx_config=[
              'appid'=>$app->wxapp_app_id,
              'mchid'=>$app->wx_mch_id,
              'wx_server_appid'=>$app->wx_server_appid,
              'appsecret'=>$app->wxapp_app_secret,
              'wx_server_mch_id'=>$app->wx_server_mch_id,
              'key'=>$app->wx_server_key,
              'sslcert'=>$app->wx_server_cert_pem,
              'sslkey'=>$app->wx_server_key_pem,
              'sub_appid'=>$app->wxapp_app_id,
              'sub_mch_id'=>$app->wx_mch_id,
              'wx_pay_type'=>$app->wx_pay_type,
           ];
       }
      
       $is_server=$app->wx_pay_type==2?1:0;
       $xml_array=@json_decode($order->xml_array,1);
       $is_subaccount=WxpayAccounting::where('out_trade_no',$xml_array['out_trade_no'])->count();
       if($is_subaccount){
          return ['code'=>1];
       }
       $order_no=WxpayAccounting::crateOrderNo("FZR".$order->store_id."S");

       $wx_sub_config=@json_decode($store['wx_sub_config'],1);
       $store_fee=$store['fee'];
       if($formType==4){
         if(isset($wx_sub_config['recharge']['fee'])){
             $store_fee=$wx_sub_config['recharge']['fee'];
          }
       }else if($formType==2){
          if(isset($wx_sub_config['shared_teahouse']['fee'])){
             $store_fee=$wx_sub_config['shared_teahouse']['fee'];
          }  
       }else if($formType==1){
          if(isset($wx_sub_config['shared_teahouse']['fee'])){
             $store_fee=$wx_sub_config['shared_teahouse']['fee'];
          }  
       }else{
         $store_fee=$store['fee'];
       }
       $form=new WechatPay($wx_config);
       $account=$app->wx_mch_id;
       $companyName=$app->wx_mch_name;
       $amount=$total_fee*$store_fee;//分账金额（分）
       $amount=filter_money($amount,0);
       if($amount<=0){
           $amount=1;
           if($store['wx_mch_id']==0){
               return ['code'=>1,'msg'=>'不用分账'];
           }
       }
       
       $out_trade_no=$xml_array['out_trade_no'];//订单号
       $transaction_id=$xml_array['transaction_id'];//微信交易订单号
       $res=$form->profitsharingaddreceiver($account,$companyName,$is_server);
       if($res['code']==1){
           return ['code'=>1,'res'=>$res];
       }
       $res=$form->profitsharing($order_no,$transaction_id,$account,$amount,$companyName,$is_server);
       if($res['code']===0){
         if($res['data']['result_code']=="SUCCESS"){
            $form=new WxpayAccounting();
            $form->acid=$order->acid;
            $form->store_id=$order->store_id;
            $form->type=$formType;//商户钱包分账
            $form->order_id=$order->id;
            $form->appid=$xml_array['appid'];
            $form->mch_id=$xml_array['mch_id'];
            $form->openid=$xml_array['openid'];
            $form->order_no=$order_no;
            $form->out_trade_no=$xml_array['out_trade_no'];
            $form->transaction_id=$xml_array['transaction_id'];
            $form->total_fee=$xml_array['total_fee']*0.01;
            $form->sub_price=$amount*0.01;
            $form->sub_account=$account;
            $form->sub_type=1;
            $form->save();
            return ['code'=>0,'data'=>$form];
         }else{
            return ['code'=>1,'res'=>$res];
         }
       }else{
           return ['code'=>1,'res'=>$res];;
       }
    }
}
