<?php
namespace app\shared\controller;
use app\shared\model\User;
use app\shared\model\WeixinUser;
use app\shared\model\Card;
use app\shared\model\CardUser;
use app\shared\model\App;
use app\shared\model\Option;

use wechatpay\WechatPay;
use weixin\Wechat;
use slock\Slock;
use think\facade\Cache;
class Inform
{
	//会员卡通知
	public function userCard(){
        $list=CardUser::alias('c_u')
        ->leftJoin([User::getTable()=>'u'],'c_u.user_id=u.id')
        ->leftJoin([Card::getTable()=>'c'],'c_u.card_id=c.id')
        ->leftJoin([WeixinUser::getTable()=>'w_u'],'u.account=w_u.mobile')
        ->whereDay('c_u.end_time')
        ->where(['c.is_delete'=>0])
        ->column('w_u.wxapp_open_id,c_u.acid,c.title,c_u.end_time');
        $data=[];
        foreach($list as $value){
        	$data[$value['acid']][]=[
        		"openid"=>$value['wxapp_open_id'],
        		"wxapp_path"=>"member/cardList",
        		'data'=>[
	              "first"    =>[
	                "value"  =>"您的会员卡已到期",
	                "color"  =>"#173177"
	              ],
	              "name" =>[
	                "value"  =>"【{$value['title']}】",
	                "color"  =>"#173177"
	              ],
	              "expDate" =>[
	                "value"  =>date('Y-m-d',$value['end_time']),
	                "color"  =>"#173177"
	              ],
	              "remark"   =>[
	                "value"  =>"尊敬客户，请您及时续费！",
	                "color"  =>"#173177"
	              ]
	          ]
        	];
        }
        $res=[];
        foreach($data as $acid=>$openidData){
        	if(isset($openidData[0])){
        		if($openidData[0]){
        			$res[]=self::sendUserTemplateMsg($acid,$openidData);
        		}
        	}
        }
        return fetchJson($res);
    }
    //发送用户模板消息
    public function sendUserTemplateMsg($acid,$openidData=[],$title="您的会员卡已到期"){
         $template_id=Option::get_data($acid,'platform','wx_template_user_card_expire_inform');
         $app=App::where('id',$acid)->field('wx_app_id,wx_app_secret,wxapp_app_id,wxapp_app_secret')->find();

         $pages="pages/user/coupon/storeCoupon";
         $res=(new \weixin\Wechat())->sendWxopenTemplateProArr($app,$template_id,$openidData,true);
         return $res;
     }
}
