<?php
namespace app\repast\logic\user;
use app\shared\model\User;
use app\repast\model\GoodsOrder;
use app\repast\model\GoodsOrderDetail;
use app\repast\model\Goods;
use app\shared\model\App;
use wechatpay\WechatPay;
use app\shared\model\Store;
use app\repast\model\Desk;
use app\shared\model\Coupon;
use app\shared\model\CouponUser;
use app\shared\model\Option;
use app\repast\model\GoodsAttr;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\user\UserForm;
class GoodsOrderForm extends  UserForm
{
  //列表
  public function list(){
      $status=input('status');
      $query=GoodsOrder::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'is_delete'=>0]);
      if($status!='-10'){
         $query->where(['status'=>$status]);
      }
      $list=$query->page($this->page)->limit(10)->field('id,store_id,pay_price,name,mobile,address,order_no,status,create_time,snapshot,desk_no,is_express')->order('id DESC')->select();
      $status_arr=[0=>'待付款',1=>'已付款',2=>'已发货',3=>'已完成',-1=>'已取消',-2=>'已退款'];
      $app=App::where(['id'=>$this->acid])->field('id,logo,name')->find();
      $app['name']="平台商城";
      $app['logo']=get_file_url($app['logo']);
      foreach ($list as $key => &$value) {
          $snapshot=@json_decode($value['snapshot'],1);
          $value['snapshot']=$snapshot;
          if($value['store_id']==-1){
             $value['store_info']=$app;
          }else{
             $store=Store::where(['acid'=>$this->acid,'id'=>$value['store_id']])->field('id,logo,name')->find();
             if($store){
               $store=$store->toArray();
             }
             $store['logo']=get_file_url($store['logo']);
             $value['store_info']=$store;
          }
          $value['status_title']=$status_arr[$value['status']];
          $value['goods_num']=array_sum(array_column($value['snapshot'], 'num'));

      }
      return fetchJson($list);
  }
  //提交预览
  public function submitPreview(){
     try {
          $data=request()->post();
          $rule = [
              'cart_list|购物车列表' => 'require',
              'store_id|商户ID'=>'require',
          ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $cart_list=@json_decode($data['cart_list'],1);
       $buy_cart_list_all=[];
       $pay_price=0;
       foreach ($cart_list as &$cart) {
            $goodsAttrObj=Goods::where(['id'=>$cart['id']])->field('cover,name,attribe_list')->find();
            if(!$goodsAttrObj){
                return fetchJson([],'暂无商品',1);
            }
            $goodsAttribe_list=$goodsAttrObj->attribe_list;
            $goodsAttr=GoodsAttr::where(['is_delete'=>0,'goods_id'=>$cart['id']])->order('index ASC')->column('attr_list,price,stock,integral,index');

            $goodsAttribe_list=@json_decode($goodsAttribe_list,1);
            $goodsAttrArr=[];
            $goodsAttrArrStr=[];
            $goodsAttrStock=[];
            foreach ($goodsAttr as $goodsAttrV) {
                $goodsAttrV_attr_list=array_column(json_decode($goodsAttrV['attr_list'],1),'attr_id');
                $goodsAttrArr[implode('_', $goodsAttrV_attr_list)]=$goodsAttrV['price'];
                $goodsAttrStock[implode('_', $goodsAttrV_attr_list)]=$goodsAttrV['stock'];
            }
            if($cart['use_attr']==1){
              $attr_id_node=implode('_', $cart['props']);
            }else{
              $attr_id_node=1;
            }
            $buy_cart_list['price']=$goodsAttrArr[$attr_id_node];
            $stock=$goodsAttrStock[$attr_id_node];
            if($stock<$cart['number']){
               return fetchJson([],"【{$cart['name']}】".'暂无库存',1);
            }
            $select_attr_str=[];
            foreach ($goodsAttribe_list as $key=> $goodsAttribe_listV) {
                $select_attr=array_column($goodsAttribe_listV['attr_list'],'attr_name','attr_id');
                if($cart['use_attr']==1){
                   $select_attr_str[]=$goodsAttribe_listV['attr_group_name'].':'.$select_attr[$cart['props'][$key]];
                }else{
                   $select_attr_str[]=$goodsAttribe_listV['attr_group_name'].':'.$select_attr[1];
                }
            }
            $buy_cart_list['attr_str']=implode(',', $select_attr_str);
            $buy_cart_list['goods_id']=$cart['id'];
            $buy_cart_list['cover']=get_file_url($goodsAttrObj->cover);
            $buy_cart_list['name']=$goodsAttrObj['name'];
            $buy_cart_list['num']=$cart['number'];
            $pay_price+=$cart['number']*$buy_cart_list['price'];
            $buy_cart_list_all[]=$buy_cart_list;
       }
       $coupon_user_id=input('coupon_user_id');
       if($coupon_user_id){
          $coupon_id=CouponUser::where(['id'=>$coupon_user_id,'is_use'=>0,'type'=>Coupon::TYPE_REPAST,'user_id'=>$this->user_id])->value('coupon_id');
          $coupon=Coupon::where('id',$coupon_id)->find();
          if($coupon){
              if($coupon['full_price']<=$pay_price){
                $pay_price-=$coupon['price'];
              }
          }
       }
       $discount=-1;
       $feePrice=0;
       $payPrice=$pay_price;
       if($data['store_id']==-1){
            $store=App::where(['id'=>$this->acid])->field('id,logo,name')->find();
            $store['logo']=get_file_url($store['logo']);
            $store['is_direct_checkout']=0;
            $store['pay_types']='1,2';
       }else{
          $store=Store::where(['acid'=>$this->acid,'id'=>$data['store_id']])->field('id,logo,name,is_direct_checkout,pay_types')->find();
          $store['logo']=get_file_url($store['logo']);
       }
       return fetchJson([
          'buy_cart_list_all'=>$buy_cart_list_all,
          'store'=>$store,
          'price'=>$payPrice,
          'discount'=>$discount,
          'feePrice'=>$feePrice
       ]);
  }
  //确认订单
  public function confirm(){
      $order_id=input('order_id');
      $order=GoodsOrder::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'id'=>$order_id,'status'=>2])->find();
      if(!$order){
        return fetchJson([],'暂无订单',1);
      }
      $order->status=3;
      $order->save();
      return fetchJson([],'确认成功');
  }
  //取消订单
  public function cancel(){
      $order_id=input('order_id');
      $order=GoodsOrder::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'id'=>$order_id])->where('status','in','0')->find();
      if(!$order){
        return fetchJson([],'暂无订单',1);
      }
      $order->status=-1;
      $userCoupon=CouponUser::where(['id'=>$order->coupon_user_id,'is_use'=>0])->find();
      if($userCoupon){
         $order->total_price+=$userCoupon['discounts_price'];
         $order->pay_price+=$userCoupon['discounts_price'];
      }
      $order->coupon_user_id=0;
      $order->save();
      return fetchJson([],'取消订单');
  }
  //提交订单
  public function submit(){
      try {
          $data=request()->post();
          $rule = [
              'cart_list|购物车列表' => 'require',
              'store_id|商户ID'=>'require',
              'is_express|快递'=>'require|in:0,1',
              'desk_id|桌号ID'=>'requireIf:is_express,0',
              'name|姓名'=>'requireIf:is_express,1',
              'mobile|手机号码'=>'requireIf:is_express,1',
              'address|地址'=>'requireIf:is_express,1',
          ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $cart_list=@json_decode($data['cart_list'],1);
       $buy_cart_list_all=[];
       $pay_price=0;
       $is_counter=0;
       foreach ($cart_list as &$cart) {
            $goodsAttrObj=Goods::where(['id'=>$cart['id']])->field('cover,name,attribe_list')->find();
            if(!$goodsAttrObj){
                return fetchJson([],'暂无商品',1);
            }
            $goodsAttribe_list=$goodsAttrObj->attribe_list;
            $goodsAttr=GoodsAttr::where(['is_delete'=>0,'goods_id'=>$cart['id']])->order('index ASC')->column('attr_list,price,stock,integral,index');

            $goodsAttribe_list=@json_decode($goodsAttribe_list,1);
            $goodsAttrArr=[];
            $goodsAttrArrStr=[];
            $goodsAttrStock=[];
            foreach ($goodsAttr as $goodsAttrV) {
                $goodsAttrV_attr_list=array_column(json_decode($goodsAttrV['attr_list'],1),'attr_id');
                $goodsAttrArr[implode('_', $goodsAttrV_attr_list)]=$goodsAttrV['price'];
                $goodsAttrStock[implode('_', $goodsAttrV_attr_list)]=$goodsAttrV['stock'];
            }
            if($cart['use_attr']==1){
              $attr_id_node=implode('_', $cart['props']);
            }else{
              $attr_id_node=1;
            }
           
            $buy_cart_list['price']=$goodsAttrArr[$attr_id_node];
            $stock=$goodsAttrStock[$attr_id_node];
            if($stock<$cart['number']){
               return fetchJson([],"【{$cart['name']}】".'暂无库存',1);
            }
            
            $select_attr_str=[];
            foreach ($goodsAttribe_list as $key=> $goodsAttribe_listV) {
                $select_attr=array_column($goodsAttribe_listV['attr_list'],'attr_name','attr_id');
                 if($cart['use_attr']==1){
                   $select_attr_str[]=$goodsAttribe_listV['attr_group_name'].':'.$select_attr[$cart['props'][$key]];
                  }else{
                    $select_attr_str[]=$goodsAttribe_listV['attr_group_name'].':'.$select_attr[1];
                  }
            }
            $buy_cart_list['attr_str']=implode(',', $select_attr_str);
            $buy_cart_list['goods_id']=$cart['id'];
            $buy_cart_list['cover']=get_file_url($goodsAttrObj->cover);
            $buy_cart_list['name']=$goodsAttrObj['name'];
            $buy_cart_list['num']=$cart['number'];
            $pay_price+=$cart['number']*$buy_cart_list['price'];
            $buy_cart_list_all[]=$buy_cart_list;
       }

       $order=new GoodsOrder();
       $order->order_no=GoodsOrder::crateOrderNo();
       $order->acid=$this->acid;
       $order->user_id=$this->user_id;
       $order->store_id=$data['store_id'];
       $order->remark=input('remark');
       $order->is_counter=$is_counter;
       $order->snapshot=json_encode($buy_cart_list_all);
       if($data['is_express']==1){
         $order->name=$data['name'];
         $order->mobile=$data['mobile'];
         $order->address=$data['address'];
       }else{
         $order->desk_id=$data['desk_id'];
         $desk=Desk::where(['id'=>$data['desk_id'],'is_delete'=>0])->field('code,status')->find();
         if(!$desk){
            return fetchJson([],'暂无餐桌，请重新扫码',1);
         }
         if($desk['status']>0){
            return fetchJson([],'该桌已在使用中~',1);
         }
         $order->desk_no=$desk['code'];
       }
       //优惠券
       $coupon_user_id=input('coupon_user_id');
       if($coupon_user_id){
          if(GoodsOrder::where(['coupon_user_id'=>$coupon_user_id,'acid'=>$this->acid,'store_id'=>$data['store_id']])->where('status','<>',-1)->count()){
              return fetchJson([],'该优惠券已被使用',1);
          }
          $userCoupon=CouponUser::where(['id'=>$coupon_user_id,'is_use'=>0,'type'=>Coupon::TYPE_REPAST,'user_id'=>$this->user_id])->find();
          $coupon=Coupon::where('id',$userCoupon['coupon_id'])->find();
          if($coupon){
              if($coupon['full_price']<=$pay_price){
                $pay_price-=$coupon['price'];
                $userCoupon->discounts_price=$coupon['price'];
                $userCoupon->save();
                $order->coupon_user_id=$coupon_user_id;
              }
          }
       }
       $order->is_express=$data['is_express'];
       $order->price=$pay_price;
       $order->pay_price=$pay_price;
       $order->save();
       foreach ($buy_cart_list_all as $key => $value) {
          $form=new GoodsOrderDetail();
          $form->order_id=$order->id;
          $form->price=$value['price']*1;
          $form->attr_str=$value['attr_str'];
          $form->goods_id=$value['goods_id'];
          $form->cover_img=$value['cover'];
          $form->name=$value['name'];
          $form->num=$value['num'];
          $form->status=0;
          $form->save();
       }
       return fetchJson($order,'提交成功');
  }
  //加菜订单
  public function addGoodsOrder(){
      try {
          $data=request()->post();
          $rule = [
              'cart_list|购物车列表' => 'require',
              'order_id|订单ID'=>'require',
          ];
          $this->validate($data,$rule);
      }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
      }
      $order=GoodsOrder::where(['id'=>$data['order_id'],'user_id'=>$this->user_id,'status'=>1,'is_express'=>0])->find();
      if(!$order){
         return fetchJson([],'暂无订单',1);
      }
      $cart_list=@json_decode($data['cart_list'],1);
      $pay_price=0;
      $buy_cart_list_all=[];
      foreach ($cart_list as &$cart) {
            $goodsAttrObj=Goods::where(['id'=>$cart['id']])->field('cover,name,attribe_list')->find();
            if(!$goodsAttrObj){
                return fetchJson([],'暂无商品',1);
            }
            $goodsAttribe_list=$goodsAttrObj->attribe_list;
            $goodsAttr=GoodsAttr::where(['is_delete'=>0,'goods_id'=>$cart['id']])->order('index ASC')->column('attr_list,price,stock,integral,index');

            $goodsAttribe_list=@json_decode($goodsAttribe_list,1);
            $goodsAttrArr=[];
            $goodsAttrArrStr=[];
            $goodsAttrStock=[];
            foreach ($goodsAttr as $goodsAttrV) {
                $goodsAttrV_attr_list=array_column(json_decode($goodsAttrV['attr_list'],1),'attr_id');
                $goodsAttrArr[implode('_', $goodsAttrV_attr_list)]=$goodsAttrV['price'];
                $goodsAttrStock[implode('_', $goodsAttrV_attr_list)]=$goodsAttrV['stock'];
            }
            if($cart['use_attr']==1){
              $attr_id_node=implode('_', $cart['props']);
            }else{
              $attr_id_node=1;
            }
           
            $buy_cart_list['price']=$goodsAttrArr[$attr_id_node];
            $stock=$goodsAttrStock[$attr_id_node];
            if($stock<$cart['number']){
               return fetchJson([],"【{$cart['name']}】".'暂无库存',1);
            }
            $select_attr_str=[];
            foreach ($goodsAttribe_list as $key=> $goodsAttribe_listV) {
                $select_attr=array_column($goodsAttribe_listV['attr_list'],'attr_name','attr_id');
                 if($cart['use_attr']==1){
                   $select_attr_str[]=$goodsAttribe_listV['attr_group_name'].':'.$select_attr[$cart['props'][$key]];
                  }else{
                    $select_attr_str[]=$goodsAttribe_listV['attr_group_name'].':'.$select_attr[1];
                  }
            }
            $buy_cart_list['attr_str']=implode(',', $select_attr_str);
            $buy_cart_list['goods_id']=$cart['id'];
            $buy_cart_list['cover']=get_file_url($goodsAttrObj->cover);
            $buy_cart_list['name']=$goodsAttrObj['name'];
            $buy_cart_list['num']=$cart['number'];
            $pay_price+=$cart['number']*$buy_cart_list['price'];
            $buy_cart_list_all[]=$buy_cart_list;
      }
      $array1=@json_decode($order->snapshot,1);
      $array=array_merge($array1,$buy_cart_list_all);
      $order->snapshot=json_encode($array);
      $order->price+=$pay_price;
      $order->pay_price+=$pay_price;
      $order->save();
      $addorderId=GoodsOrderDetail::where(['order_id'=>$order->id,'status'=>1])->order('id DESC')->value('id');
      $addorderId=empty($addorderId)?0:$addorderId;
      foreach ($buy_cart_list_all as $key => $value) {
          $form=new GoodsOrderDetail();
          $form->order_id=$order->id;
          $form->price=$value['price']*1;
          $form->attr_str=$value['attr_str'];
          $form->goods_id=$value['goods_id'];
          $form->cover_img=$value['cover'];
          $form->name=$value['name'];
          $form->num=$value['num'];
          $form->status=1;
          $form->save();
      }
      $store=Store::where(['id'=>$order->store_id])->field('printer1_config,printer2_config')->find();
      if($store){
        //打印前台
        self::fePrint($order,$store->printer1_config,$addorderId);
        //打印后厨
        self::fePrint($order,$store->printer2_config,$addorderId);
      }
      //更新库存
      $list=GoodsOrderDetail::where(['order_id'=>$order->id,'status'=>1])->where('id','>',$addorderId)->select();
      foreach ($list as $key => $value) {
          $goods_attr=GoodsAttr::where(['goods_id'=>$value['goods_id'],'is_delete'=>0])->select();
          $attr_str_arr=explode(',', $value['attr_str']);
          $attr_arr_string=[];
          foreach ($attr_str_arr as &$attr_arr) {
             $attr_arr_string[]=explode(':', $attr_arr)[1];
          }
          $attr_arr_string=implode('_', $attr_arr_string);
          $goods=Goods::where('id',$value['goods_id'])->field('id,goods_num,sales_volume')->find();
          $goods_num=0;
          foreach ($goods_attr as &$attr) {
             $attr_list=array_column(json_decode($attr->attr_list,1),'attr_name');
             $attr_list=implode('_', $attr_list);
             if($attr_arr_string==$attr_list){
               $attr->stock=$attr->stock-$value['num'];
               $goods_num+=$value['num'];
               if($attr->stock<0){
                 $attr->stock=0;
               }
               $attr->save();
             }
          }
          $goods->sales_volume+=$goods_num;
          $goods->goods_num-=$goods_num;
          $goods->goods_num=$goods->goods_num>0?$goods->goods_num:0;
          $goods->save();
      }
      return fetchJson($order,'加菜成功');
  }
   //飞鹅打印
  private function fePrint($order=[],$printer,$addorderId=0){
       $config=@json_decode($printer,true);
       $user=isset($config['user'])?$config['user']:'';
       $ukey=isset($config['uKey'])?$config['uKey']:'';
       $sn=isset($config['sn'])?$config['sn']:'';
       $title=isset($config['name'])?$config['name']:'';
       $orderDetail= GoodsOrderDetail::where(['order_id'=>$order->id,'status'=>1])->where('id','>',$addorderId)->column('num,price,name,attr_str');
       $arr=[];
       foreach ($orderDetail as $k_value){
            if($k_value['attr_str']=="默认:默认"){
               $k_value['attr_str']="默认";
            }
            $array['title']=$k_value['name'].'规格:'.$k_value['attr_str'];
            $array['price']=$k_value['price'];
            $array['num']=$k_value['num'];
            $array['prices']=$k_value['price']*$k_value['num'];
            $arr[]=$array;        
        }   
        $orderInfo = '<B>桌号：'.$order->desk_no.'</B><BR>';
        // 
        $orderInfo .= '--------------------------------<BR>';
        $orderInfo .= '加菜时间：'.$order->update_time.'<BR>';
        $orderInfo .= '订单号：'.$order->order_no.'<BR>';
        $orderInfo .= '              </B>订单总计:'. $order['price'].'</B><BR>';
        $orderInfo .= '--------------------------------<BR>';
        //$orderInfo .= '<B>备注：'.$order->remark.'</B><BR>';
        $orderInfo .= '--------------------------------<BR>';
        //$orderInfo .= '<QR>https://mp.weixin.qq.com/a/~8WR-XuxHHHGQ2g0T338wnw~~</QR>';
        $table='名称           单价   数量 金额<BR>';
        $data['table']=$table;
        $data['list']=$arr;
        $data['rest']=$orderInfo;
        $print=new \FlyingGeese\FlyingGeese($user,$ukey,$sn);
        $print->wp_print($title,$data['table'],$data['list'],$data['rest']);  
  
    } 
  //订单详情
  public function details(){
      $order_id=input('order_id');
      $order=GoodsOrder::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'id'=>$order_id])->find();
      if(!$order){
        return fetchJson([],'暂无订单',1);
      }

      if($order['store_id']==-1){
        $order['store']=[
          'name'=>App::where(['id'=>$this->acid])->value('name'),
          'address'=>'平台地址',
          'tel'=>'平台电话',
          'is_direct_checkout'=>0,
          'is_repast'=>0
       ];
      }else{
         $order['store']=Store::where(['id'=>$order->store_id])->field('name,address,tel,is_direct_checkout,is_repast')->find()->toArray();
      }
      $order['detailsList']=GoodsOrderDetail::where('order_id',$order->id)->order('status ASC')->column('name,attr_str,cover_img,num,price');
      $order['payType']=$order['pay_type'];
      $order['pay_type']=$order['pay_type']==0?'微信支付':'余额支付';
      $order['pay_time']=$order['is_pay']==1?date('Y-m-d H:i:s',$order['pay_time']):'';
      $order['snapshot']=@json_decode($order['snapshot']);
      $discounts_price=CouponUser::where(['id'=>$order->coupon_user_id,'type'=>Coupon::TYPE_REPAST,'user_id'=>$this->user_id])->value('discounts_price');
      $order['discounts_price']=$discounts_price>0?$discounts_price:0;
      return fetchJson($order);
  }
 //支付订单
  public function orderPay(){
       $order_id=input('order_id');
       $order=GoodsOrder::where(['id'=>$order_id,'user_id'=>$this->user_id,'is_pay'=>0])->find();
       if(!$order){
          return fetchJson([],'暂无订单',1);
       }
       $order->order_no=GoodsOrder::crateOrderNo();
       $pay_type=input('pay_type')?input('pay_type'):1;
       $order->pay_type=$pay_type;
       $order->save();
        //判断是否用余额支付
       if($pay_type==2){
           $res=self::balancePayment($order);
           return fetchJson(['order_id'=>$order_id],$res['msg'],$res['code']);
       }
        //判断是否用店铺余额支付
       if($pay_type==3){
           $res=self::storeBalancePayment($order);
           return fetchJson([],$res['msg'],$res['code']);
       }
       $app=App::find($this->acid);
       $appid=$app->wxapp_app_id;
       $app_secret=$app->wxapp_app_secret;
       $openid=$this->user->wxapp_open_id;
       if(input('is_weixin')==1){
          $appid=$app->wx_app_id;
          $app_secret=$app->wx_app_secret;
          $openid=$this->user->wx_open_id;
       }
       $wx_config=[
            'appid'=>$appid,
            'appsecret'=>$app_secret,
            'mchid'=>$app->wx_mch_id,
            'key'=>$app->wx_key,
            'sslcert'=>$app->wx_cert_pem,
            'sslkey'=>$app->wx_key_pem,
       ];
       
       if(isset($app->wx_pay_type)){
          $storeWx=Store::where('id',$order->store_id)->field('wx_mch_id,wx_key,wx_sslcert,wx_sslkey')->find();
          //服务商模式
          if($app->wx_pay_type==2){
             $wx_config=[
                  'appid'=>$appid,
                  'mchid'=>$storeWx['wx_mch_id']!=0?$storeWx['wx_mch_id']:$app->wx_mch_id,
                  'wx_server_appid'=>$app->wx_server_appid,
                  'appsecret'=>$app_secret,
                  'wx_server_mch_id'=>$app->wx_server_mch_id,
                  'key'=>$app->wx_server_key,
                  'sslcert'=>$app->wx_server_cert_pem,
                  'sslkey'=>$app->wx_server_key_pem,
                  'sub_appid'=>$appid,
                  'sub_mch_id'=>$app->wx_mch_id,
                  'wx_pay_type'=>$app->wx_pay_type,
                  'wx_profit_sharing'=>$app->wx_profit_sharing
             ];
          }else{
             if($storeWx['wx_mch_id']){
                $wx_config=[
                      'appid'=>$appid,
                      'appsecret'=>$app_secret,
                      'mchid'=>$storeWx['wx_mch_id'],
                      'key'=>$storeWx['wx_key'],
                      'sslcert'=>$storeWx['wx_sslcert'],
                      'sslkey'=>$storeWx['wx_sslkey'],
                      'wx_profit_sharing'=>$app->wx_profit_sharing
                 ];
             }
          }
       }
       $wechatPay=new WechatPay($wx_config);
       $notify_url=request()->domain().str_replace('index.php', 'pay_shared.php',request()->baseFile());
       $paydata = [
            'body' =>$order->house_title.'扫码点单',
            'out_trade_no' => $order->order_no,
            'total_fee' => round($order->pay_price,2)* 100,
            'notify_url' =>$notify_url ,
            'trade_type' => 'JSAPI',
            'openid' => $openid,
        ];
       $res=$wechatPay->pay($paydata);
       $res['order_id']=$order->id;
       return fetchJson($res);
    }
   //余额支付
    private function balancePayment($order=[]){
         $user=User::where('id',$order['user_id'])->find();
         if($user->money<$order->pay_price){
            return [
              'msg'=>'余额不足',
              'code'=>1
            ];
         }
         $form=new \app\repast\logic\pay\GoodsOrderForm();
         $res=$form->saveOrder($order->order_no);
         if($res=='success'){
            return [
              'msg'=>'支付成功',
              'code'=>0
            ];
         }
        return [
          'msg'=>'余额支付错误',
          'code'=>1
        ];
    }
    private function storeBalancePayment($order=[]){
         $user=StoreUserMoney::where(['user_id'=>$order['user_id'],'store_id'=>$order['store_id']])->find();
         if(!$user){
            return [
              'msg'=>'用户商户余额不足',
              'code'=>1
            ];
         }
         if($user->money<$order->pay_price){
            return [
              'msg'=>'用户商户余额不足',
              'code'=>1
            ];
         }
         $form=new \app\repast\logic\pay\GoodsOrderForm();
         $res=$form->saveOrder($order->order_no);
         if($res=='success'){
            return [
              'msg'=>'支付成功',
              'code'=>0
            ];
         }
        return [
          'msg'=>'用户商户余额支付错误',
          'code'=>1
        ];
    }

}