<?php
namespace app\repast\logic\user;
use app\repast\model\GoodsCat;
use app\repast\model\Goods;
use app\repast\model\GoodsAttr;
use app\repast\model\Card;
use app\repast\model\Collection;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\user\UserForm;
class GoodsForm extends  UserForm
{

    //购物车方式
    public function cartMode(){
        $query=GoodsCat::where(['acid'=>$this->acid,'is_delete'=>0]);
        if($store_id=input('store_id')){
            $query->where('store_id',$store_id);
        }
        $cat=$query->order('sort ASC')->column('id,title name,cover icon');
        $dateaList=[];
        foreach ($cat as &$value) {
            $value['icon']=get_file_url($value['icon']);
            $goods_list=Goods::where('cat_id',$value['id'])->column('id,name,price,images,cover,use_attr use_property,attribe_list property,attr entity,detail');
            foreach ($goods_list as &$goods) {
                $property=@json_decode($goods['property'],1);
                foreach ($property as &$pv) {
                    $attr_list=$pv['attr_list'];
                    foreach ($attr_list as $key => &$attr) {
                        if($key==0){
                            $attr['is_default']=1;
                        }else{
                            $attr['is_default']=0;
                        }
                    }
                    $pv['values']=$attr_list;
                    unset($pv['attr_list']);
                }
                $goods['property']=$property;
                $entity=GoodsAttr::where(['is_delete'=>0,'goods_id'=>$goods['id']])->order('index ASC')->column('attr_list,price,stock,integral,index');
                foreach ($entity as &$entity_v) {
                      $entity_v['attr_list']=@json_decode($entity_v['attr_list'],1);
                }
                $goods['entity']=$entity;
                $goods['images']=get_file_urls($goods['images']);
                $goods['cover']=get_file_url($goods['cover']);
                $goods['number']=1;
                $goods['num']=array_sum(array_column($entity, 'stock'));
            }
            $value['goods_list']=$goods_list;
            if($goods_list){
                $dateaList[]=$value;
            }
        }
        return fetchJson($dateaList);
    }
    //商品分类
    public  function catList(){
        $query=GoodsCat::where(['acid'=>$this->acid,'is_delete'=>0]);
        if($store_id=input('store_id')){
            $query->where('store_id',$store_id);
        }
        $list=$query
        ->order('sort DESC')
        ->field('id,title,cover,sort,parent_id,is_delete')
        ->page($this->page)
        ->limit(10)
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
            $value['cover_url']=get_file_url($value['cover']);
            if(!Goods::where(['status'=>1,'is_delete'=>0])->where('cat_id','like',"%{$value['id']}%")->count()){
                unset($value);
            }
        }
        $list=generateTree($list,'parent_id');
        return fetchJson($list);
    }
    //商品列表
    public function list(){
        $query=Goods::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1]);
        if($store_id=input('store_id')){
            $query->where('store_id',$store_id);
        }
        if($is_choiceness=input('is_choiceness')){
            $query->where('is_choiceness',1);
        }
        if($is_hotsell=input('is_hotsell')){
            $query->where('is_hotsell',$is_hotsell);
        }
        if($cat_id=input('cat_id')){
            $query->where('cat_id',$cat_id);
        }
        $sort_type=input('sort_type');
        //綜合排序
        if($sort_type==1){
            $query->order('id DESC')->order('price ASC');
        }
        //銷量排序
        if($sort_type==2){
            $query->order('sales_volume DESC');
        }
        //新品排序
        if($sort_type==3){
            $query->order('id DESC');
        }
        //價格从低到高排序
        if($sort_type==4){
            $query->order('price ASC');
        }
        //價格从高到低排序
        if($sort_type==5){
            $query->order('price DESC');
        }
        if($keyword=input('keyword')){
            $query->where('name','like',"%$keyword%");
        }
        $list=$query->field('id,name,price,original_price,goods_num,images,cover,attr,is_choiceness,use_attr,cat_id,is_hotsell,attribe_list property,video_url,sales_volume,virtual_sales,store_id')
        ->select();
        foreach ($list as &$goods) {
            $property=@json_decode($goods['property'],1);
            foreach ($property as &$pv) {
                $attr_list=$pv['attr_list'];
                foreach ($attr_list as $key => &$attr) {
                    if($key==0){
                        $attr['is_default']=1;
                    }else{
                        $attr['is_default']=0;
                    }
                }
                $pv['values']=$attr_list;
                unset($pv['attr_list']);
            }
            $goods['property']=$property;
            $entity=GoodsAttr::where(['is_delete'=>0,'goods_id'=>$goods['id']])->order('index ASC')->column('attr_list,price,stock,integral,index');
            foreach ($entity as &$entity_v) {
                  $entity_v['attr_list']=@json_decode($entity_v['attr_list'],1);
            }
            $goods['entity']=$entity;
            $goods['images']=get_file_urls($goods['images']);
            $goods['cover']=get_file_url($goods['cover']);
            $goods['number']=1;
            $goods['num']=array_sum(array_column($entity, 'stock'));
        }
        return fetchJson($list);
    }
    //详情
    public function details(){
        $goods_id=input('goods_id');
        $goods=Goods::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>$goods_id,'status'=>1])->find();
        if($goods){
            $goods['images_list']=get_file_urls($goods['images']);
            $goods['cover_url']=get_file_url($goods['cover']);
            $goods_attr=GoodsAttr::where(['is_delete'=>0,'goods_id'=>$goods_id])->order('index ASC')->column('attr_list,price,stock,integral,index');
            $attribe_list=@json_decode($goods->attribe_list,1);
            $specifications=[];
            foreach ($attribe_list as $spe) {
               $attr_list=$spe['attr_list'];
               $attr_v_arr=[];
               foreach ($attr_list as &$attr_v) {
                  $attr_v_arr[]=[
                    'name'=>$attr_v['attr_name'],
                  ];
               }
               $specifications[]=[
                    'name'=>$spe['attr_group_name'],
                    'item'=>$attr_v_arr
               ];
            }
           $difference=[];
           foreach ($goods_attr as $spe) {
                $spe['attr_list']=@json_decode($spe['attr_list'],1);
                $difference[]=[
                    'id'=>$spe['index']+1,
                    'price'=>$spe['price'],
                    'stock'=>$spe['stock'],
                    'pic'=>isset(array_column($spe['attr_list'],'pic')[0])?array_column($spe['attr_list'], 'pic')[0]:$goods['cover_url'],
                    'difference'=>array_column($spe['attr_list'], 'attr_name'),
                    'integral'=>isset($spe['integral'])?$spe['integral']:0
                ];
            }
            $goods['specifications']=$specifications;
            $goods['difference']=$difference;
            unset($goods['attribe_list']);
            unset($goods['attr']);
        }    
        return fetchJson($goods);
    }
}