<?php
namespace app\repast\logic\store;
use app\repast\model\GoodsOrder;
use app\repast\model\Goods;
use app\shared\model\Store;
use app\shared\model\User;
use app\repast\model\GoodsOrderDetail;
use app\repast\model\GoodsAttr;
use app\repast\model\Desk;
use app\shared\model\CouponUser;
use app\shared\model\Coupon;
use app\shared\model\WeixinUser;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
class GoodsOrderForm extends  Base
{
     //获取数据
    public  function index(){
        $keyword=input('keyword');
        $status=input('status');
        $query=GoodsOrder::alias('o')
                ->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')
                ->where([
                    'o.store_id'=>$this->store_id,
                	'o.acid'=>$this->acid,
                	'o.is_delete'=>0,

                ]);      
        if($status!=-1){
           $query=$query->where(['o.status'=>$status]);
        }
        if($keyword){
            $query=$query->where('o.order_no|o.id|o.snapshot','like',"%{$keyword}%");
        }
        $count=$query->field('o.*,u.nickname,u.avatar_url,u.account')->count();
        $list=$query->page($this->page)
                ->limit($this->limit)
                ->order('o.id DESC')
                ->select();
        $status_arr=[-1=>'取消',0=>'未支付',1=>'待发货',2=>'已发货',3=>'已完成'];       
        foreach ($list as &$value) {
            $orderDetail= GoodsOrderDetail::where(['order_id'=>$value['id'],'is_delete'=>0])->column('id,num,price,name,attr_str,cover_img');
            foreach($orderDetail as &$orderDetail_v){
                $orderDetail_v['sum_price']=$orderDetail_v['price']*$orderDetail_v['num'];
            }
            $value['orderDetail']=$orderDetail;
            $value['status_title']=$status_arr[$value['status']];
            $couponUser=CouponUser::alias('a')
            ->leftJoin([Coupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['coupon_user_id'],'a.type'=>Coupon::TYPE_REPAST])
            ->field('a.discounts_price,b.name')->find();
            $value['discounts_name']=$couponUser['name']?$couponUser['name']:'';
            $value['discounts_price']=$couponUser['discounts_price']>0?$couponUser['discounts_price']:0;
            $value['send_time']=$value['send_time']>0?date('Y-m-d H:i:s',$value['send_time']):'';
            $value['confirm_time']=$value['confirm_time']>0?date('Y-m-d H:i:s',$value['confirm_time']):'';
            $value['complete_time']=$value['complete_time']>0?date('Y-m-d H:i:s',$value['complete_time']):'';
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //扫码点餐确认订单
    public function confirmOrder(){
        try {
            $data=request()->post();
            $rule = [
                 'order_id|订单号'=>'require|number',
             ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         $order=GoodsOrder::where(['acid'=>$this->acid,'id'=>$data['order_id'],'is_express'=>0,'status'=>0,'store_id'=>$this->store_id])->find();
         if(!$order){
            return fetchJson([],'暂无订单',1);
         }
         //更新库存
         $list=GoodsOrderDetail::where(['order_id'=>$order->id])->select();
         // 启动事务
         Db::startTrans();
         foreach ($list as $key => $value) {
            $goods_attr=GoodsAttr::where(['goods_id'=>$value['goods_id'],'is_delete'=>0])->select();
            $attr_str_arr=explode(',', $value['attr_str']);
            $attr_arr_string=[];
            foreach ($attr_str_arr as &$attr_arr) {
               $attr_arr_string[]=explode(':', $attr_arr)[1];
            }
            $attr_arr_string=implode('_', $attr_arr_string);
            $goods=Goods::where('id',$value['goods_id'])->field('id,goods_num,sales_volume')->find();
            $goods_num=0;
            foreach ($goods_attr as &$attr) {
               $attr_list=array_column(json_decode($attr->attr_list,1),'attr_name');
               $attr_list=implode('_', $attr_list);
               if($attr_arr_string==$attr_list){
                 $stock=$attr->stock; 
                 $attr->stock=$attr->stock-$value['num'];
                 $goods_num+=$value['num'];
                 if($attr->stock<0){
                   Db::rollback();
                   return fetchJson([],"【{$value['name']}】".'库存不足，库存只有'.$stock,1);
                 }
                 $attr->save();
               }
            }
            $goods->sales_volume+=$goods_num;
            $goods->goods_num-=$goods_num;
            $goods->goods_num=$goods->goods_num>0?$goods->goods_num:0;
            $goods->save();
         }
         Db::commit();
         $order->status=1;
         $order->confirm_time=time();
         $order->save();
         Desk::where('id',$order->desk_id)->update(['status'=>1]);
         $store=Store::where(['id'=>$order->store_id])->field('printer1_config,printer2_config')->find();
         if($store){
             //打印前台
             self::fePrint($order,$store->printer1_config);
             //打印后厨
             self::fePrint($order,$store->printer2_config);
         }
        
        return fetchJson([],'确认下单成功');
    }
    //飞鹅打印
    private function fePrint($order=[],$printer){
       $config=@json_decode($printer,true);
       $user=isset($config['user'])?$config['user']:'';
       $ukey=isset($config['uKey'])?$config['uKey']:'';
       $sn=isset($config['sn'])?$config['sn']:'';
       $title=isset($config['name'])?$config['name']:'';
       $qrurl=isset($config['qrurl'])?$config['qrurl']:'';
       $orderDetail= GoodsOrderDetail::where(['order_id'=>$order->id,'status'=>0])->column('num,price,name,attr_str');
       $arr=[];
       foreach ($orderDetail as $k_value){
             if($k_value['attr_str']=="默认:默认"){
               $k_value['attr_str']="默认";
            }
            $array['title']=$k_value['name'].'规格:'.$k_value['attr_str'];
            $array['price']=$k_value['price'];
            $array['num']=$k_value['num'];
            $array['prices']=$k_value['price']*$k_value['num'];
            $arr[]=$array;        
        }   
        $orderInfo = '<B>桌号：'.$order->desk_no.'</B><BR>';
        // 
        $orderInfo .= '--------------------------------<BR>';
        $orderInfo .= '下单时间：'.$order->create_time.'<BR>';
        $orderInfo .= '确认时间：'.date('Y-m-d H:i:s',$order->confirm_time).'<BR>';
        $orderInfo .= '订单号：'.$order->order_no.'<BR>';
        $orderInfo .= '                    总计：'. $order->price.'<BR>';
        $orderInfo .= '--------------------------------<BR>';
        if($order->remark){
            $orderInfo .= '<B>备注：'.$order->remark.'</B><BR>';
        }
        $orderInfo .= '--------------------------------<BR>';
        if($qrurl){
            $orderInfo .= "<QR>{$qrurl}</QR>";
        }
        $table='名称           单价   数量 金额<BR>';
        $data['table']=$table;
        $data['list']=$arr;
        $data['rest']=$orderInfo;
        $print=new \FlyingGeese\FlyingGeese($user,$ukey,$sn);
        $res=$print->wp_print($title,$data['table'],$data['list'],$data['rest']);         
    } 
    //订单发货
    public function sendOrder(){
    	try {
            $data=request()->post();
            $rule = [
                 'order_id|订单号'=>'require|number',
                 'is_express|是否快递'=>'require|in:0,1',
                 'express_name|快递名称'=>'requireIf:is_express,1',
                 'express_no|快递单号'=>'requireIf:is_express,1',
             ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         $order=GoodsOrder::where(['acid'=>$this->acid,'id'=>$data['order_id'],'status'=>1,'store_id'=>$this->store_id])->find();
         if($order){
            $order->status=2;
            $order->is_express=$data['is_express'];
            if($order->is_express){
                $order->express_name=$data['express_name'];
                $order->express_no=$data['express_no'];
                $order->express_remark=input('express_remark');
            }
            $order->send_time=time();
            $order->save();
            return fetchJson([],'发货成功');
         }else{
            return fetchJson([],'暂无订单',1);
         }
    }
    //订单完成
    public function complete(){
        try {
            $data=request()->post();
            $rule = [
                 'order_id|订单号'=>'require|number',
             ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         $order=GoodsOrder::where(['acid'=>$this->acid,'id'=>$data['order_id'],'status'=>2,'store_id'=>$this->store_id])->find();
         if($order){
            $order->status=3;
            $order->complete_time=time();
            $order->save();
            return fetchJson([],'订单完成');
         }else{
            //扫码确认的订单
            $order=GoodsOrder::where(['acid'=>$this->acid,'id'=>$data['order_id'],'status'=>1,'is_express'=>0])->find();
            if($order){
                $order->status=3;
                $order->complete_time=time();
                $order->save();
                Desk::where('id',$order->desk_id)->update(['status'=>2]);
                return fetchJson([],'订单完成');
            }
            return fetchJson([],'暂无订单',1);
         }
    }
    //删除订单详情
    public function deleteOrderDetail(){
        try {
            $data=request()->post();
            $rule = [
                 'order_id|订单号'=>'require|number',
                 'order_detail_id|明细ID'=>'require|number',
                 'num|数量'=>'require|number|>=:0',
             ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         $order=GoodsOrder::where(['acid'=>$this->acid,'id'=>$data['order_id'],'is_express'=>0,'status'=>0,'store_id'=>$this->store_id])->find();
         if(!$order){
            return fetchJson([],'暂无订单',1);
         }
         $orderDetail= GoodsOrderDetail::where(['order_id'=>$order->id,'is_delete'=>0,'id'=>$data['order_detail_id']])->find();
         if($orderDetail){
            $orderDetail->is_delete=$data['num']==0?1:0;
            $orderDetail->num=$data['num'];
            $orderDetail->save();
            $orderDetail= GoodsOrderDetail::where(['order_id'=>$order->id,'is_delete'=>0])->order('id ASC')->column('id,num,price,name,attr_str,cover_img');
            $order_price=0;
            foreach($orderDetail as &$orderDetail_v){
                $orderDetail_v['sum_price']=$orderDetail_v['price']*$orderDetail_v['num'];
                $order_price+=$orderDetail_v['sum_price'];
            }
            $order->snapshot=json_encode($orderDetail,JSON_UNESCAPED_UNICODE);
            $order->pay_price=$order_price;
            $order->price=$order_price;
            $order->save();
            return fetchJson([],'保存订单');
         }
         return fetchJson([],'暂无明细',1);
    }
    //订单取消
    public function cancel(){
        try {
            $data=request()->post();
            $rule = [
                 'order_id|订单号'=>'require|number',
             ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         $order=GoodsOrder::where(['acid'=>$this->acid,'id'=>$data['order_id'],'store_id'=>$this->store_id])->where('status','in','0,1')->find();
         if($order){
            $order->status=-1;
            $order->save();
            return fetchJson([],'订单取消');
         }else{
            return fetchJson([],'暂无订单',1);
         }
    }
}