<?php
namespace app\repast\logic\store;
use app\repast\model\GoodsCat;
use think\exception\ValidateException;
use app\BaseController;
class GoodsCatForm extends  Base
{
    //获取数据
    public  function index(){
        $parent_id=input('parent_id')?input('parent_id'):0;
        $query=GoodsCat::where(['acid'=>$this->acid,'is_delete'=>0,'parent_id'=>$parent_id,'store_id'=>$this->store_id]);
        $list=$query
        ->order('sort DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
            $value['cover_url']=get_file_url($value['cover']);
        }
        return fetchJson($list);
    }
    //商品编辑
    public function edit(){
        try {
            $data=request()->post();
            $rule = [
                'id|ID' =>'require|number',
                'parent_id|父ID' =>'require|number',
                'title|名称'=>'require',
                'sort|排序'=>'require|number',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=GoodsCat::where(['acid'=>$this->acid,'id'=>$data['id'],'store_id'=>$this->store_id])->find();
        if(!$form){
            $form=new GoodsCat();
            $form->acid=$this->acid;
            $form->store_id=$this->store_id;
        }
        $form->title=$data['title'];
        $form->cover=input('cover');
        $form->sort=$data['sort'];
        $form->parent_id=$data['parent_id'];
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         GoodsCat::where(['acid'=>$this->acid,'id'=>$id,'store_id'=>$this->store_id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
}