<?php
namespace app\repast\logic\store;
use app\repast\model\Desk;
use app\admin\model\App;
use app\shared\model\House;
use think\facade\Cache;
use think\exception\ValidateException;
use app\BaseController;
class DeskForm extends  Base
{
    //获取数据
    public  function index(){
        $query=Desk::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$this->store_id]);
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select();
        foreach ($list as $key => &$value) {
           
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //桌码编辑
    public function edit(){
        try {
            $data=request()->post();
            $rule = [
                'id|ID' =>'require',
                'code' => 'requireWithout:house_ids',
                'house_ids'  => 'requireWithout:code',
                'status|状态'   => 'require|in:0,1,2,3',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $code=input('code');
        if($code){
            $form=Desk::where(['acid'=>$this->acid,'id'=>$data['id']])->find();
            if(!$form){
                $form=new Desk();
                $form->acid=$this->acid;
                if(Desk::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'code'=>$data['code'],'is_delete'=>0])->count()){
                    return fetchJson([],'该桌号已存在',1);
                }
            }else{
                if(Desk::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'is_delete'=>0,'code'=>$data['code']])->where('id','<>',$form->id)->count()){
                     return fetchJson($form,'该桌号已存在',1);
                }
            }
            $form->store_id=$this->store_id;
            $form->status=$data['status'];
            $form->code=$data['code'];
            $form->save();
            $wxappPath='repast/goods/menu?parent_id=-1&id='.$this->store_id.'&desk_code='.$form->code.'&desk_id='.$form->id;
            $form->code_img=qrcodeUrl($this->acid,$wxappPath,'store_desk',$form->id);
            $form->save();
        }else{
            $house_list=House::where('id','in',$data['house_ids'])->column('name');
            foreach($house_list as $name){
                $form=new Desk();
                $form->acid=$this->acid;
                if(Desk::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'code'=>$name,'is_delete'=>0])->count()){
                    return fetchJson([],$name.'该桌号已存在',1);
                }
                $form->store_id=$this->store_id;
                $form->status=$data['status'];
                $form->code=$name;
                $form->save();
                $wxappPath='repast/goods/menu?parent_id=-1&id='.$this->store_id.'&desk_code='.$form->code.'&desk_id='.$form->id;
                $form->code_img=qrcodeUrl($this->acid,$wxappPath,'store_desk',$form->id);
                $form->save();
            }
        }
        return fetchJson([],'保存成功');
    }

    //删除
    public function delete(){
         $id=input('id');
         Desk::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //快速编辑
    public function quickedit(){
        $id=input('id');
        $field=input('field');
        $edittext=input('edittext');
        $fieldArray=['status'];
        $form=Desk::where(['acid'=>$this->acid,'id'=>$id])->find();
        if(!$form){
             return fetchJson([],'该数据未找到',1);
        }
        if(in_array($field,$fieldArray)){
            try {
               $form->save([
                   "{$field}"=>$edittext
               ]);
            } catch (ValidateException $e) {
                return fetchJson([],$e->getError(),1);
            } catch (\Exception $e) {
                return fetchJson([],$e->getMessage(),1);
            }
           return fetchJson([],'保存成功');
        }
        return fetchJson([],'该字段不能编辑',1);
    }
    
}