<?php
namespace app\repast\logic\platform;
use app\shared\model\Store;
use app\repast\model\District;
use app\repast\model\Area;
use app\repast\model\StoreCategory;
use think\exception\ValidateException;
use Electronic\Lvmi;
use app\BaseController;
class StoreForm extends  Base
{
    //获取数据
    public  function index(){
        $query=Store::where(['acid'=>$this->acid,'is_delete'=>0]);
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->field('id,name,logo,is_direct_checkout,is_repast,printer1_config,printer2_config')
        ->select();
        foreach($list as &$value){
            $value['logo_url']=get_file_url($value['logo']);

            $printer1_config=@json_decode($value['printer1_config'],1);
            $printer2_config=@json_decode($value['printer2_config'],1);
            if(!$printer1_config){
                $printer1_config=[
                    'name'=>'',
                    'user'=>'',
                    'uKey'=>'',
                    'sn'=>'',
                    'qrurl'=>'',
                ];
            }
            if(!$printer2_config){
                $printer2_config=[
                    'name'=>'',
                    'user'=>'',
                    'uKey'=>'',
                    'sn'=>'',
                    'qrurl'=>'',
                ];
            }
            $value['printer1_config']=$printer1_config;
            $value['printer2_config']=$printer2_config;
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑用户
    public function edit(){
        try {
            $data=request()->post();
            $rule = [
               'id|ID' => 'require',
               'is_direct_checkout|是否直接结账'=>'require|in:0,1',
               'is_repast|是否直接结账'=>'require|in:0,1'
           ];
           $this->validate($data,$rule);
        }catch(ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=Store::where(['id'=>$data['id']])->find();
        $form->is_direct_checkout=$data['is_direct_checkout'];
        $form->is_repast=$data['is_repast'];
        $form->printer1_config=json_encode(input('printer1_config'),JSON_UNESCAPED_UNICODE);
        $form->printer2_config=json_encode(input('printer2_config'),JSON_UNESCAPED_UNICODE);
        $form->save();
        return fetchJson([],'保存成功');
    }
    //快速编辑
    public function quickedit(){
        $id=input('id');
        $field=input('field');
        $edittext=input('edittext');
        $fieldArray=['name','status','is_hot'];
        $form=Store::where(['acid'=>$this->acid,'id'=>$id])->find();
        if(!$form){
             return fetchJson([],'该数据未找到',1);
        }
        if(in_array($field,$fieldArray)){
            try {
               $form->save([
                   "{$field}"=>$edittext
               ]);
            } catch (ValidateException $e) {
                return fetchJson([],$e->getError(),1);
            } catch (\Exception $e) {
                return fetchJson([],$e->getMessage(),1);
            }
           return fetchJson([],'保存成功');
        }
        return fetchJson([],'该字段不能编辑',1);
    }
}