<?php
namespace app\repast\logic\pay;
use app\repast\model\HouseOrder;
use app\repast\model\ShareOrder;
use app\repast\model\WeixinUser;
use app\shared\model\User;
use app\admin\model\Option;
use app\shared\model\App;
use app\shared\model\Bill;
use app\shared\model\Store;
use app\repast\model\Desk;
use app\shared\model\CouponUser;
use app\repast\model\Goods;
use app\repast\model\CardUserOrder;
use app\repast\model\GoodsOrder;
use app\repast\model\GoodsOrderDetail;
use app\repast\model\GoodsAttr;
use think\facade\Cache;
use app\shared\model\WxpayAccounting;
use wechatpay\WechatPay;
class GoodsOrderForm
{
     //获取数据
    public  function saveOrder($order_no='',$xml_array=[]){
    	$order=GoodsOrder::where('order_no',$order_no)->find();
        if(!$order)return '';
    	   if($order->is_pay==1){
           if($order->pay_type==2){
                return "success";
            }else{
                echo "success";
                exit();
            }
        }
        $order->pay_time=time();
        $order->xml_array=json_encode($xml_array);
        $store=Store::where(['id'=>$order->store_id])->field('printer1_config,is_direct_checkout')->find();
        if($store['is_direct_checkout']==1){
            $order->status=1;
            Desk::where('id',$order->desk_id)->update(['status'=>0]);
        }else{
            if($order->is_express){
                $order->status=1;
                Desk::where('id',$order->desk_id)->update(['status'=>0]);
            }else{
                $order->status=3;
                Desk::where('id',$order->desk_id)->update(['status'=>2]);
            }
        }
    	$order->is_pay=1;
    	$order->save();
        CouponUser::where(['id'=>$order->coupon_user_id])->update(['is_use'=>1,'use_time'=>time(),'order_id'=>$order->id]);
        self::decUserBill($order);
        if($order->store_id>0){
            self::addStoreBill($order);
        }
        if($store){
            if($order->is_express==1){
                 //外卖
                 if($store['printer1_config']){
                     //打印前台
                     self::fePrint($order,$store['printer1_config'],$order->is_express);
                 }
            }else{
                if($store['is_direct_checkout']){
                  Desk::where('id',$order->desk_id)->update(['status'=>0]);
                  self::fePrint($order,$store['printer1_config'],$order->is_express);
                }
            }
        }
        if($order->pay_type==2){
            return "success";
        }else{
            echo "success";
        }
    }
    //飞鹅打印
    private function fePrint($order=[],$printer,$is_express=0){
       $config=@json_decode($printer,true);
       $user=isset($config['user'])?$config['user']:'';
       $ukey=isset($config['uKey'])?$config['uKey']:'';
       $sn=isset($config['sn'])?$config['sn']:'';
       $title=isset($config['name'])?$config['name']:'';
       $qrurl=isset($config['qrurl'])?$config['qrurl']:'';
       $orderDetail= GoodsOrderDetail::where(['order_id'=>$order->id,'status'=>0])->column('num,price,name,attr_str');
       $arr=[];
       foreach ($orderDetail as $k_value){
             if($k_value['attr_str']=="默认:默认"){
               $k_value['attr_str']="默认";
            }
            $array['title']=$k_value['name'].'规格:'.$k_value['attr_str'];
            $array['price']=$k_value['price'];
            $array['num']=$k_value['num'];
            $array['prices']=$k_value['price']*$k_value['num'];
            $arr[]=$array;        
        }
        if($is_express==0){
            $orderInfo = '<B>桌号：'.$order->desk_no.'</B><BR>';
        }else{
            $orderInfo = '';
        }  
        $orderInfo .= '--------------------------------<BR>';
        $orderInfo .= '下单时间：'.$order->create_time.'<BR>';
        $orderInfo .= '确认时间：'.date('Y-m-d H:i:s',$order->confirm_time).'<BR>';
        $orderInfo .= '订单号：'.$order->order_no.'<BR>';
        $orderInfo .= '                    总计：'. $order->price.'<BR>';
        $orderInfo .= '--------------------------------<BR>';
        if($is_express==1){
            $orderInfo .= '<B>昵称：'.$order->name.'</B><BR>';
            $orderInfo .= '<B>手机：'.$order->mobile.'</B><BR>';
            $orderInfo .= '<B>地址：'.$order->address.'</B><BR>';
        }
        if($order->remark){
            $orderInfo .= '<B>备注：'.$order->remark.'</B><BR>';
        }
        $orderInfo .= '--------------------------------<BR>';
        if($qrurl){
            $orderInfo .= "<QR>{$qrurl}</QR>";
        }
        $table='名称           单价   数量 金额<BR>';
        $data['table']=$table;
        $data['list']=$arr;
        $data['rest']=$orderInfo;
        $print=new \FlyingGeese\FlyingGeese($user,$ukey,$sn);
        $res=$print->wp_print($title,$data['table'],$data['list'],$data['rest']);         
    } 
    //减少用账单
    public function decUserBill($order=[]){
        $user=User::where('id',$order['user_id'])->find();
        if($order->pay_type==2){
            $user->money-=$order['pay_price'];
            $user->save();
        }
        $balance=$user->money;
        (new Bill())->save([
            'acid'=>$order->acid,
            'type'=>Bill::TYPE_REPAST,
            'account_type'=>Bill::ACCOUNT_TYPE_USER,
            'form_id'=>$order['user_id'],
            'order_id'=>$order['id'],
            'price'=>$order['pay_price'],
            'pay_type'=>$order['pay_type'],
            'balance'=>$balance,
            'status'=>-1,
            'des'=>'用户: 【'.$user->nickname.'】 购买商品'
        ]);
    }
    public function  shareOrder($order=[]){
        $share_setting=Option::get_data($order->acid,'platform','app_share_setting');
        $share_setting=@json_decode($share_setting,1);
        if(isset($share_setting['status'])){
             if($share_setting['status']){
                //一级
                $parent1_id=User::where('id',$order->user_id)->value('parent_id');
                if($share_setting['one']>0){
                    if($parent1_id){
                        $price=$share_setting['one']*0.01*$order->pay_price;
                        self::shareUserMoney($order,$parent1_id,$price,$order->user_id);
                    }
                }
                //二级
                if($share_setting['two']>0){
                    if($parent1_id){
                        $parent2_id=User::where('id',$parent1_id)->value('parent_id');
                        $price=$share_setting['one']*0.01*$order->pay_price;
                        if($parent2_id){
                            self::shareUserMoney($order,$parent2_id,$price,$parent1_id);
                        }
                    }
                }
             }
        }
    }
    public function shareUserMoney($order=[],$user_id=0,$price=0,$child_userid=0){
        if($price>0){
            $user=User::where('id',$user_id)->find();
            if(!$user){
                return false;
            }
            $user->price+=$price;
            $user->total_price+=$price;
            $user->save();
            $shareOrder=new ShareOrder();
            $shareOrder->save([
                'acid'=>$order->acid,
                'user_id'=>$user_id,
                'form_user_id'=>$child_userid,
                'user_type'=>ShareOrder::USER_TYPE_USER,
                'type'=>ShareOrder::TYPE_GOODS,
                'order_id'=>$order->id,
                'price'=>$price,
                'status'=>2,
                'pay_time'=>time()
            ]);
            (new Bill())->save([
                'acid'=>$order->acid,
                'type'=>Bill::TYPE_SHARE,
                'account_type'=>Bill::ACCOUNT_TYPE_USER,
                'form_id'=>$user_id,
                'order_id'=>$shareOrder->id,
                'price'=>$price,
                'price_type'=>$order['pay_type'],
                'status'=>1,
                'des'=>'分销佣金:商品购买'
            ]);
        }
    }
     //增加商户账单
    public function addStoreBill($order=[]){
        $store=Store::where('id',$order['store_id'])->find();
        $fee=($store->fee*0.01)*$order['pay_price'];
        $fee=$fee>0?$fee:0;
        $wxpayAccounting=self::WxpayAccounting($store,$order,$order->pay_price);
        $is_sub_price=0;
        if($wxpayAccounting['code']==0){
          $is_sub_price=1;
           //进行了分账
        }
        if($is_sub_price==0){
            $store->money+=$order['pay_price']-$fee;
            $store->save();          
            (new Bill())->save([
                'acid'=>$order['acid'],
                'type'=>Bill::TYPE_REPAST,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order['store_id'],
                'order_id'=>$order['id'],
                'price'=>$order['pay_price']-$fee,
                'price_type'=>$order['pay_type'],
                'status'=>1,
                'fee'=>$fee,
                'balance'=>$store->money,
                'des'=>'商户: 【'.$store->name.'】扫码点单收入'
            ]);
        }else{
            $store->money+=$order['pay_price']-$fee;
            $store->save();        
            (new Bill())->save([
                'acid'=>$order['acid'],
                'type'=>Bill::TYPE_REPAST,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order['store_id'],
                'order_id'=>$order['id'],
                'price'=>0,
                'price_type'=>$order['pay_type'],
                'status'=>1,
                'fee'=>$fee,
                'balance'=>$store->money,
                'des'=>'商户: 【'.$store->name.'】进行分账扫码点单收入'
            ]);
        }
    }
    //微信分账
    public function WxpayAccounting($store,$order,$total_fee=1){
           if(!$order){
              return ['code'=>1];
           }
           if($order['pay_type']==2){
              return ['code'=>1];
           }
           $app=App::find($order->acid);
           if($app->wx_profit_sharing==0){
              return ['code'=>1];
           }
           if($app->wx_pay_type==1){
               $wx_config=[
                  'appid'=>$app->wxapp_app_id,
                  'mchid'=>$store['wx_mch_id'],
                  'appsecret'=>$app->wxapp_app_secret,
                  'key'=>$store['wx_key'],
                  'sslcert'=>$store['wx_sslcert'],
                  'sslkey'=>$store['wx_sslkey'],
                  'sub_mch_id'=>$app->wx_mch_id,
                  'wx_pay_type'=>$app->wx_pay_type,
               ];
           }else{
               $wx_config=[
                  'appid'=>$app->wxapp_app_id,
                  'mchid'=>$app->wx_mch_id,
                  'wx_server_appid'=>$app->wx_server_appid,
                  'appsecret'=>$app->wxapp_app_secret,
                  'wx_server_mch_id'=>$app->wx_server_mch_id,
                  'key'=>$app->wx_server_key,
                  'sslcert'=>$app->wx_server_cert_pem,
                  'sslkey'=>$app->wx_server_key_pem,
                  'sub_appid'=>$app->wxapp_app_id,
                  'sub_mch_id'=>$app->wx_mch_id,
                  'wx_pay_type'=>$app->wx_pay_type,
               ];
           }
           $store=Store::where('id',$order->store_id)->field('wx_sub_config,fee')->find();
           $wx_sub_config=@json_decode($store['wx_sub_config'],1);
           $store_fee=$store['fee'];
           if(isset($wx_sub_config['goods']['status'])){
                $wx_sub_config['goods']['status']=$wx_sub_config['goods']['status']*1;
                if($wx_sub_config['goods']['status']==0){
                     return ['code'=>1];
                }
                if(isset($wx_sub_config['goods']['fee'])){
                    $store_fee=$wx_sub_config['goods']['fee'];
                }
           }
           $is_server=$app->wx_pay_type==2?1:0;
           $xml_array=@json_decode($order['xml_array'],1);
           $order_no=WxpayAccounting::crateOrderNo("FZREP".$order->store_id."S");
           sleep(20);
           if($store_fee>30){
             //根据分账要求最多只能分账微信的百分之30
             $store_fee=29;
           }
           if($store_fee<=0){
             return ['code'=>1];
           }
           $form=new WechatPay($wx_config);
           $account=$app->wx_mch_id;
           $companyName=$app->wx_mch_name;
           $amount=$total_fee*$store_fee;//分账金额（分）

           $amount=filter_money($amount,0);
           $out_trade_no=$xml_array['out_trade_no'];//订单号
           $transaction_id=$xml_array['transaction_id'];//微信交易订单号
           $res=$form->profitsharingaddreceiver($account,$companyName,$is_server);
           if($res['code']==1){
              return ['code'=>1];
           }
           $res=$form->profitsharing($order_no,$transaction_id,$account,$amount,$companyName,$is_server);
           if($res['code']==0){
              if($res['data']['result_code']=="SUCCESS"){
                $form=new WxpayAccounting();
                $form->acid=$order->acid;
                $form->store_id=$order->store_id;
                $form->order_id=$order->id;
                $form->type=WxpayAccounting::TYPE_REPAST;
                $form->appid=$xml_array['appid'];
                $form->mch_id=$xml_array['mch_id'];
                $form->openid=$xml_array['openid'];
                $form->order_no=$order_no;
                $form->out_trade_no=$xml_array['out_trade_no'];
                $form->transaction_id=$xml_array['transaction_id'];
                $form->total_fee=$xml_array['total_fee']*0.01;
                $form->sub_price=$amount*0.01;
                $form->sub_account=$account;
                $form->sub_type=1;
                $form->save();
                return ['code'=>0,'data'=>$form];
             }else{
               return ['code'=>1];
             }
           }else{
             return ['code'=>1];
          }

    }


}