<?php
namespace app\repast\logic;
use app\repast\model\District;
use app\repast\model\Area;
use app\repast\model\Store;
use app\repast\model\User;
use app\repast\model\AdoptCategory;
use app\repast\model\StoreCategory;
use think\exception\ValidateException;
use app\BaseController;
class CommonForm extends BaseController
{
    public function __construct()
    {
        $this->initialize();
        $this->acid=request()->get('_acid')?request()->get('_acid'):-1;
        if($this->acid==-1){
             $this->acid=request()->post('_acid')?request()->post('_acid'):1;
        }
        $this->version=request()->get('_version')?request()->get('_version'):'1.0.0';
        $this->platform=request()->get('platform')?request()->get('platform'):'wxapp';
        $this->page=request()->post('page')?request()->post('page'):1;
        $this->limit=request()->post('limit')?request()->post('limit'):10;
    }
    //获取地区
    public  function district(){
        if($parent_id=input('parent_id')){
            $query=District::where('parent_id',$parent_id);
        }else{
            $query=District::where('parent_id',1);
        }
        $list=$query
        ->order('id ASC')
        ->field('id,name,letter')
        ->select()
        ->toArray();
        return fetchJson($list);
    }
    //获取城市ID
    public function getCityId(){
        $city_id=District::cache(86400)->where('name',input('name'))->value('id');
        return fetchJson([
            'city_id'=>$city_id
        ]);
    }
    //所有城市
    public function allCity(){
        $list=District::where(['level'=>'city'])->cache(86400)->order('letter ASC')->column('id,name,letter');
        $letter=District::where(['level'=>'city'])->cache(86400)->distinct(true)->field('letter')->order('letter ASC')->column('letter');
        $city_ids=Store::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->distinct(true)->field('city_id')->column('city_id');
        $hot_city=District::where(['level'=>'city'])->where('id','in',$city_ids)->order('letter ASC')->column('id,name,letter');
        $cityArr=[];
        foreach ($letter as $k => $v) {
            $cityArr[$v]=[];
        }
        foreach ($list as $key => $value) {
            $cityArr[$value['letter']][]=['id'=>$value['id'],'name'=>$value['name']];
        }
        $city_list=[];
        foreach ($cityArr as $key => $value) {
            $city_list[]=[
                'title'=>$key,
                'lists'=>$value
            ];
        }
        return fetchJson([
            'hot_city'=>$hot_city,
            //'list'=>$list,///待删除，已更新下面的city_list为最新数据
            //'letter'=>$letter,
            //'city_list'=>$city_list,
        ]);
    }
    public function cityJson(){
        $type=input('type');
        if($type==1){
            $list=District::where(['level'=>'province'])->cache(86400)->order('letter ASC')->column('id value,name label');
            return fetchJson($list);
        }
        if($type==2){
            $list=District::where(['level'=>'province'])->cache(86400)->order('letter ASC')->column('id');
            $data=[];
            foreach($list as $v){
                $data[]=District::where(['parent_id'=>$v])->cache(86400)->order('letter ASC')->column('id value,name label');
            }
            return fetchJson($data);
        }
        if($type==3){
            $list=District::where(['level'=>'province'])->cache(86400)->order('letter ASC')->column('id');
            $data=[];
            $city=[];
            foreach($list as $v){
                $info=District::where(['parent_id'=>$v])->cache(86400)->order('letter ASC')->column('id');
                $district=[];
                foreach($info as $s){
                    $district[]=District::where(['parent_id'=>$s])->cache(86400)->order('letter ASC')->column('id value,name label');
                }
                $data[]=$district;
            }
            return fetchJson($data);
        }
        
    }
    //区域列表
    public function areaList(){
        $county_id=input('county_id');
        $list=Area::where(['county_id'=>$county_id,'is_delete'=>0,'acid'=>$this->acid])
        ->order('sort ASC')->column('id,name');
        return fetchJson($list);
    }
    //认养分类ID
    public function adoptCategory(){
        $list=AdoptCategory::where(['acid'=>$this->acid,'status'=>1,'is_delete'=>0])->order('sort ASC')->column('id,name');
        return fetchJson($list);
    }
    //商户分类ID
    public function storeCategory(){
        $list=StoreCategory::where(['acid'=>$this->acid,'status'=>1,'is_delete'=>0])->order('sort ASC')->column('id,name');
        return fetchJson($list);
    }
}