<?php
use app\shared\model\App;
use think\facade\Cache;
//将用户名进行处理，中间用星号表示
function substr_cut($user_name){
    //获取字符串长度
    $strlen = mb_strlen($user_name, 'utf-8');
    //如果字符创长度小于2，不做任何处理
    if($strlen<2){
        return $user_name;
    }else{
        //mb_substr — 获取字符串的部分
        $firstStr = mb_substr($user_name, 0, 1, 'utf-8');
        $lastStr = mb_substr($user_name, -1, 1, 'utf-8');
        //str_repeat — 重复一个字符串
        return $strlen == 2 ? $firstStr . str_repeat('*', mb_strlen($user_name, 'utf-8') - 1) : $firstStr . str_repeat("*", $strlen - 2) . $lastStr;
    }
}
//二维码
function qrcodeUrl($acid=1,$wxappPath="pages/index/index",$dirname="platform_qr",$filename="1"){
    $acid=App::where(['id'=>$acid])->find();
    $param= [
        'path' => $wxappPath,
    ];
    return getQcode($acid,$param,$dirname,$filename);
}
function getDyUserInfo($url){
     preg_match("/https:[\/]{2}[a-z]+[.]{1}[a-z\d\-]+[.]{1}[a-z\d]*[\/]*[A-Za-z\d]*[\/]*[A-Za-z\d]*/",$url,$arr);    
     $url=isset($arr[0])?$arr[0]:$url; 
     $html=getWebTag ( 'id="RENDER_DATA"', $url, 'script');
     $html=strip_tags($html);
     $html=urldecode($html);
     $json=@json_decode($html,1);
     if(!$json){
        return[];
     }
     $user=[];
     foreach($json as $value){
        if(isset($value['uid'])){
            $user=$value['user']['user'];
            break;
        }  
     }
     $data=[];
     if($user){
        $data['nickname']=$user['nickname'];
        $data['avatarUrl']='https:'.$user['avatar300Url'];
        $data['followingCount']=$user['followingCount'];
        $data['followerCount']=$user['followerCount'];
        $data['totalFavorited']=$user['totalFavorited'];
        $data['uniqueId']=$user['uniqueId'];
     }
     return $data;
}

/*
* 参数说明: $tag_id:所要获取的元素Tag Id $url:所要获取页面的Url $tag:所要获取的标签 $data
*/
function getWebTag($tag_id, $url = false, $tag = 'div', $data = false) {
    if ($url !== false) {
         try {
             $data = file_get_contents ( $url );
         } catch (Exception $e) {
            return false;
         }
    }
    $charset_pos = stripos ( $data, 'charset' );
    if ($charset_pos) {
        if (stripos ( $data, 'utf-8', $charset_pos )) {
            $data = iconv ( 'utf-8', 'utf-8', $data );
        } else if (stripos ( $data, 'gb2312', $charset_pos )) {
            $data = iconv ( 'gb2312', 'utf-8', $data );
        } else if (stripos ( $data, 'gbk', $charset_pos )) {
            $data = iconv ( 'gbk', 'utf-8', $data );
        }
    }
    preg_match_all ( '/<' . $tag . '/i', $data, $pre_matches, PREG_OFFSET_CAPTURE ); // 获取所有div前缀
    preg_match_all ( '/<\/' . $tag . '/i', $data, $suf_matches, PREG_OFFSET_CAPTURE ); // 获取所有div后缀
    $hit = strpos ( $data, $tag_id );
    if ($hit == - 1)
        return false; // 未命中
    $divs = array (); // 合并所有div
    try {
        foreach ( $pre_matches [0] as $index => $pre_div ) {
            $divs [( int ) $pre_div [1]] = 'p';
            $divs [( int ) $suf_matches [0] [$index] [1]] = 's';
        }
    } catch (Exception $e) {
        return false;
    }
    
    // 对div进行排序
    $sort = array_keys ( $divs );
    asort ( $sort );
    $count = count ( $pre_matches [0] );
    $hitDivString="";
    foreach ( $pre_matches [0] as $index => $pre_div ) {
        // <div $hit <div+1 时div被命中
        if (($pre_matches [0] [$index] [1] < $hit) && ($hit < $pre_matches [0] [$index + 1] [1])) {
            $deeper = 0;
            // 弹出被命中div前的div
            while ( array_shift ( $sort ) != $pre_matches [0] [$index] [1] && ($count --) )
                continue;
                // 对剩余div进行匹配，若下一个为前缀，则向下一层，$deeper加1，
                // 否则后退一层，$deeper减1，$deeper为0则命中匹配，计算div长度
            foreach ( $sort as $key ) {
                if ($divs [$key] == 'p')
                    $deeper ++;
                else if ($deeper == 0) {
                    $length = $key - $pre_matches [0] [$index] [1];
                    break;
                } else {
                    $deeper --;
                }
            }
            $hitDivString = substr ( $data, $pre_matches [0] [$index] [1], $length ) . '</' . $tag . '>';
            break;
        }
    }
    return $hitDivString;
}
//微信小程序获取二维码
function getQcode($acid=[],$param=[],$dirname='user',$filename=1){
    //保存到本地
    $saveRoot = public_path();
    $saveDir="qrcode/{$acid['id']}/{$dirname}/";
    if (!is_dir($saveRoot . $saveDir)) {
        @mkdir($saveRoot . $saveDir, 0755, true);
        file_put_contents($saveRoot . $saveDir . '.gitignore', "*\r\n!.gitignore");
    }
    $saveName = $filename.'_'.md5($filename).'.png';
    $base_file = request()->baseFile();
    $base_dir  = substr($base_file, 0, strripos($base_file, '/') + 1);

    if(Cache::get($dirname.$filename)){
     	 return request()->domain().$base_dir.$saveDir.$saveName.'?time='.time();
    }
    if(!($acid['wxapp_app_id']&&$acid['wxapp_app_id'])){
        return request()->domain().$base_dir.$saveDir.$saveName.'?time='.time();
    }

    $res=getToken($acid['wxapp_app_id'],$acid['wxapp_app_secret']);
    if($res['code']==1){
       return '';
    }
     $token=$res['data'];
    if(isset($param['path'])){
    	//$url="https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token={$token}";//方形
    	$url="https://api.weixin.qq.com/wxa/getwxacode?access_token={$token}";//方形
    }else{
    	$url = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={$token}";//圆形
    }
    $params = json_encode($param, JSON_UNESCAPED_UNICODE);
    $data=httpRequest($url,'POST',$params);
    file_put_contents($saveRoot.$saveDir.$saveName, $data);
    Cache::get($dirname.$filename,1,20);
    return request()->domain().$base_dir.$saveDir.$saveName.'?time='.time();
}
//获取令牌
function getToken($appid,$secret)
{
    $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={$appid}&secret={$secret}";
    $data=httpRequest($url);
    $data=@json_decode($data);
    if(isset($data->access_token)){
        return ['code'=>0,'data'=>$data->access_token];
    }else{
        return ['code'=>1,'data'=>'','msg'=>'access_token获取错误二维码'];
    }
}