<?php
namespace app\plugin\logic\wxservicer\platform;
use app\shared\model\Option;
use app\shared\model\Store;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\platform\Base;
class StoreForm extends  Base
{
	public function list()
    {
    	$query=Store::where(['acid'=>$this->acid,'is_delete'=>0]);
        if($keyword=input('keyword')){
            $query=$query->where('id|name|account|openid','like',"%{$keyword}%");
        }
        $query->field('id,account,name,logo,wx_mch_id,wx_key,wx_sslcert,wx_sslkey,wx_sub_config,fee')->order('id DESC');
        $count=$query->count();
        $list=$query->page($this->page)->limit($this->limit)->select();
        foreach($list as &$value){
            $value['logo_url']=get_file_url($value['logo']);
            $value['wx_sub_config']=@json_decode($value['wx_sub_config'],1);
            if(!$value['wx_sub_config']){
                $value['wx_sub_config']=[
                    'recharge'=>[
                        'status'=>1,
                        'fee'=>$value['fee'],
                    ],
                    'shared_teahouse'=>[
                        'status'=>1,
                        'fee'=>$value['fee'],
                    ],
                    'goods'=>[
                        'status'=>1,
                        'fee'=>$value['fee'],
                    ],
                ];
            }
        }
    	return fetchJson([
            'count'=>$count,
            'list'=>$list
        ]);
       
    }
    public function edit(){
        $form=Store::where('id',input('id'))->find();
        $form->wx_mch_id=input('wx_mch_id');
        $form->wx_key=input('wx_key');
        $form->wx_sslcert=input('wx_sslcert');
        $form->wx_sslkey=input('wx_sslkey');
        if($wx_sub_config=input('wx_sub_config')){
            $wx_sub_config=@json_decode($wx_sub_config,1);
            $recharge_f=isset($wx_sub_config['recharge']['fee'])?$wx_sub_config['recharge']['fee']:$form->fee;
            $recharge_f=$recharge_f*1;
            $form->fee=$form->fee*1;
            $shared_teahouse_f=isset($wx_sub_config['shared_teahouse']['fee'])?$wx_sub_config['shared_teahouse']['fee']:$form->fee;
            $shared_teahouse_f=$shared_teahouse_f*1;

            $goods_f=isset($wx_sub_config['goods']['fee'])?$wx_sub_config['goods']['fee']:$form->fee;
            $goods_f=$goods_f*1;

            if($recharge_f>29||$recharge_f<0){
                $recharge_f=($form->fee>29||$form->fee<0)?0:$fee;
            }
            if($shared_teahouse_f>29||$shared_teahouse_f<0){
                $shared_teahouse_f=($form->fee>29||$form->fee<0)?0:$fee;
            }
            if($goods_f>29||$goods_f<0){
                $goods_f=($form->fee>29||$form->fee<0)?0:$fee;
            }

            $form->wx_sub_config=json_encode([
                'recharge'=>[
                    'status'=>isset($wx_sub_config['recharge']['status'])?$wx_sub_config['recharge']['status']:1,
                    'fee'=>$recharge_f,
                ],
                'shared_teahouse'=>[
                    'status'=>isset($wx_sub_config['shared_teahouse']['status'])?$wx_sub_config['shared_teahouse']['status']:1,
                    'fee'=>$shared_teahouse_f,
                ],
                'goods'=>[
                    'status'=>isset($wx_sub_config['goods']['status'])?$wx_sub_config['goods']['status']:1,
                    'fee'=>$goods_f,
                ],
            ]);
        }
        $form->save();
        return fetchJson([],'保存成功');
    }

}