<?php
namespace app\plugin\logic\wxservicer\platform;
use app\shared\model\Option;
use app\shared\model\App;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\platform\Base;
class SettingForm extends  Base
{
	public function info()
    {
    	$info=App::where('id',$this->acid)->field('wx_pay_type,wx_server_appid,wx_server_mch_id,wx_server_key,wx_server_cert_pem,wx_server_key_pem,wx_profit_sharing,wx_mch_name')->find();
    	return fetchJson($info);
       
    }
    public function setting(){
        try {
            $data=request()->post();
            $rule = [
                'wx_pay_type|支付类型'   => 'require|in:1,2',
                'wx_mch_name|微信商户主体全称'=> 'require',
            ];
            $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=App::where('id',$this->acid)->find();
        $form->save([
            'wx_mch_name'=>$data['wx_mch_name'],
        	'wx_pay_type'=>$data['wx_pay_type'],
        	'wx_server_appid'=>input('wx_server_appid'),
        	'wx_server_mch_id'=>input('wx_server_mch_id'),
        	'wx_server_key'=>input('wx_server_key'),
        	'wx_server_cert_pem'=>input('wx_server_cert_pem'),
        	'wx_server_key_pem'=>input('wx_server_key_pem'),
            'wx_profit_sharing'=>input('wx_profit_sharing')
        ]);
        return fetchJson([],'保存成功');
    }
    //企业合作
    public function enterpriseCooperation(){
        if(input('is_edit')){
            Option::set_data($this->acid,'plugin','wx_profit_company_config',input('wx_profit_company_config'));
            return fetchJson([],'保存成功');
        }else{
            $wx_profit_company_config=Option::get_data($this->acid,'plugin','wx_profit_company_config');
            if($wx_profit_company_config){
                $wx_profit_company_config=@json_decode($wx_profit_company_config,1);
            }else{
                $wx_profit_company_config=[
                    'wx_mch_id'=>'',
                    'wx_mch_name'=>'',
                    'ratio'=>0
                ];
            }
            return fetchJson([
                'wx_profit_company_config'=>$wx_profit_company_config,
            ],'获取成功');
        }
    }

}