<?php
namespace app\plugin\logic\wxservicer\platform;
use app\shared\model\Option;
use app\shared\model\Store;
use app\shared\model\HouseOrder;
use app\shared\model\GoodsOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\StoreRechargeOrder;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\platform\Base;
use app\shared\model\WxpayAccounting;
class AccountingForm extends  Base
{
	public function list()
    {
    	$query=WxpayAccounting::alias('w')->leftJoin([Store::getTable()=>'s'],'w.store_id=s.id')->where(['w.acid'=>$this->acid]);
        if($keyword=input('keyword')){
            $query->where('w.out_trade_no|w.transaction_id','like',"%{$keyword}%");
        }
        $query->field('w.*,s.name store_name');
        $count=$query->count();
        $list=$query->page($this->page)->limit($this->limit)->order('w.id DESC')->select();
        foreach($list as &$value){

            switch (str_replace_match($value->out_trade_no)) { 
                case 'H':
                    $value->type=1;
                    $value->save();
                    //茶室订单
                    $value['order']=HouseOrder::where('id',$value['order_id'])->find();
                    break;    
                case 'G':
                    $value->type=3;
                    $value->save();
                    //商品订单
                    $value['order']=GoodsOrder::where('id',$value['order_id'])->find();
                    break;
                case 'SRe':
                    $value->type=4;
                    $value->save();
                    //商品订单
                    $value['order']=StoreRechargeOrder::where('id',$value['order_id'])->find();
                    break;         
                case 'XD':
                    $value->type=2;
                    $value->save();
                    //茶室订单续单
                    $value['order']=HouseOrderContinue::where('id',$value['order_id'])->find();
                    break;                      
                default:
                    break;
            }
        }
    	return fetchJson([
            'count'=>$count,
            'list'=>$list
        ]);
       
    }

}