<?php
namespace app\plugin\logic\wxpublic;
use app\shared\model\Option;
use think\exception\ValidateException;
use app\shared\logic\platform\Base;
use app\BaseController;
class ConfigForm extends  Base
{
    //每次更新都需要更换的文件
    private $repfile='';
    public function setting(){
        if(input('is_find')){
            $config=Option::get_data($this->acid,'shared','cloudSheetConfig');
            if(!$config){
               $config=[
                  'title'=>'',
                  'apiKey'=>'',
               ];
            }else{
              $config=@json_decode($config,1);
            }
            $config['captchaTpl']=Option::get_data($this->acid,'shared','cloudSheetCaptchaTpl');
            $config['tencentMapKey']=Option::get_data($this->acid,'shared','tencentMapKey');
            $config['captchaTpl']=$config['captchaTpl']?$config['captchaTpl']:'验证码：#code# （验证码五分钟有效）。';
            $url=request()->domain().request()->baseFile();
            $config['h5_url']=str_replace('index.php','', $url).'wxpublic/wx'.$this->acid.'/#/';
            return fetchJson($config);
        }
    	try {
            $data=request()->post();
            $rule = [
                'title|短信Title' =>'require',
                'apiKey|秘钥' =>'require',
                'captchaTpl|验证码模板' =>'require',
                'tencentMapKey|腾讯地图秘钥' =>'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        self::create_wxH5();
        Option::set_data($this->acid,'shared','cloudSheetConfig',json_encode([
         'title'=>input('title'),
         'apiKey'=>input('apiKey'),
       ]));
        Option::set_data($this->acid,'shared','cloudSheetCaptchaTpl',input('captchaTpl'));
        Option::set_data($this->acid,'shared','tencentMapKey',input('tencentMapKey'));
        return fetchJson([],'保存成功');
    }
    /**
     * 复制文件夹
     * @param $source
     * @param $dest
     */
    private function copydir($source='', $dest='')
    {
        if (!file_exists($dest)) mkdir($dest);
        $handle = opendir($source);
        while (($item = readdir($handle)) !== false) {
            if ($item == '.' || $item == '..') continue;
            $_source = $source . '/' . $item;
            $_dest = $dest . '/' . $item;
            if (is_file($_source)) copy($_source, $_dest);
            if (is_dir($_source)) self::copydir($_source, $_dest);
        }
        closedir($handle);
    }
    public function create_wxH5(){
        $tpl=app()->getRootPath().'public/wxpublic/h5';
        $tplZip=app()->getRootPath().'public/wxpublic/h5.zip';
        $webp=app()->getRootPath().'public/wxpublic/wx'.$this->acid;
        $web=$webp;
        if(is_file($tplZip)){
            self::QyDeldir($tpl,true);
            self::QyDeldir($webp,true);
            $zip = new \ZipArchive();
            //打开压缩文件，打开成功时返回true
            if ($zip->open($tplZip) === true) {
                $zip->extractTo(app()->getRootPath().'public/wxpublic');
                //关闭
                $zip->close();
            }
        }
        if (!is_dir($webp)) 
        mkdir($webp);
        self::copydir($tpl,$web);
        self::QyDeldir($tpl,true);
        $url=request()->domain().request()->baseFile();
        file_put_contents($web.'/web_wx_login.php',
'<?php
$code=isset($_GET["code"])?$_GET["code"]:"-1";
$url="'.$url.'?_acid='.$this->acid.'&code=".$code."&s=shared/user.login/web_wx_login_redirect_uri";
header("Location: $url");'
            );
        $baseUrl=$url.'?s=';
        $baseFile=substr(request()->baseFile(),0,strpos(request()->baseFile(),"public"));
        $url_base=$baseFile.'/wxpublic/wx'.$this->acid;
        $getIndexHtml=request()->domain().'/'.$url_base.'/index.html';
        $arrContextOptions=array(
            "ssl"=>array(
                "verify_peer"=>false,
                "verify_peer_name"=>false,
                "allow_self_signed"=>true,
            ),
        );
        $str = file_get_contents($getIndexHtml, false, stream_context_create($arrContextOptions));
        preg_match_all('/<script[^>]*?src=([^"]*?)[^>]*?>/i',$str,$match);
        $array=$match[0];
        foreach($array as $value){
            $value=str_replace('<script src=/wxpublic/wx1','', $value);
            $value=str_replace('.js>','.js', $value);
            if (strpos($value, 'index.') !== false) {
                $this->repfile="$value";
                break;
            }
        }
        $repfile=$web.$this->repfile;
        $url=$baseUrl;
        $txt='{domain_url_:"https://chashi.youdiy.cn/",android_version:"1.0.0",ios_version:"1.0.0",_version:"1.1.34",acid:1}';
        $rep_txt='{domain_url_:"'.request()->domain().'/",android_version:"1.0.0",ios_version:"1.0.0",_version:"1.1.34",acid:'.$this->acid.'}';
        $getcontent=file_get_contents($repfile);
        $put=str_replace($txt,$rep_txt,$getcontent);
        $tencentMapKey=Option::get_data($this->acid,'shared','tencentMapKey');
        $put=str_replace('QYSBZ-7IWEA-IKBKT-CUNVA-SITRS-2GBO5',$tencentMapKey,$put);

        file_put_contents($repfile,$put);
        $str=str_replace('/wxpublic/wx1/','/wxpublic/wx'.$this->acid.'/', $str);
        $str=str_replace('共享茶室',$this->admin->name, $str);
        file_put_contents($web.'/index.html',$str);
    }
    //删除指定文件夹以及文件夹下的所有文件
    private function QyDeldir($dir=null,$present=false) {
          if(!is_dir($dir))return 0;
           //先删除目录下的文件：
           $dh=opendir($dir);
           while ($file=readdir($dh)) {
              if($file!="." && $file!="..") {
                 $fullpath=$dir."/".$file;
                 if(!is_dir($fullpath)) {
                    unlink($fullpath);
                 } else {
                    self::QyDeldir($fullpath,$present);
                 }
              }
           }
           closedir($dh);
           if($present){
                //删除当前文件夹：
               if(rmdir($dir)) {
                  return true;
               } else {
                  return false;
               }
           }
           return true;
    } 
}