<?php
namespace app\plugin\logic\usercashgrade\user;
use app\shared\model\App;
use app\shared\model\Option;
use app\shared\model\Store;
use app\plugin\model\usercashgrade\Usercashgrade;
use app\plugin\model\usercashgrade\UsercashgradeOrder;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\user\UserForm;
use app\admin\model\Attachment;
use wechatpay\WechatPay;
use think\facade\Cache;
class UsercashgradeOrderForm extends  UserForm
{
	//列表
	public function submit(){
    	 $form=Usercashgrade::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>input('id')])->find();
       if(!$form){
         return fetchJson([],'暂无',1);
       }
       $order=new UsercashgradeOrder();
       $order->order_no=UsercashgradeOrder::crateOrderNo();
       $order->price=$form->price;
       $order->acid=$this->acid;
       $order->user_id=$this->user_id;
       $app=App::find($this->acid);
       $appid=$app->wxapp_app_id;
       $app_secret=$app->wxapp_app_secret;
       $openid=$this->user->wxapp_open_id;
       $order->snapshoot=json_encode($form);
       $order->user_cash_grade_id=$form->id;
       if(input('is_weixin')==1){
          $appid=$app->wx_app_id;
          $app_secret=$app->wx_app_secret;
          $openid=$this->user->wx_open_id;
       }
       //App
       if($this->platform=='app'||$this->platform=='ios'||$this->platform=='android'){
            $appConfig=Option::get_data($this->acid,'platform','app_config');
            $appConfig=@json_decode($appConfig);
            $appid=isset($appConfig->appid)?$appConfig->appid:'';
            $app_secret=isset($appConfig->app_secret)?$appConfig->app_secret:'';
       }
       $wx_config=[
            'appid'=>$appid,
            'appsecret'=>$app_secret,
            'mchid'=>$app->wx_mch_id,
            'key'=>$app->wx_key,
            'sslcert'=>$app->wx_cert_pem,
            'sslkey'=>$app->wx_key_pem,
       ];
       $wechatPay=new WechatPay($wx_config);
       $notify_url=request()->domain().str_replace('index.php', 'pay_shared.php',request()->baseFile());
       $paydata = [
            'body' =>'用户押金等级',
            'out_trade_no' => $order->order_no,
            'total_fee' => round($form->price,2)* 100,
            'notify_url' =>$notify_url ,
            'trade_type' => 'JSAPI',
            'openid' => $openid,
        ];
        //字节跳动支付
        if($this->platform=='ttapp'){
             $paydata=[
                'body' =>'用户押金等级',
                'appid'=>$app->wx_app_id,
                'attach'=>'用户押金等级',
                'mch_id'=>$app->mch_id,
                'notify_url' =>$notify_url ,
                'out_trade_no' => $order->order_no,
                'total_fee' => round($form->price,2)* 100,
                'trade_type' => 'MWEB',
                'openid' => $openid,
                'scene_info'=>'{"h5_info":{"type":"Wap","wap_url":"'.request()->domain().'","wap_name":"测试支付"}}'
              ];
              $ttapp=Option::get_data($this->acid,'platform','ttapp_config');
              $ttapp=@json_decode($ttapp);
              $res=$wechatPay->toutiaoh5pay($paydata,$ttapp);
              if($res['code']==0){
                return fetchJson($res);
              }else{
                return fetchJson([],$res['msg'],1);
              }
        }
        //微信外部支付
        if($this->platform=='h5'&&input('is_weixin')==0){
            $paydata=[
              'body' =>'用户押金等级',
              'appid'=>$app->wx_app_id,
              'attach'=>'用户押金等级',
              'mch_id'=>$app->mch_id,
              'notify_url' =>$notify_url ,
              'out_trade_no' => $order->order_no,
              'total_fee' => round($form->price,2)* 100,
              'trade_type' => 'MWEB',
              'openid' => $openid,
              'scene_info'=>'{"h5_info":{"type":"Wap","wap_url":"'.request()->domain().'","wap_name":"测试支付"}}'
            ];
            $rest['order_id']=$order->id;
            $res=$wechatPay->h5pay($paydata);
            if($res['code']==0){
              $rest['mweb_url']=$res['data'];
              return fetchJson($rest);
            }else{
              return fetchJson([],$res['msg'],1);
            }
       }
      if($this->platform=='app'||$this->platform=='ios'||$this->platform=='android'){
            unset($paydata['openid']);
            $paydata['trade_type']="APP";
            $res=$wechatPay->appPay($paydata);
       }else{
          $res=$wechatPay->pay($paydata);
       }
       $order->save();
       $res['order_id']=$order->id;
       return fetchJson($res);
  }
  //订单列表
  public function list(){
      $status=input('status')?input('status'):1;
      $list=UsercashgradeOrder::where(['status'=>$status,'user_id'=>$this->user_id])->page($this->page)->limit(10)->order('id DESC')->select();
      foreach($list as &$value){
        $value['snapshoot']=@json_decode($value['snapshoot'],1);
      }
      return fetchJson($list);
  }
  //申请退款
  public function applyRefund(){
      $order=UsercashgradeOrder::where(['id'=>input('order_id'),'user_id'=>$this->user_id,'status'=>1])->find();
      if($order){
         $order->is_apply_refund=1;
         $order->save();
         return fetchJson([],'请等待后台审核~');
      }
      return fetchJson([],'暂无订单可申请',1);
  }

}
