<?php
namespace app\plugin\logic\usercashgrade\platform;
use app\shared\model\Option;
use app\shared\model\App;
use app\shared\model\User;
use wechatpay\WechatPay;
use app\plugin\model\usercashgrade\Usercashgrade;
use app\plugin\model\usercashgrade\UsercashgradeOrder;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\platform\Base;
class UsercashgradeForm extends  Base
{
	public function index()
    {
        $list=Usercashgrade::where(['acid'=>$this->acid,'is_delete'=>0])->order('id DESC')->select();
    	return fetchJson($list);
    }
    //编辑
    public function edit()
    {
        try {
            $data=request()->post();
            $rule = [
                'id|ID' => 'require',
                'cover|封面'=>'require',
                'name|名称'=>'require',
                'sort|排序'=>'require',
                'price|押金'=>'require|float|>:0',
                'status|状态'=>'require|in:0,1',
                'store_ids|商户IDS' => 'require',
            ];
            $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=Usercashgrade::where(['id'=>$data['id']])->find();
        if(!$form){
              $form=new Usercashgrade();
              $form->acid=$this->acid;
        }
        $form->save([
           'status'=>$data['status'],
           'cover'=>$data['cover'],
           'name'=>$data['name'],
           'sort'=>$data['sort'],
           'price'=>$data['price'],
           'store_ids'=>$data['store_ids']
        ]);
        return fetchJson([],'保存成功');
    }
    public function delete(){
         Usercashgrade::where(['acid'=>$this->acid,'id'=>input('id')])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //订单列表
    public function orderList(){
        $type=input('type');

        $query=UsercashgradeOrder::alias('o')
        ->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')
        ->where(['o.acid'=>$this->acid,'o.is_pay'=>1]);
        if($keyword=input('keyword')){
            $query->where('o.order_no|o.name|u.account|u.nickname','like',"%{$keyword}%");
        }
        if($type==1){
            $query->where('o.status',1);
        }
        if($type==2){
            $query->where('o.status',1)->where('o.is_apply_refund',1);
        }
        if($type==3){
            $query->where('o.status',2);
        }
        $query->field('o.*,u.nickname,u.avatar_url,u.account');
        $count=$query->count();
        $list=$query->page($this->page)->limit($this->limit)->order('o.id DESC')->select();
        foreach($list as &$value){
            $value['refund_time']=date('Y-m-d H:i:s',$value['refund_time']);
        }
        return fetchJson([
            'count'=>$count,
            'list'=>$list
        ]);
    }
    //处理退款
    public function handelRefund(){
         try {
            $data=request()->post();
            $rule = [
                'order_id|订单ID' => 'require',
                'refund_price|金额'=>'require',
                'refund_cause|退款说明'=>'require',
            ];
            $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $order=UsercashgradeOrder::where(['id'=>$data['order_id'],'acid'=>$this->acid,'status'=>1])->find();
        if($order){
             $refund_price=filter_money($data['refund_price']);
              //微信支付
             $user=User::where('id',$order->user_id)->find();
             $app=App::find($order->acid);
             if($order->refund_time>0){
                return ['code' => 0, 'info' => '已经退过了','data' =>''];
             }
             $order->refund_price=$data['refund_price'];
             $order->refund_cause=$data['refund_cause'];
             $appid=$app->wxapp_app_id;
             $app_secret=$app->wxapp_app_secret;
             $wx_config=[
                  'appid'=>$appid,
                  'appsecret'=>$app_secret,
                  'mchid'=>$app->wx_mch_id,
                  'key'=>$app->wx_key,
                  'sslcert'=>$app->wx_cert_pem,
                  'sslkey'=>$app->wx_key_pem,
             ];
             $wechatPay=new WechatPay($wx_config);
             $notify_url='https://chashi-demo.youdiy.cn';
             $order->out_order_no=UsercashgradeOrder::crateOutOrderNo();
             $data = [
                'out_refund_no' => $order->out_order_no,//订单号码
                'out_trade_no' =>$order->order_no,//退款单号
                'total_fee' =>  $order->price * 100,//支付金额
                'refund_fee' => $refund_price * 100,//全额退款
            ];
            if(isset($order->xml_array)){
                $xml_array=@json_decode($order->xml_array,1);
                if(isset($xml_array['transaction_id'])){
                  $data['transaction_id']=$xml_array['transaction_id'];
                }
            }
            $payResult = $wechatPay->refund($data);
            if (!isset($payResult['return_code']) || $payResult['return_code'] != 'SUCCESS') {
                $info='退款失败，' . (isset($payResult['return_msg']) ? $payResult['return_msg'] : '');
                return fetchJson([],$info,1);
            }
            if (!isset($payResult['result_code']) || $payResult['result_code'] != 'SUCCESS') {
                $info='提交业务失败，'. (isset($payResult['err_code_des']) ? $payResult['err_code_des'] : '');
                return fetchJson([],$info,1);
            }
            $order->refund_time=time();
            $order->status=2;
            $order->save();
            $user_cash_grade_id=UsercashgradeOrder::where(['status'=>1,'user_id'=>$order->user_id,'is_pay'=>1])->order('id DESC')->value('user_cash_grade_id');
            $user->user_cash_grade_id=$user_cash_grade_id?$user_cash_grade_id:0;
            $user->save();
            return fetchJson([],'退款成功');
        }
        return fetchJson([],'暂无订单可退');
    }
    

}