<?php
namespace app\plugin\logic\stock\user;
use app\shared\model\House;
use app\plugin\model\stock\ApplyBecomeUser as StockApplyBecomeUser;
use app\plugin\model\stock\User as StockUser;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\user\UserForm as Base;
use app\shared\model\HouseOrder;
use app\shared\model\Store;
use app\shared\model\User;
use app\shared\model\Option;
use app\shared\model\HouseOrderContinue;
use app\plugin\model\stock\House as StockHouse;
use app\plugin\model\stock\HouseUserOrder as StockHouseUserOrder;
use app\plugin\model\stock\HouseUser as StockHouseUser;
use app\plugin\model\stock\Withdraw as StockWithdraw;
use app\shared\model\Bill;
class UserForm extends  Base
{
	private $stock_user_id=0;
	private $stock_user=[];
	public function __construct()
    {
        parent::__construct();
        $account=StockApplyBecomeUser::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'is_delete'=>0,'status'=>1])->value('account');
        if(!$account){
        	$account=$this->user->account;
        }
        $this->stock_user=StockUser::where(['acid'=>$this->acid,'account'=>$account,'is_delete'=>0,'status'=>1])->cache(5)->find();
        if(!$this->stock_user){
        	die(json_encode(['code'=>-2,'data'=>[],'msg'=>'您不是股东']));
        }
        $this->stock_user_id=$this->stock_user->id;
    }
	//数据统计
	public function statistics()
    {
      $house_redio=StockHouseUser::alias('hu')
       ->leftJoin([StockHouse::getTable()=>'sh'],'hu.stock_house_id=sh.id')
       ->leftJoin([House::getTable()=>'h'],'sh.house_id=h.id')
       ->where(['hu.status'=>1,'hu.acid'=>$this->acid,'hu.stock_user_id'=>$this->stock_user_id,'hu.is_delete'=>0])
       ->order('hu.ratio DESC')
       ->column('h.name,hu.ratio');
    	return fetchJson([
    		'money'=>$this->stock_user->money,
    		'total_price'=>$this->stock_user->total_price,
    		'withdraw_price'=>$this->stock_user->withdraw_price,
        'house_redio'=>$house_redio
    	]);
    }
    //申请提现
    public function applyWithdraw(){
    	try {
            $data=request()->post();
            $rule = [
                'type|类型'   => 'require|in:1,2',
                'username|姓名'   => 'length:1,20',
                'account|账号'   => 'require|length:5,50',
                'money|金额'   => 'require|>=:50|float',
            ];
            $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=StockWithdraw::where(['acid'=>$this->acid,'stock_user_id'=>$this->stock_user_id,'status'=>0])->find();
        if($form){
            return fetchJson(['status'=>1],'已有提交，请等待审核通过');
        }
        if($this->stock_user->money<$data['money']){
             return fetchJson(['status'=>0],'可提现佣金不足');
        }
        $form=new StockWithdraw();
        $form->acid=$this->acid;
        $form->stock_user_id=$this->stock_user_id;
        $form->asset_type=1;
        $form->save($data);
        return fetchJson(['status'=>0],'保存成功');
    }
    //提现列表
    public function withdrawList(){
        $list=StockWithdraw::where(['acid'=>$this->acid,'stock_user_id'=>$this->stock_user_id])->page($this->page)->limit(10)->order('id DESC')->select();
        return fetchJson($list);
    }
    //订单列表
    public function orderList(){
    	$query=StockHouseUserOrder::alias('u_o')
              ->leftJoin([StockHouse::getTable()=>'sh'],'u_o.stock_house_id=sh.id')
              ->leftJoin([House::getTable()=>'h'],'sh.house_id=h.id')
              ->leftJoin([StockUser::getTable()=>'su'],'u_o.stock_user_id=su.id')
              ->where(['u_o.acid'=>$this->acid,'u_o.is_delete'=>0,'u_o.stock_user_id'=>$this->stock_user_id]);
        if($house_id=input('house_id')){
            $query->where('h.id',$house_id);
        }
        if($order_no=input('order_no')){
            $ids=HouseOrder::where('order_no','like',"%{$order_no}%")->column('id');
            if(!$ids){
               $ids=HouseOrderContinue::where('order_no','like',"%{$order_no}%")->column('id');
            }
            $query->where('u_o.order_id','in',$ids);
        }        
        $list=$query
              ->page($this->page)
              ->limit(10)
              ->field('u_o.*,h.name,h.cover,h.address,su.name nickname,su.account')
              ->order('u_o.id DESC')
              ->select();
        foreach($list as &$value){
           
           if($value['type']==1){
              $order=HouseOrder::alias('o')->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')->where(['o.id'=>$value['order_id']])->field('o.order_no,o.pay_type,u.nickname username')->find();
              $value['order_no']=$order['order_no'];
              $value['pay_type']=$order['pay_type'];
              $value['order_tip']='茶室预订';
              $value['username']=$order['username'];
              if($value['pay_type']==3){
                  $bill=Bill::where([
                    'acid'=>$this->acid,
                    'account_type'=>Bill::ACCOUNT_TYPE_USER,
                    'order_id'=>$value['order_id'],
                  ])->where('type',Bill::TYPE_STORE_USER_HOUSE)->field('balance')->find();
              }else{
                   $bill=Bill::where([
                    'acid'=>$this->acid,
                    'account_type'=>Bill::ACCOUNT_TYPE_USER,
                    'order_id'=>$value['order_id'],
                  ])->where('type',Bill::TYPE_HOUSE)->field('balance')->find();
              }
              
              $value['store_balance']=$bill['balance'];
           }else{
              $order=HouseOrderContinue::alias('o')->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')->where(['o.id'=>$value['order_id']])->field('o.order_no,o.pay_type,u.nickname username')->find();
              $value['order_no']=$order['order_no'];
              $value['pay_type']=$order['pay_type'];
              $value['order_tip']='茶室续单';
              $value['username']=$order['username'];
              if($value['pay_type']==3){
                  $bill=Bill::where([
                    'acid'=>$this->acid,
                    'account_type'=>Bill::ACCOUNT_TYPE_USER,
                    'order_id'=>$value['order_id'],
                  ])->where('type','in','14,20')->field('balance')->find();
              }else{
                   $bill=Bill::where([
                    'acid'=>$this->acid,
                    'account_type'=>Bill::ACCOUNT_TYPE_USER,
                    'order_id'=>$value['order_id'],
                  ])->where('type',Bill::TYPE_HOUSE_CONTINUE)->field('balance')->find();
              }
              $value['store_balance']=$bill['balance'];
           }
        }      
        return fetchJson($list);
    }
    
}