<?php
namespace app\plugin\logic\stock\user;
use app\shared\model\House;
use app\shared\model\Option;
use app\plugin\model\stock\ApplyBecomeUser as StockApplyBecomeUser;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\user\UserForm;
class ApplyForm extends  UserForm
{
	//列表
	public function applyBecomeUser()
    {
    	$form=StockApplyBecomeUser::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'is_delete'=>0])->find();
    	if($form){
    		if($form->status==1){
    			return fetchJson([],'您已经是股东了',1);
    		}
    		if($form->status==0){
    			return fetchJson([],'正在审核中，请耐心等待~',1);
    		}
    	}
    	try {
	        $data=request()->post();
	        $rule = [
	            'account|账号'=>'require',
	            'name|名称'=>'require',
	        ];
  	        $this->validate($data,$rule);
  	    }catch (ValidateException $e){
  	        return fetchJson([],$e->getError(),1);
  	    }
    	$form=new StockApplyBecomeUser();
  		$form->acid=$this->acid;
  		$form->user_id=$this->user_id;
  		$form->account=$data['account'];
  		$form->name=$data['name'];
  		$form->save();
  		return fetchJson([],'提交成功');
    }
    //说明
   public function explain(){
        $data=Option::get_data($this->acid,'plugin','app_plugin_stock_explain');
        $data=@json_decode($data,1);
        if(!$data){
          $data['agreement']='';
              $data['help']='';
        }
        return fetchJson($data);
    }
}