<?php
namespace app\plugin\logic\stock\platform;
use app\shared\model\House;
use app\plugin\model\stock\House as StockHouse;
use app\plugin\model\stock\HouseUser as StockHouseUser;
use app\plugin\model\stock\User as StockUser;
use app\plugin\model\stock\Withdraw as StockWithdraw;

use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\platform\Base;
class WithdrawForm extends  Base
{
	//列表
	public function index()
    {
    	$query=StockWithdraw::where(['acid'=>$this->acid,'is_delete'=>0]);
    	if($keyword=input('keyword')){
    		$query->where('account|username','like',"%{$keyword}%");
    	}
    	$count=$query->count();
        $list=$query->order('id DESC')->page($this->page)->limit($this->limit)->select();
        return fetchJson([
        	'list'=>$list,
        	'count'=>$count
        ]);
    }
    //提现处理2
	public function handle()
    {
    	try {
           $data=request()->post();
           $rule = [
               'id|ID' => 'require|number',
               'status|状态'=>'require|number|in:1,2',
            ];
           $this->validate($data,$rule);
        }catch (ValidateException $e){
           return fetchJson([],$e->getError(),1);
        }
        $form=StockWithdraw::where(['acid'=>$this->acid,'status'=>0,'id'=>$data['id']])->find();
        if(!$form){
             return fetchJson([],'暂无提现记录',1);
        }
        if($data['status']==1){
        	$user=StockUser::where(['acid'=>$this->acid,'status'=>1,'is_delete'=>0,'id'=>$form['stock_user_id']])->find();
        	if(!$user){
        		return fetchJson([],'暂无股东',1);
        	}
        	if($user->money<$form->money){
        		return fetchJson([],'佣金不足',1);
        	}
        	$user->money-=$form->money;
        	$user->withdraw_price+=$form->money;
        	$user->save();
        }
        $form->status=$data['status'];
        $form->remark=input('remark');
        $form->save();
        return fetchJson([],'处理成功');
    }
}