<?php
namespace app\plugin\logic\stock\platform;
use app\shared\model\House;
use app\plugin\model\stock\House as StockHouse;
use app\plugin\model\stock\User as StockUser;
use app\plugin\model\stock\HouseUser as StockHouseUser;
use app\plugin\model\stock\ApplyBecomeUser as StockApplyBecomeUser;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\platform\Base;
class UserForm extends  Base
{
	//列表
	  public function index()
    {
        $query=StockUser::where(['acid'=>$this->acid,'is_delete'=>0]);
        $count=$query->count();
        $list=$query
              ->page($this->page)
              ->limit($this->limit)
              ->order('id DESC')
              ->select();
        return fetchJson([
          'count'=>$count,
          'list'=>$list,
        ]);
    }
    //编辑
    public function edit()
    {
        try {
	        $data=request()->post();
	        $rule = [
	            'id|ID' => 'require',
	            'account|账号'=>'require',
	            'status|状态'=>'require|in:0,1',
	        ];
  	        $this->validate($data,$rule);
  	    }catch (ValidateException $e){
  	        return fetchJson([],$e->getError(),1);
  	    }
        $form=StockUser::where(['id'=>$data['id']])->find();
  	    if(!$form){
              $form=new StockUser();
              $form->acid=$this->acid;
  	    }
  	    $form->save([
  	       'status'=>$data['status'],
  	       'account'=>$data['account'],
           'name'=>$data['name'],
  	    ]);
  	    return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
      	$id=input('id');
      	StockUser::where(['id'=>$id])->update(['is_delete'=>1]);
        return fetchJson([],'删除成功');
    }
    //申请成功为股东列表
    public function applyList(){
        $query=StockApplyBecomeUser::where(['acid'=>$this->acid,'is_delete'=>0]);
        $count=$query->count();
        $list=$query->order('id DESC')->page($this->page)->limit($this->limit)->select();
        return fetchJson([
          'list'=>$list,
          'count'=>$count
        ]);
    }
    //处理申请
    public function handleApply(){
         try {
            $data=request()->post();
            $rule = [
                'id|ID'=>'require',
                'status|状态'=>'require|in:1,2',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=StockApplyBecomeUser::where(['acid'=>$this->acid,'id'=>$data['id'],'status'=>0])->find();
        if(!$form){
            return fetchJson([],'已处理',1);
        }
        $form->status=$data['status'];
        if($form->status==1){
            if(StockUser::where(['acid'=>$this->acid,'account'=>$form['account'],'is_delete'=>0])->count()){
                return fetchJson([],'该股东已存在',1);
            }
            $store=new StockUser();
            $store->save([
                'acid'=>$this->acid,
                'account'=>$form['account'],
                'name'=>$form['name'],
                'status'=>1
            ]);
        }
        $form->save();
        return fetchJson([],'处理成功');
    }
}