<?php
namespace app\plugin\logic\stock\platform;
use app\shared\model\House;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\plugin\model\stock\House as StockHouse;
use app\plugin\model\stock\HouseUserOrder as StockHouseUserOrder;
use app\plugin\model\stock\User as StockUser;
use app\plugin\model\stock\HouseUser as StockHouseUser;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\platform\Base;
class OrderForm extends  Base
{
	//列表
	public function index()
  {     

        $query=StockHouseUserOrder::alias('u_o')
              ->leftJoin([StockHouse::getTable()=>'sh'],'u_o.stock_house_id=sh.id')
              ->leftJoin([House::getTable()=>'h'],'sh.house_id=h.id')
              ->leftJoin([StockUser::getTable()=>'su'],'u_o.stock_user_id=su.id')
              ->where(['u_o.acid'=>$this->acid,'u_o.is_delete'=>0]);
        if($house_id=input('house_id')){
            $query->where('h.id',$house_id);
        }
        if($order_no=input('order_no')){
            $ids=HouseOrder::where('order_no','like',"%{$order_no}%")->column('id');
            if(!$ids){
               $ids=HouseOrderContinue::where('order_no','like',"%{$order_no}%")->column('id');
            }
            $query->where('u_o.order_id','in',$ids);
        }       
        $count=$query->count();      
        $list=$query
              ->page($this->page)
              ->limit($this->limit)
              ->field('u_o.*,h.name,h.cover,h.address,su.name nickname,su.account')
              ->order('u_o.id DESC')
              ->select();
        foreach($list as &$value){
           if($value['type']==1){
              $value['order_no']=HouseOrder::where(['id'=>$value['order_id']])->value('order_no');
              $value['order_tip']='茶室预订';
           }else{
              $value['order_no']=HouseOrderContinue::where(['id'=>$value['order_id']])->value('order_no');
              $value['order_tip']='茶室续单';
           }
           
        }      
        return fetchJson([
          'list'=>$list,
          'count'=>$count
        ]);
    }
}