<?php
namespace app\plugin\logic\stock\platform;
use app\shared\model\House;
use app\plugin\model\stock\House as StockHouse;
use app\plugin\model\stock\HouseUser as StockHouseUser;
use app\plugin\model\stock\User as StockUser;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\platform\Base;
class HouseForm extends  Base
{
	//列表
	public function index()
    {
        $query=StockHouse::alias('sh')
              ->leftJoin([House::getTable()=>'h'],'sh.house_id=h.id')
              ->where(['sh.acid'=>$this->acid,'sh.is_delete'=>0]);
        $count=$query->count();
        $list=$query->page($this->page)
              ->limit($this->limit)
              ->field('sh.*,h.name,h.cover,h.address')
              ->order('sh.id DESC')
              ->select();
        foreach($list as &$value){
           $value['user_list']=StockHouseUser::where(['acid'=>$this->acid,'stock_house_id'=>$value['id'],'is_delete'=>0])->column('stock_user_id,ratio');
        }      
        return fetchJson([
          'list'=>$list,
          'count'=>$count
        ]);
    }
    //编辑
    public function edit()
    {
        try {
	        $data=request()->post();
	        $rule = [
	            'id|ID' => 'require',
	            'house_id|茶室ID'=>'require',
	            'status|状态'=>'require|in:0,1',
              'user_list|股东列表'=>'require'
	        ];
	        $this->validate($data,$rule);
	    }catch (ValidateException $e){
	        return fetchJson([],$e->getError(),1);
	    }
      $form=StockHouse::where(['id'=>$data['id']])->find();
	    if(!$form){
            $form=new StockHouse();
            $form->acid=$this->acid;
            $form->house_id=$data['house_id'];
            if(StockHouse::where(['acid'=>$this->acid,'house_id'=>$data['house_id'],'is_delete'=>0])->count()){
                return fetchJson([],'该茶室已经添加过了',1);
            }
	    }
      $user_list=@json_decode($data['user_list'],1);
      $ratio=0;
      foreach($user_list as $value){
          if(!isset($value['stock_user_id'])&&!isset($value['ratio'])){
             return fetchJson([],'股东数据错误',1);
          }
          if($value['ratio']<=0){
            return fetchJson([],'比例必须大于0',1);
          }
          $ratio+=$value['ratio'];
      }
      if($ratio>100){
          return fetchJson([],'股东总分红不得大于100',1);
      }
      if($ratio<0){
          return fetchJson([],'股东分红不得小于0',1);
      }
	    $form->save([
	       'status'=>$data['status'],
	       'house_id'=>$data['house_id'],
	    ]);
      StockHouseUser::where(['acid'=>$this->acid,'stock_house_id'=>$form->id])->update(['is_delete'=>1,'status'=>0]);
      foreach($user_list as $u){
         $user=StockHouseUser::where(['acid'=>$this->acid,'stock_user_id'=>$u['stock_user_id'],'stock_house_id'=>$form->id])->find();
         if(!$user){
           $user=new StockHouseUser();
           $user->acid=$this->acid;
           $user->stock_user_id=$u['stock_user_id'];
           $user->stock_house_id=$form->id;
         }
         $user->ratio=$u['ratio'];
         $user->is_delete=0;
         $user->status=1;
         $user->save();
      }
	    return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
    	$id=input('id');
    	StockHouse::where(['id'=>$id])->update(['is_delete'=>1]);
      return fetchJson([],'删除成功');
    }


}