<?php
namespace app\plugin\logic\mooncake\user;
use app\shared\model\House;
use app\shared\model\Option;
use app\shared\model\Store;
use app\shared\model\User;
use app\plugin\model\mooncake\Mooncake;
use app\plugin\model\mooncake\MooncakeUser;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\model\Coupon;
use app\shared\logic\user\UserForm;
use app\admin\model\Attachment;
use think\facade\Db;
class MooncakeForm extends  UserForm
{
  	//列表
  	public function index(){
      	$query=Mooncake::where(['acid'=>$this->acid,'is_delete'=>0]);
        $list=$query->select();
        foreach($list as $value){
            $value['coupon_list']=Coupon::where('id','in',$value['coupon_ids'])->column('name');
        }
        $prize_user=MooncakeUser::alias('m')->leftJoin([User::getTable()=>'u'],'m.user_id=u.id')->where(['m.status'=>1,'m.acid'=>$this->acid])->field('u.nickname,m.mooncake_name,u.avatar_url')->order('m.id DESC')->group('m.user_id')->limit(20)->select();
    	return fetchJson([
            'list'=>$list,
            'prize_user'=>$prize_user
        ],'获取列表');
    }
    //置色子
    public function playDice(){
       $dices=rand(1,6).','.rand(1,6).','.rand(1,6).','.rand(1,6).','.rand(1,6).','.rand(1,6);
       $prize_mooncake_id=self::prizeVerify($dices);
       $msg='很遗憾您什么也没中';
       $is_prize=0;
       $prize=[];
       $count=MooncakeUser::where(['user_id'=>$this->user_id,'acid'=>$this->acid])->whereDay('create_time')->count();
       $is_share=input('is_share');
       if($count<6&&$is_share==1){
          $form=new MooncakeUser();
          $form->acid=$this->acid;
          $form->user_id=$this->user_id;
          if($prize_mooncake_id){
            $mooncake=Mooncake::where('id',$prize_mooncake_id)->field('coupon_ids,name,id,num')->lock(true)->find();
            if($mooncake->num<=0){
                $mooncake->status=0;
                $mooncake->save();
                return fetchJson([
                ],'很遗憾奖品没有了',1);
            }
            $mooncake->num-=1;
            $form->status=1;
            $form->mooncake_name=$mooncake['name'];
            $mooncake->save();
            $form->mooncake_id=$prize_mooncake_id;
            Coupon::giveUserCoupon($this->user_id,5,$this->acid,$mooncake['coupon_ids']);
            $msg='恭喜您中奖了';
            $is_prize=1;
          }
          $form->dices=$dices;
          $form->save();
       }else{
           return fetchJson([
           ],'今日抽奖次数已达上线',1);
       }
       return fetchJson([
          'dices'=>$dices,
          'is_prize'=>$is_prize,
          'prize'=>$prize
       ],$msg);
    }
    //色子记录
    public function diceLog(){
        $list=MooncakeUser::alias('mu')->leftJoin([Mooncake::getTable()=>'m'],'mu.mooncake_id=m.id')->where(['mu.user_id'=>$this->user_id])
        ->order('mu.id DESC')
        ->page($this->page)->limit(20)->field('mu.*,m.name')->select();
        return fetchJson($list);
    }
    //判断中奖验证
    public function prizeVerify($dices=''){
        $dices=explode(',',$dices);
        $list=Mooncake::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->order('sort ASC')->where('num','>',0)->column('id,dices');
        $prize_mooncake_id=0;
        foreach($list as $value){
            $dicesV=explode(',',$value['dices']);
            $num=0;
            $prize_num=0;
            $array=$dices;
            foreach($dicesV as $v){
              if($v>0){
                $num++;
                $key=array_search($v,$array);
                if($key!==false){
                  unset($array[$key]);
                  $prize_num++;
                }
              }
            }
            if($prize_num>0&&$prize_num>=$num){
              $prize_mooncake_id=$value['id'];
               break;
            }
        }
        return $prize_mooncake_id;
    }

}
