<?php
namespace app\plugin\logic\mooncake\platform;
use app\shared\model\Option;
use app\shared\model\App;
use app\shared\model\User;
use wechatpay\WechatPay;
use app\plugin\model\mooncake\Mooncake;
use app\plugin\model\mooncake\MooncakeUser;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\logic\platform\Base;
class MooncakeForm extends  Base
{
	public function index()
    {
        $list=Mooncake::where(['acid'=>$this->acid,'is_delete'=>0])->order('sort ASC')->select();
    	return fetchJson($list);
    }
    //编辑
    public function edit()
    {
        try {
            $data=request()->post();
            $rule = [
                'id|ID' => 'require',
                'name|名称'=>'require',
                'coupon_ids|优惠券'=>'require',
                'status|状态'=>'require|in:0,1',
                'dices|点数' => 'require',
                'num|人数' => 'require'
            ];
            $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=Mooncake::where(['id'=>$data['id']])->find();
        if(!$form){
              $form=new Mooncake();
              $form->acid=$this->acid;
        }
        $form->save([
           'status'=>$data['status'],
           'coupon_ids'=>$data['coupon_ids'],
           'name'=>$data['name'],
           'sort'=>$data['sort'],
           'dices'=>$data['dices'],
           'num'=>$data['num']
        ]);
        return fetchJson([],'保存成功');
    }
    public function delete(){
         Mooncake::where(['acid'=>$this->acid,'id'=>input('id')])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //订单列表
    public function userList(){
        $status=input('status')?input('status'):0;
        $query=MooncakeUser::alias('mu')
        ->leftJoin([User::getTable()=>'u'],'mu.user_id=u.id')
        ->leftJoin([Mooncake::getTable()=>'m'],'mu.mooncake_id=m.id')
        ->where(['mu.acid'=>$this->acid,'mu.status'=>$status]);
        if($keyword=input('keyword')){
            $query->where('u.account|u.nickname','like',"%{$keyword}%");
        }
        $query->field('mu.*,u.nickname,u.avatar_url,u.account,m.name');
        $count=$query->count();
        $list=$query->page($this->page)->limit($this->limit)->order('mu.id DESC')->select();
        foreach($list as &$value){
            
        }
        return fetchJson([
            'count'=>$count,
            'list'=>$list
        ]);
    }
    

}