<?php
namespace app\api\logic;
use app\shared\model\Option;
use app\shared\model\Store;
use app\shared\model\Tags;
use app\shared\model\HouseOrder;
use app\shared\model\HouseStock;
use app\shared\model\User;
use app\shared\model\Facility;
use app\shared\model\CardUser;
use app\shared\model\House;
use app\shared\model\Card;
use app\shared\model\App;
use app\BaseController;
use wechatpay\WechatPay;
//商户列表
class StoreForm extends Base
{	
	//商户列表
    public function list(){
        $lat=input('lat')?input('lat'):0;
        $lng=input('lng')?input('lng'):0;
        $query=Store::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->field('id,name,logo,local,is_list_open,config,address,business_hours,douyin_poi_id,tel,lat,lng,score,(6378.138 * 2 * asin(sqrt(pow(sin((lat * pi() / 180 - '.$lat.' * pi() / 180) / 2),2) + cos(lat * pi() / 180) * cos('.$lat.' * pi() / 180) * pow(sin((lng * pi() / 180 - '.$lng.' * pi() / 180) / 2),2))) * 1000) as distance');
        if($keyword=input('keyword')){
          $query->where('name','like',"%$keyword%");
        }
        if($area_id=input('area_id')){
            $query->where('area_id',$area_id);
        }
        if($price_sort=input('price_sort')){
           if($price_sort==1){
               $query->order('tea_price ASC');
           }else{
               $query->order('tea_price DESC');
           }
        }
        if($category=input('category')){
          $query->whereFindInSet('category',$category);
        }
       if($distance_sort=input('distance_sort')){
           if($distance_sort==1){
               $query->order('distance ASC');
           }else{
               $query->order('distance DESC');
           }
       }else{
          $query->order('distance ASC');
       }
       $app=App::where('id',$this->acid)->field('wxapp_app_id,name,logo')->find();
       $app['logo']=get_file_url($app['logo']);
       $list=$query->page($this->page)->cache(10)->select();
       $discount=Card::where(['acid'=>$this->acid,'is_delete'=>0])->order('discount ASC')->value('discount');
       foreach ($list as $key => &$value) {
            $value['wxapp_app_id']=$app['wxapp_app_id'];
            $value['app_name']=$app['name'];
            $value['app_logo']=$app['logo'];
            $value['house_num']=House::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$value['id'],'status'=>1])->count();
            if($value['house_num']==0){
                unset($list[$key]);
                continue;
            }
            $value['logo']=get_file_url($value['logo']);
            $house = House::where(['acid' => $this->acid, 'is_delete' => 0, 'store_id' => $value['id'], 'status' => 1])
            ->field('id,booktime,half_price,price,original_price,package_price')
            ->order('booktime ASC')
            ->orderRaw("field(package_price,'[]') ASC")
            ->find();
            if (!$house) {
                $value['price'] = 0;
                $value['booktime'] = 1;
                $value['business_time'] = "00:00-24:00";
            } else {
                $house['booktime'] = $house['booktime'] ? $house['booktime'] : 1;
                $value['price'] = $house['price'] * $house['booktime'];
                $value['booktime'] = $house['booktime'];
                $value['original_price'] = $house['original_price'];
                $value['business_time'] = "00:00-24:00";
                if (!$discount) {
                    $value['member_price'] = -1;
                } else {
                    if ($value['member_price'] <= 0) {
                        $value['member_price'] = $value['price'] * $discount * 0.1;
                        $value['member_price'] = round($value['member_price'], 2);
                    }
                }
                $value['discount'] = $discount;
                $value['local'] = json_decode($value['local'], 1);
            }
            $order_book_time=HouseOrder::where(['store_id'=>$value['id']])->where('status','in','1,2')->whereDay('create_time')->order('create_time desc')->value('create_time');
            if($order_book_time){
                $order_book_time=date('Y-m-d H:i:s',$order_book_time);
                $order_book_time=format_date($order_book_time).'有人预定';
            }else{
                $order_book_time=0;
            }
            $value['order_book_time']=$order_book_time;
            $value['package_price'] = json_decode($house['package_price'], true);
            $config=@json_decode($value['config'],1);
            $value['select_name']=isset($config['select_name'])?$config['select_name']:'茶厅';
            $value['business_hours']=@json_decode($value['business_hours'],1);
       }
       return fetchJson($list); 
    }
    //商户信息
    public function info(){
         $store_id=input('id');
         $store=Store::where(['acid'=>$this->acid,'id'=>$store_id])->field('id,name,address,tags,tel,dec,lng,lat,banner,logo,service_facilities,facilities,policy,is_shop,config,local,video_url,share_img,business_hours,is_repast,is_direct_checkout')
         ->cache(10)->find();
         if(!$store){
             return fetchJson([],'暂无数据',1);
         }
         $store['banner']=get_file_urls($store['banner']);
         $store['logo']=get_file_url($store['logo']);
         $store['logo']=str_replace("http://","https://", $store['logo']);
         $tags=Tags::where(['acid'=>$this->acid])->where('id','in',explode(',', $store['tags']))->column('id,title');
         $store['tags']=$tags;
         $config=@json_decode($store['config'],1);
         $store['wifi_username']=isset($config['wifi_config']['username'])?$config['wifi_config']['username']:'';
         $store['wifi_password']=isset($config['wifi_config']['password'])?$config['wifi_config']['password']:'';
         $icon_config=isset($config['icon_config']['home']['icon'])?$config['icon_config']:[];
         $icon_config=isset($config['icon_config']['home']['icon'])?$config['icon_config']:[];
         $store['business_hours']=@json_decode($store['business_hours'],1);
         if(!$icon_config){
            $url=request()->domain().str_replace('index.php', '',request()->baseFile()).'static/shared/';
            $icon_config=[
                  'home'=>[
                    'title'=>'首页',
                    'status'=>1,
                    'icon'=>$url.'store_icon/home.png'
                  ],
                  'shop'=>[
                    'title'=>'茶城',
                    'status'=>1,
                    'icon'=>$url.'store_icon/shop.png'
                  ],
                  'kefu'=>[
                    'title'=>'客服',
                    'status'=>1,
                    'icon'=>$url.'store_icon/kefu.png'
                  ],
                  'wifi'=>[
                    'title'=>'WiFi',
                    'status'=>1,
                    'icon'=>$url.'store_icon/wifi.png'
                  ],
                  'code'=>[
                    'title'=>'商家码',
                    'status'=>1,
                    'icon'=>$url.'store_icon/code.png'
                  ],
                ];
         }
         $store['select_name']=isset($config['select_name'])?$config['select_name']:'';
         $store['icon_config']=$icon_config;
         $keyword=input('keyword');
         $query=House::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$store_id,'status'=>1]);
         $house_ids=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id])->where('status','in','1,2')->where('start_time','<',time())->where('end_time','>',time())->group('house_id')->column('house_id');
         if($house_ids){
            $house_ids=implode(',',$house_ids);
            $query->orderRaw('field(id,'.$house_ids.') ASC,sort ASC');
         }else{
            $query->order('sort ASC');
         }
         $list=$query->withoutField('lvelectricty_line_config,electricty_line_config,servicing_time,price_list,package_price,could_sound,electricityid')->cache(60)->select()->toArray();
         $discount=Card::where(['acid'=>$this->acid,'is_delete'=>0])->order('discount ASC')->value('discount');
         $cover_ids=[];
         $house_id_arr=[];
         foreach ($list as $key => &$value) {
             $banner=explode(',',$value['banner']);
             $cover_ids=array_merge($cover_ids,$banner);
             $house_id_arr[]=$value['id'];
             if(!$discount){
                  $value['member_price']=-1;
             }else{
                if($value['member_price']<=0){
                  $value['member_price']=$value['price']*$discount*0.1;
                  $value['member_price']=round($value['member_price'],2);
                }
                
             }
             $value['discount']=$discount;
             
         }
         $houseOrderCountArr=HouseOrder::where(['acid'=>$this->acid,'is_pay'=>1])->where('house_id','in',$house_id_arr)->where('status','<>',4)->field('house_id,count(house_id) booknum')->group('house_id')->select();
         if($houseOrderCountArr){
            $houseOrderCountArr=$houseOrderCountArr->toArray();
            $houseOrderCountArr=array_column($houseOrderCountArr,'booknum','house_id');
         }
         $houseStockCountArr=HouseStock::where(['acid'=>$this->acid])->where('house_id','in',$house_id_arr)
         ->where('hour',"<",time()+2*3600)
         ->where('hour',">",time())
         ->field('house_id,count(house_id) booknum')->group('house_id')->select();
         if($houseStockCountArr){
            $houseStockCountArr=$houseStockCountArr->toArray();
            $houseStockCountArr=array_column($houseStockCountArr,'booknum','house_id');
         }
         $get_cache_file_urls=get_cache_file_urls($cover_ids);
         foreach ($list as $key => &$value) {
            $banner=explode(',',$value['banner']);
            foreach($banner as $k=>$v){
                if(isset($get_cache_file_urls[$v])){
                    $banner[$k]=$get_cache_file_urls[$v];
                }else{
                    unset($banner[$k]);
                }
            }
            $value['banner_list']=$banner;
            //预定数量
            $value['booknum']=isset($houseOrderCountArr[$value['id']])?$houseOrderCountArr[$value['id']]:0;
            $virtual_sales=isset($value['virtual_sales'])?$value['virtual_sales']:0;
            $value['booknum']+=$virtual_sales;
            $value['is_book']=isset($houseStockCountArr[$value['id']])?1:0;
         }

         $user_id=User::where('access_token',input('access_token'))->value('id');
         $cardUser=CardUser::alias('c_u')
          ->leftJoin([Card::getTable()=>'c'],'c_u.card_id=c.id')
          ->where(['c_u.status'=>1,'c_u.user_id'=>$user_id,'c.is_delete'=>0])
          ->where('c_u.start_time','<',time())
          ->where('c_u.end_time','>',strtotime(date('Y-m-d',time()+86400)))
          ->order('c_u.level DESC')->field('c_u.*,c.discount')->find();
          $discount=-1;
          if($cardUser){
            $discount=$cardUser['discount'];
          }
          $store['user_discount']=$discount;
          unset($store['config']);

          //主题颜色
          $app_home_theme=Option::get_data($this->acid,'shared','app_home_theme');

          $app_home_theme=@json_decode($app_home_theme,1);
          if(!$app_home_theme){
                $app_home_theme=\app\shared\model\Theme::defaultTheme();
          }

          return fetchJson([
            'info'=>$store,
            'house_list'=>$list,
            'app_home_theme'=>$app_home_theme,
         ]);
    }
    //茶室信息
    public function houseInfo(){
       $form=House::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>input('house_id'),'status'=>1])->find();
       if(!$form){
          return fetchJson([],'暂无数据',1);
       }
       $dateTime=input('date')?strtotime(input('date')):strtotime(date('Y-m-d'));
       $form['package_price']=@json_decode($form['package_price'],1);
       //___________________________________________________
       //今天
       $stockToday=HouseStock::where(['acid'=>$this->acid,'store_id'=>$form->store_id,'house_id'=>$form['id'],'date'=>$dateTime,'status'=>0])->order('hour ASC')->column('hour,status,order_id');
       $tomorrowtime=$dateTime+86400;
       $stockTomorrow=HouseStock::where(['acid'=>$this->acid,'store_id'=>$form->store_id,'house_id'=>$form['id'],'date'=>$tomorrowtime,'status'=>0])->column('hour,status,order_id');
       $allstock=array_merge($stockToday,$stockTomorrow);
       $orderNew=[];
       $allstock=self::changeHouseStock($allstock);

       $allstock=array_column($allstock,'status','hour');
       $servicing_today_time=[];
       $price_list=@json_decode($form['price_list'],1);
       if($price_list){
         $priceData=array_column($price_list,'price','time');
       }
       for ($j=0;$j<(49);$j++){
          $time=strtotime(date('Y-m-d H:i',$dateTime))+1800*$j; 
          $timeTomorrow=strtotime(date('Y-m-d H:i',$dateTime+86400))+1800*$j; 
          $t=date('H',$time);
          $tt=date('H',$timeTomorrow);
          $servicing_today_time[]=[
            'status'=>isset($allstock[$time])?$allstock[$time]:1,
            'time'=>date('H:i',$time),
            'price'=>isset($priceData[$t])?$priceData[$t]/2:$form['price']/2,
          ];
          $servicing_tomorrow_time[]=[
            'status'=>isset($allstock[$timeTomorrow])?$allstock[$timeTomorrow]:1,
            'time'=>date('H:i',$time),
            'price'=>isset($priceData[$tt])?$priceData[$tt]/2:$form['price']/2,
          ];
       }
       $form['servicing_today_time']=$servicing_today_time;
       $form['servicing_tomorrow_time']=$servicing_tomorrow_time;
       $form['banner_list']=get_file_urls($form['banner']);
       $form['facility_servicing_list']=Facility::where('id','in',$form['facility_servicing'])->column('id,title');
       $store=Store::where(['id'=>$form['store_id']])->find();
       $form['tel']=$store['tel'];
       $form['local']=$store['local'];
       $form['lat']=$store['lat'];
       $form['lng']=$store['lng'];
       $form['address']=$store['address'];
       $form['is_wallet']=$store['is_wallet'];
       $form['booknum']=HouseOrder::where(['acid'=>$this->acid,'is_pay'=>1,'house_id'=>$form['id']])->where('status','<>',4)->count();
       $virtual_sales=isset($form['virtual_sales'])?$form['virtual_sales']:0;
       $form['booknum']+=$virtual_sales;
       $form['is_book']=HouseStock::where(['acid'=>$this->acid,'store_id'=>$form->store_id,'house_id'=>$form['id']])->where('hour',"<",time()+$form['booktime']*3600)->where('hour',">",time())->count();
       $form['is_book']=$form['is_book']>0?1:0;
       //主题颜色
       $app_home_theme=Option::get_data($this->acid,'shared','app_home_theme');

       $app_home_theme=@json_decode($app_home_theme,1);
       if(!$app_home_theme){
            $app_home_theme=\app\shared\model\Theme::defaultTheme();
       }
       $form['app_home_theme']=$app_home_theme;
       return fetchJson($form);
    }
     private function changeHouseStock($stockToday){
       $orderNew=[];
       foreach ($stockToday as &$t){
           $orderNew[$t['order_id']][]=$t;
       }
       foreach ($orderNew as &$n){
          $n=array_merge([[
            'hour'=>$n[0]['hour']-1800,
            'status'=>$n[0]['status'],
            'order_id'=>$n[0]['order_id'],
          ]],$n);
       }
       $stockToday=[];
       foreach ($orderNew as &$d){
           foreach ($d as $s){
               $stockToday[]=$s;
           }
       }
       $dateTime=input('date')?strtotime(input('date')):time();
       $stockDatas=[];
       for ($j=0;$j<96;$j++){
           $time=strtotime(date('Y-m-d H:i',$dateTime))+1800*$j;
           foreach($stockToday as $v){
              if($time>($v['hour']-1800)&&$time<($v['hour']+1800)){
                    $stockDatas[$time]=[
                      'hour'=>$time,
                      'status'=>$v['status'],
                      'order_id'=>$v['order_id'],
                   ];
              }
           }
        }
       return $stockDatas;
    }
}