<?php
namespace app\api\logic;
use app\shared\model\User;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\House;
use app\shared\model\Coupon;
use app\shared\model\CouponUser;
use app\shared\model\StoreCoupon;
use app\shared\model\StoreCouponUser;
use app\shared\model\HouseStock;
use app\shared\model\WeixinUser;
use app\shared\model\Electricity;
use app\shared\model\App;
use app\shared\model\Option;
use app\shared\model\StoreCleaning;
use app\shared\model\Card;
use app\shared\model\CardUser;
use app\shared\model\CardUserOrder;
use wechatpay\WechatPay;
use app\shared\model\Store;
use app\shared\model\Bill;
use app\shared\model\ElectricityLine;
use app\plugin\model\stock\User as StockUser;
use app\plugin\model\stock\House as StockHouse;
use app\plugin\model\stock\HouseUser as StockHouseUser;
use app\plugin\model\stock\HouseUserOrder as StockHouseUserOrder;
use app\shared\model\CardCoupon;
use app\shared\model\StoreUserMoney;
use app\shared\model\Partner;
use app\shared\model\PartnerUser;
use app\shared\model\PartnerUserOrder;
use slock\Slock;
use think\facade\Cache;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
class HouseOrderForm extends  Base
{

    //获取时间价格
    private function getTimePirce($house,$starttime,$endtime,$feeHour=0){
        $price_list=@json_decode($house['price_list'],1);
        $halfDay=($endtime-$starttime)/1800;
        $priceArr=[];
        $timePirce=0;
        //每个小时的钱
        if($feeHour>0){
          $feeHour=(int)($feeHour*2);
          if(empty($price_list)){
             return ($feeHour)*$house['price']/2;
          }
          $feeHour-=1;
          $priceData=array_column($price_list,'price','time');
          for ($j=0;$j<($halfDay);$j++){
              $key=date('H',$starttime+1800*$j); 
              $timePirce+=$priceData[$key]/2;
              if($j>=$feeHour){
                break;
              }
          }
          if($timePirce<=0){
            return $halfDay*$house['price']/2;
          }
          return $timePirce;
        }
        if(empty($price_list)){
           return $halfDay*$house['price']/2;
        }
        $priceData=array_column($price_list,'price','time');
        for ($j=0;$j<($halfDay);$j++){
            $key=date('H',$starttime+1800*$j); 
            $timePirce+=$priceData[$key]/2;
        }
        if($timePirce<=0){
          return $halfDay*$house['price']/2;
        }
        return $timePirce;
    }
    //提交预览
    public function submitPreview(){
      try {
          $data=request()->post();
          $rule = [
               'house_id|房间ID' => 'require|number',
               'start_time|开始时间'=>'require',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $house=House::where('id',$data['house_id'])->find();
       if(!$house){
          return fetchJson([],'暂无茶室',1);
       }
       $order_id=input('order_id');
       $book_type=input('book_type');

       $start_time=strtotime($data['start_time']);
       if($book_type!=2&&$book_type!=3){
          if($start_time<time()){
              return fetchJson([],'预订时间已过1',1);
          }
       }
       $end_time=strtotime(input('end_time'));
       if(!$order_id){
           if($end_time<time()){
                return fetchJson([],'预订时间已过',1);
           }
       }else{
           $endOrderTime=$start_time+$house['limit_time']*3600;
           $end_time=time();
           if($end_time>$endOrderTime){
              $end_time=$endOrderTime;
           }
       }
       $starttime=strtotime(date('Y-m-d H:i',$start_time));
       $endtime=strtotime(date('Y-m-d H:i',$end_time));
       $halfDay=($endtime-$starttime)/1800;
       $dayArr=[];
       for ($j=0;$j<($halfDay+1);$j++){ 
          $dayArr[]=$starttime+1800*$j;
       }
       if(!$order_id){
           $is_booKtime=HouseStock::where(['acid'=>$house['acid'],'store_id'=>$house['store_id'],'house_id'=>$data['house_id'],'status'=>0])->where('hour','in',$dayArr)->count();
           if($is_booKtime){
              return fetchJson([],'该时间段已预订',1);
           }
           foreach ($dayArr as $dV){
               $is_booKtime=HouseStock::where(['acid'=>$house['acid'],'store_id'=>$house['store_id'],'house_id'=>$data['house_id'],'status'=>0])->where('hour','>=',$dV)->where('hour','<=',$end_time)->column('id,hour');
               if($is_booKtime){
                  return fetchJson([],date('Y-m-d H:i:s',$dV).'该时间段已预订',1);
               }
           }
       }
       $num=($endtime-$start_time)/3600;
       $booktime=$house['booktime']>0?$house['booktime']:1;
       if($num<$booktime){
          if(!$order_id){
             return fetchJson([],'预订时间请大于等于'.$booktime.'小时',1);
          }
       }
       $orderPrice=self::getTimePirce($house,$start_time,$end_time);
       $package_price=@json_decode($house['package_price'],1);
       if($package_price){
          foreach ($package_price as $package){
              if(isset($package['num'])&&isset($package['price'])){
                if($package['num']==$num){
                  $orderPrice=$package['price'];
                  break;
                }
              }
          }
       }
       $payPrice=$orderPrice;
       return fetchJson([
          'price'=>round($orderPrice,2),
          'pay_price'=>round($payPrice,2),
          'warm_hint'=>Store::where(['id'=>$house['store_id']])->value('warm_hint')
       ]);

    }
    //提交订单
    public function submit(){
        try {
          $data=request()->post();
          $rule = [
               'house_id|房间ID' => 'require|number',
               'start_time|入住时间'=>'require',
               'tel|电话'=>'require',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }

       $house=House::where('id',$data['house_id'])->withoutField('electricityid,gatelockid,electricty_line_config,lvelectricty_line_config,could_sound,servicing_time,is_wallet')->find();
       if(!$house){
          return fetchJson([],'暂无茶室',1);
       }
       if($order_id=input('order_id')){
           $order=HouseOrder::where('id',$order_id)->find();
           if(!$order){
              return fetchJson([],'暂无订单',1);
           }
           $starttime=$order->start_time;
           $start_time=$order->start_time;
           $endtime=strtotime(date('Y-m-d H:i',time()));
           $endOrderTime=$starttime+$house['limit_time']*3600;
           if($endtime>$endOrderTime){
              $endtime=$endOrderTime;
           }
           $order->end_time=$endtime;
           $end_time=$endtime;
       }else{
           $book_type=input('book_type');
           $start_time=strtotime($data['start_time']);
           if($book_type!=2){
              if($start_time<time()){
                  return fetchJson([],'预订时间已过',1);
              }
           }
           $end_time=strtotime($data['end_time']);
           //优化----------------------------------
           $newhours=($end_time-$start_time)/3600;
           if($start_time<time()){
              $start_time=strtotime(date('Y-m-d H:i',time()));
              $end_time=$start_time+$newhours*3600;
           }
           //优化----------------------------------
           if($end_time<time()){
              return fetchJson([],'预订时间已过',1);
           }
           if($start_time>$end_time){
              return fetchJson([],'预订时间错误',1);
           }
           $starttime=strtotime(date('Y-m-d H:i',$start_time));
           $endtime=strtotime(date('Y-m-d H:i',$end_time));
           $halfDay=($endtime-$starttime)/3600;
           $booktime=$house['booktime']>0?$house['booktime']:1;
           if($halfDay<$booktime){
              return fetchJson([],'预订时间请大于等于'.$booktime.'小时',1);
           }
           $dayArr=[];
           for ($j=0;$j<($halfDay+1);$j++){ 
              $dayArr[]=$starttime+1800*$j;
           }
           $is_booKtime=HouseStock::where(['acid'=>$house['acid'],'store_id'=>$house['store_id'],'house_id'=>$data['house_id'],'status'=>0])->where('hour','in',$dayArr)->count();
           if($is_booKtime){
              return fetchJson([],'该时间段已预订',1);
           }
           foreach ($dayArr as $dV){
               $is_booKtime=HouseStock::where(['acid'=>$house['acid'],'store_id'=>$house['store_id'],'house_id'=>$data['house_id'],'status'=>0])->where('hour','>=',$dV)->where('hour','<=',$end_time)->count();
               if($is_booKtime){
                  return fetchJson([],date('Y-m-d H:i:s',$dV).'该时间段已预订',1);
               }
           }
           $order=new HouseOrder();
           $order->acid=$this->acid;
           $order->user_id=User::where('account',$data['tel'])->value('id');
           $order->order_no=HouseOrder::crateOrderNo();
           $order->username='Atroom订单';
           $order->tel=$data['tel'];
           $order->house_id=$data['house_id'];
           $order->store_id=$house['store_id'];
           $order->start_time=$starttime;
           $order->end_time=$endtime;
           $order->is_verifier=$house['open_type']==2?1:0;
           Db::startTrans();
           try {
                 //开始时间跟结束时间的判断
                $isOrderStartTime=HouseOrder::where(['acid'=>$this->acid,'house_id'=>$data['house_id']])->lock(true)
                   ->whereTime('start_time', '<=',$starttime)
                   ->whereTime('end_time', '>=',$starttime)
                   ->whereTime('create_time','>=',time()-30)
                   ->whereTime('create_time','<=',time())                
                   ->find();
                $isOrderEndTime=HouseOrder::where(['acid'=>$this->acid,'house_id'=>$data['house_id']])->lock(true)
                   ->whereTime('start_time', '<=',$endtime)
                   ->whereTime('end_time', '>=',$endtime)
                   ->whereTime('create_time','>=',time()-30)
                   ->whereTime('create_time','<=',time())                
                   ->find();

                  //续单开始时间跟结束时间的判断
                $isxDOrderStartTime=HouseOrderContinue::where(['acid'=>$this->acid,'house_id'=>$data['house_id']])->lock(true)
                   ->whereTime('start_time', '<=',$starttime)
                   ->whereTime('end_time', '>=',$starttime)
                   ->whereTime('create_time','>=',time()-30)
                   ->whereTime('create_time','<=',time())                
                   ->find();
                $isxDOrderEndTime=HouseOrderContinue::where(['acid'=>$this->acid,'house_id'=>$data['house_id']])->lock(true)
                   ->whereTime('start_time', '<=',$endtime)
                   ->whereTime('end_time', '>=',$endtime)
                   ->whereTime('create_time','>=',time()-30)
                   ->whereTime('create_time','<=',time())                
                   ->find();  
                if($isOrderStartTime||$isOrderEndTime){
                      return fetchJson([],'该时间段已经有人正在预定！',1);
                }
                if($isxDOrderStartTime||$isxDOrderEndTime){
                      return fetchJson([],'该时间段已经有人正在续单！',1);
                }
                Db::commit();
            } catch (\Exception $e) {
                // 回滚事务
                Db::rollback();
                return fetchJson([],$e->getMessage(),1);
     
           }


       }
       $num=($endtime-$start_time)/3600;
       $num=round($num,2);
       $num1=explode(".",$num);
       if(isset($num1[1])){
           $x=$num1[0];
           $y=$num1[1];
           if($y>=50){
             $x+=1;
             $y=0;
           }
           if($y>0&&$y<50){
             $y=50;
           }
           $num=$x.".".$y;
           $num=$num*1;
       }
       $order->price=self::getTimePirce($house,$start_time,$end_time);
       $package_price=@json_decode($house['package_price'],1);
       if($package_price){
          foreach ($package_price as $package){
              if(isset($package['num'])&&isset($package['price'])&&isset($package['title'])){
                if($package['num']==$num){
                  $order->price=$package['price'];
                  $order->package_price=$package['title'];
                  break;
                }
              }
          }
       }
       $time=time();
       $orderPrice=$order->price;
       $orderPayPrice=$order->price;
       $order->is_sass=1;
       $order->pay_price=$orderPayPrice>0?$orderPayPrice:0;
       $store=Store::where('id',$house['store_id'])->field('name,account,address,lat,lng')->find();
       $house['is_wallet']=$store['is_wallet'];
       $house['store_info']=$store;
       $order->snapshoot=json_encode($house);
       $order->store_id=$house['store_id'];
       $order->book_type=input('book_type');
       $order->is_qianya=1;
       $order->save();
       return fetchJson($order);
    }
    //支付订单
    public function orderPay(){
        $order_id=input('order_id');
        $order=HouseOrder::where(['id'=>$order_id])->where(['is_qianya'=>1])->find();

        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        if($order->status==0){
            $order->status=1;
            $order->pay_time=time();
            $order->is_pay=1;
            $order->pay_type=2;
            $order->save();
            HouseStock::where([
                'acid'=>$order->acid,
                'house_id'=>$order->house_id,
                'order_id'=>$order->id,
                'store_id'=>$order->store_id,
            ])->update(['status'=>1]);
            //------------------------------------
            $start_time=$order->start_time;
            if($order['book_type']==3){
               $minute=date('i',$start_time);
               $hour=date('Y-m-d H',$start_time).":00";
               if($minute<=30&&$minute>0){
                  $hour=strtotime($hour);
               }
               if($minute>30){
                  $hour=strtotime($hour)+1800;
               }
               $start_time=$hour;
            }
            $stockInsert=[];
            $numB=($order->end_time-$start_time)/1800;
            for ($j=0;$j<$numB+1;$j++){
               $time=$start_time+(1800*$j);
               if($time>($start_time-1800)&&$time<($order->end_time+1800)){
                    $stockOrder=HouseStock::where([
                        'acid'=>$order->acid,
                        'date'=>strtotime(date('Y-m-d',$time)),
                        'house_id'=>$order->house_id,
                        'hour'=>$time,
                        'store_id'=>$order->store_id,
                    ])->find(); 
                    if(!$stockOrder){
                        $stockInsert[]=[
                            'acid'=>$order->acid,
                            'date'=>strtotime(date('Y-m-d',$time)),
                            'house_id'=>$order->house_id,
                            'hour'=>$time,
                            'order_id'=>$order->id,
                            'store_id'=>$order->store_id,
                            'create_time'=>time(),
                            'update_time'=>time(),
                        ];
                    }else{
                        $stockOrder->order_id=$order->id;
                        $stockOrder->status=0;
                        $stockOrder->save();
                    }
               } 
            }
            HouseStock::insertAll($stockInsert);
            self::sendSubscribePay($order);
        }
        return fetchJson([],'订单已支付');

    }

    //--------------------------------------------------------------
    public function sendSubscribePay($order=[]){
        $account=User::where(['id'=>$order->user_id])->value('account');
        $openid=WeixinUser::where(['mobile'=>$account])->value('wxapp_open_id');
        $snapshoot=@json_decode($order->snapshoot,1);
        $app=App::where('id',$order->acid)->field('id acid,wx_app_id,wx_app_secret,wxapp_app_id,wxapp_app_secret')->find();
        $app['wx_template_cleaning_inform']=Option::get_data($order->acid,'platform','wx_template_cleaning_inform');
        $app['wx_template_cleaning_port_inform']=Option::get_data($order->acid,'platform','wx_template_cleaning_port_inform');
        $store=Store::where('id',$order['store_id'])->field('name,openid')->find();
        //发送保洁人员
        $weixin=new \weixin\Wechat();
        $data=[
            "first"    =>[
              "value"  =>"用户下单提醒",
              "color"  =>"#173177"
            ],
            "keyword1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
              "color"  =>"#173177"
            ],
            "keyword2" =>[
              "value"  =>$store['name'],//保洁员：
              "color"  =>"#173177"
            ],
            "keyword3" =>[
              "value"  =>"共享茶室",//保洁类型：
              "color"  =>"#173177"
            ],
            "keyword4" =>[
              "value"  =>date('Y-m-d H:i:s',$order->start_time).'之前', //保洁时间：
              "color"  =>"#173177"
            ],
            "remark"   =>[
              "value"  =>'用户订单时间'.date('Y-m-d H:i:s',$order->start_time).'至'.date('Y-m-d H:i:s',$order->end_time),
              "color"  =>"#173177"
            ]
        ];

        $openidArr=explode(',', $store['openid']);
        $weixin->sendWxopenTemplatePro($app,$app['wx_template_cleaning_inform'],$openidArr,"pages/index/index",$data);
        // foreach ($openidArr as $openid) {
        //    $res=$weixin->sendWxopenTemplate($app,$app['wx_template_cleaning_inform'],$openid,"pages/index/index",$data);
        // }
        self::sendCleaningTplPay($app,$order);
        
    }
    //保洁端用户下单提醒
    public function sendCleaningTplPay($app,$order){
        $cleaning= StoreCleaning::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'is_delete'=>0,'status'=>1])->where('openid','<>','')->column('openid,account');
        $snapshoot=@json_decode($order->snapshoot,1);
        $store=Store::where('id',$order->store_id)->field('address,name')->find();
        //发送保洁人员
        $weixin=new \weixin\Wechat();
        $data=[
            "first"    =>[
              "value"  =>"用户在店【{$store['name']}】"."下单提醒",
              "color"  =>"#173177"
            ],
            "keyword1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
              "color"  =>"#173177"
            ],
            "keyword2" =>[
              "value"  =>$store['address'],//房间地址：
              "color"  =>"#173177"
            ],
            "keyword3" =>[
              "value"  =>date('Y-m-d H:i:s',$order->end_time).'之后', //保洁时间：
              "color"  =>"#173177"
            ],
            "remark"   =>[
              "value"  =>'用户订单时间'.date('Y-m-d H:i:s',$order->start_time).'至'.date('Y-m-d H:i:s',$order->end_time),
              "color"  =>"#173177"
            ]
        ];
        $openidArr=array_column($cleaning,'openid','account');
        $res=$weixin->sendWxopenTemplatePro($app,$app['wx_template_cleaning_port_inform'],$openidArr,"pages/index/index",$data);
        foreach($cleaning as $value){
            \app\shared\model\MessageLog::pushMsg($order->acid,$value['account'],$order->order_no,json_encode($data,JSON_UNESCAPED_UNICODE),json_encode($res));
        }
    }
    //--------------------------------------------------------------

    //取消订单
    public function cancelOrder(){
        $order_id=input('order_id');
        $order=HouseOrder::where(['id'=>$order_id,'is_qianya'=>1])->where('status','in','0,1')->find();
        if(!$order){
           return fetchJson([],'暂无订单',1);
        }
        if($order->status==0){
           $order->status=-1;
           $order->save();
           return fetchJson([],'取消成功');
        }
        //已支付
        if($order->status==1){
              $refund_rate=Store::where('id',$order->store_id)->value('refund_rate');
              if(!$refund_rate){
                 $refund_rate=0;
              }
              $refund_price=$order->pay_price*(100-$refund_rate)*0.01;
              $refund_price=filter_money($refund_price);
              $refund_fee_price=$order->pay_price-$refund_price;
              //还原库存
              HouseStock::where([
                'acid'=>$order->acid,
                'house_id'=>$order->house_id,
                'order_id'=>$order->id,
                'store_id'=>$order->store_id,
             ])->update(['status'=>1,'order_id'=>0]);
             $order->status=-2;
             $order->save();
             $app=App::find($order->acid);
             //发送保洁人员
             $weixin=new \weixin\Wechat();
             $snapshoot=@json_decode($order->snapshoot,1);
             $data=[
                "first"    =>[
                  "value"  =>"取消订单",
                  "color"  =>"#173177"
                ],
                "keyword1" =>[
                  "value"  =>date("Y-m-d H:i",$order->start_time).' 至 '.date("Y-m-d H:i",$order->end_time),//取消时间
                  "color"  =>"#173177"
                ],
                "keyword2" =>[
                  "value"  =>$snapshoot['name'],//标签
                  "color"  =>"#173177"
                ],
                "remark"   =>[
                  "value"  =>"顾客取消订单~ :(",
                  "color"  =>"#173177"
                ]
            ];
            $openids=Store::where('id',$order->store_id)->value('openid');
            if($openids){
                $openidArr=explode(',',$openids);
                $tpl=Option::get_data($this->acid,'platform','wx_template_cancel_order_inform');
                $res=$weixin->sendWxopenTemplatePro($app,$tpl,$openidArr,'pages/index/index',$data);
            }
            self::sendCleaningTpl($app,$order);
        }
        return fetchJson([],'退款成功');
    }
    //保洁端用户下单提醒
    public function sendCleaningTpl($app,$order){
        $cleaning= StoreCleaning::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'is_delete'=>0,'status'=>1])->where('openid','<>','')->column('openid,account');
        $snapshoot=@json_decode($order->snapshoot,1);
        $store=Store::where('id',$order->store_id)->field('address,name')->find();
        //发送保洁人员
        $weixin=new \weixin\Wechat();
        $data=[
            "first"    =>[
              "value"  =>"用户在店【{$store['name']}】"."取消订单",
              "color"  =>"#173177"
            ],
            "keyword1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
              "color"  =>"#173177"
            ],
            "keyword2" =>[
              "value"  =>$store['address'],//房间地址：
              "color"  =>"#173177"
            ],
            "keyword3" =>[
              "value"  =>date('Y-m-d H:i:s',$order->end_time).'之后', //保洁时间：
              "color"  =>"#173177"
            ],
            "remark"   =>[
              "value"  =>'用户取消订单时间'.date('Y-m-d H:i:s',$order->start_time).'至'.date('Y-m-d H:i:s',$order->end_time),
              "color"  =>"#173177"
            ]
        ];
        $tpl=Option::get_data($order->acid,'platform','wx_template_cleaning_port_inform');
        $openidArr=array_column($cleaning,'openid','account');
        $res=$weixin->sendWxopenTemplatePro($app,$tpl,$openidArr,"pages/index/index",$data);
        foreach($cleaning as $value){
            
            \app\shared\model\MessageLog::pushMsg($order->acid,$value['account'],$order->order_no,json_encode($data,JSON_UNESCAPED_UNICODE),json_encode($res));
        }
    }
    
    //详情
    public function details(){
        $order_id=input('order_id');
        $order=HouseOrder::where(['id'=>$order_id])->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        $order['snapshoot']=@json_decode($order['snapshoot'],1);
        $order['store']=Store::where('id',$order['store_id'])->field('tel,name')->find();
        if($order['book_type']==3&&$order['is_pay']==0){
           $order['start_time']=date("Y-m-d H:i:s",$order['start_time']);
           $order['end_time']=$order['end_time']>0?date("Y-m-d H:i:s",$order['end_time']):'';
           return fetchJson($order,'获取成功');
        }
        $order_continue_list=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('id DESC')->column('id,start_time,pay_price,price,end_time');
        $price=0;
        foreach ($order_continue_list as $key => &$value) {
          $value['start_time']=date('Y-m-d H:i',$value['start_time']);
          $value['end_time']=date('Y-m-d H:i',$value['end_time']);
          $price+=$value['pay_price'];
          $value['discounts_price']=$value['price']-$value['pay_price'];
        }
        $end_time=$order->end_time;
        $start_time=$order->start_time;
        $xdstart_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('id ASC')->value('start_time');
        $start_time=$order['start_time'];
        if($xdstart_time){
          //续单
          if($xdstart_time>$order['start_time']){
              $xdend_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('id DESC')->value('end_time');
              $end_time=$xdend_time;
          }else{
            //向前续单
              $start_time=$xdstart_time;
          }
        }
        $order['start_time']=date("Y-m-d H:i:s",$start_time);
        $order['end_time']=date("Y-m-d H:i:s",$end_time);

        if($start_time<time()&&$order['status']==1){
           HouseOrder::where(['id'=>$order_id])->update(['status'=>2]);
        }
        $order['pay_price']+=$price;
        $order['order_continue_list']=$order_continue_list;
       
        //判断是否使用合伙人
        $is_table = Db::query('show tables like "'.PartnerUserOrder::getTable().'"');
        if($is_table){
          $partner_order=PartnerUserOrder::alias('puo')
          ->leftJoin([PartnerUser::getTable()=>'pu'],'puo.user_partner_id=pu.id')
          ->leftJoin([Partner::getTable()=>'p'],'pu.partner_id')
          ->where(['puo.order_id'=>$order->id,'puo.status'=>1])
          ->field("puo.*,p.title")->find();
          $order['partner_user_order']=$partner_order;
        }else{
          $order['partner_user_order']=[];
        }
        $order['cancel_time']=House::where('id',$order['house_id'])->value('cancel_time');
        $order['warm_hint']=Store::where(['id'=>$order['store_id']])->value('warm_hint');
        return fetchJson($order,'获取成功');
    }

    //订单续单预览
    public function orderContinuePreview(){
         try {
            $data=request()->post();
            $rule = [
                 'order_id|订单ID' => 'require|number',
                 'time|入住时间'=>'require|in:0.5,1,1.5,2,2.5,3,3.5,4,4.5,5,5.5,6,6.5,7,7.5,8,8.5,9,9.5,10',
             ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         $order=HouseOrder::where(['id'=>$data['order_id'],'is_pay'=>1])->where('status','in','1,2')->find();
         if(!$order){
            return fetchJson([],'暂无订单',1);
         }
         //向前续单
         if($type=input('type')){
              $start_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('start_time ASC')->value('start_time');
              if($start_time){
                $start_time=$start_time-$data['time']*3600;
                if($start_time<time()){
                   $start_time=time();
                }
                $end_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('start_time ASC')->value('start_time');
              }else{
                $start_time=$order->start_time-$data['time']*3600;
                if($start_time<time()){
                   $start_time=time();
                }
                $end_time=$order->end_time;
              }
         }else{
           // 向后续单
           $end_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('end_time DESC')->value('end_time');
           if($end_time){
              $start_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('end_time DESC')->value('end_time');
              $end_time=$end_time+$data['time']*3600;

           }else{
              $start_time=$order->end_time;
              $end_time=$order->end_time+$data['time']*3600;
           }
         }
         if($end_time<time()){
            return fetchJson([],'预订时间已过',1);
         }
         if($start_time>$end_time){
            return fetchJson([],'预订时间错误',1);
         }
         $starttime=strtotime(date('Y-m-d H:i',$start_time));
         $endtime=strtotime(date('Y-m-d H:i',$end_time));
         $halfDay=($endtime-$starttime)/3600;
         $num=$halfDay;
         $dayArr=[];
         for ($j=1;$j<($halfDay+1);$j++){ 
            $dayArr[]=$starttime+1800*$j;
         }
         $is_booKtime=HouseStock::where(['acid'=>$order['acid'],'store_id'=>$order['store_id'],'house_id'=>$order['house_id'],'status'=>0])->where('hour','in',$dayArr)->where('order_id','<>',$data['order_id'])->count();
         if($is_booKtime){
            return fetchJson([],'该时间段已被预订，请重新预约茶室',1);
         }
         foreach ($dayArr as $dV){
             $is_booKtime=HouseStock::where(['acid'=>$order['acid'],'store_id'=>$order['store_id'],'house_id'=>$order->house_id,'status'=>0])->where('hour','>=',$dV)->where('hour','<=',$endtime)->count();
             if($is_booKtime){
                return fetchJson([],date('Y-m-d H:i:s',$dV).'该时间段已预订',1);
             }else{
                 $is_booKtime=HouseStock::where(['acid'=>$order['acid'],'store_id'=>$order['store_id'],'house_id'=>$order->house_id,'status'=>0])->where('hour',$endtime)->count();
                 if($is_booKtime){
                    return fetchJson([],date('Y-m-d H:i:s',$endtime).'该时间段已预订',1);
                 }
             }
         }
         $house=House::where('id',$order['house_id'])->find();
         $xdOrderPrice=self::getTimePirce($house,$start_time,$end_time);
         $xdOrderPayPrice=$xdOrderPrice;
         $time=time();
         $orderPrice=$xdOrderPrice;
         $orderPayPrice=$orderPrice;
         $store=Store::where('id',$house['store_id'])->find();
         return fetchJson([
          'price'=>$orderPrice,
          'pay_price'=>$orderPayPrice
         ]);
    }
    //订单续单提交
    public function orderContinueSubmit(){
         try {
            $data=request()->post();
            $rule = [
                 'order_id|订单ID' => 'require|number',
                 'time|入住时间'=>'require|in:0.5,1,1.5,2,2.5,3,3.5,4,4.5,5,5.5,6,6.5,7,7.5,8,8.5,9,9.5,10',
             ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         $order=HouseOrder::where(['id'=>$data['order_id'],'is_pay'=>1])->where('status','in','1,2')->find();
         if(!$order){
            return fetchJson([],'暂无订单',1);
         }
         //向前续单
         if($type=input('type')){
              $start_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('start_time ASC')->value('start_time');
              if($start_time){
                $start_time=$start_time-$data['time']*3600;
                if($start_time<time()){
                   $start_time=time();
                }
                $end_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('start_time ASC')->value('start_time');
              }else{
                $start_time=$order->start_time-$data['time']*3600;
                if($start_time<time()){
                   $start_time=time();
                }
                $end_time=$order->end_time;
              }
         }else{
           // 向后续单
           $end_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('end_time DESC')->value('end_time');
           if($end_time){
              $start_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('end_time DESC')->value('end_time');
              $end_time=$end_time+$data['time']*3600;

           }else{
              $start_time=$order->end_time;
              $end_time=$order->end_time+$data['time']*3600;
           }
         }
         if($end_time<time()){
            return fetchJson([],'预订时间已过',1);
         }
         if($start_time>$end_time){
            return fetchJson([],'预订时间错误',1);
         }
         
         if($end_time<time()){
            return fetchJson([],'预订时间已过',1);
         }
         if($start_time>$end_time){
            return fetchJson([],'预订时间错误',1);
         }
         $starttime=strtotime(date('Y-m-d H:i',$start_time));
         $endtime=strtotime(date('Y-m-d H:i',$end_time));
         $halfDay=($endtime-$starttime)/3600;
         $num=$halfDay;
         $dayArr=[];
         for ($j=1;$j<($halfDay+1);$j++){ 
            $dayArr[]=$starttime+1800*$j;
         }
         $is_booKtime=HouseStock::where(['acid'=>$order['acid'],'store_id'=>$order['store_id'],'house_id'=>$order['house_id'],'status'=>0])->where('hour','in',$dayArr)->where('order_id','<>',$data['order_id'])->count();
         if($is_booKtime){
            return fetchJson([],'该时间段已被预订，请重新预约茶室',1);
         }
         foreach ($dayArr as $dV){
             $is_booKtime=HouseStock::where(['acid'=>$order['acid'],'store_id'=>$order['store_id'],'house_id'=>$order->house_id,'status'=>0])
             ->where('hour','>=',$dV)->where('hour','<=',$endtime)->count();
             if($is_booKtime){
                return fetchJson([],date('Y-m-d H:i:s',$dV).'该时间段已预订',1);
             }else{
                 $is_booKtime=HouseStock::where(['acid'=>$order['acid'],'store_id'=>$order['store_id'],'house_id'=>$order->house_id,'status'=>0])->where('hour',$endtime)->count();
                 if($is_booKtime){
                    return fetchJson([],date('Y-m-d H:i:s',$endtime).'该时间段已预订',1);
                 }
             }
         }
         Db::startTrans();
         try {
             //开始时间跟结束时间的判断
            $isOrderStartTime=HouseOrder::where(['acid'=>$order['acid'],'house_id'=>$order['house_id']])->lock(true)
               ->whereTime('start_time', '<=',$starttime)
               ->whereTime('end_time', '>=',$starttime)
               ->whereTime('create_time','>=',time()-30)
               ->whereTime('create_time','<=',time())                
               ->find();
            $isOrderEndTime=HouseOrder::where(['acid'=>$order['acid'],'house_id'=>$order['house_id']])->lock(true)
               ->whereTime('start_time', '<=',$endtime)
               ->whereTime('end_time', '>=',$endtime)
               ->whereTime('create_time','>=',time()-30)
               ->whereTime('create_time','<=',time())                
               ->find();

              //续单开始时间跟结束时间的判断
            $isxDOrderStartTime=HouseOrderContinue::where(['acid'=>$order['acid'],'house_id'=>$order['house_id']])->lock(true)
               ->whereTime('start_time', '<=',$starttime)
               ->whereTime('end_time', '>=',$starttime)
               ->whereTime('create_time','>=',time()-30)
               ->whereTime('create_time','<=',time())                
               ->find();
            $isxDOrderEndTime=HouseOrderContinue::where(['acid'=>$order['acid'],'house_id'=>$order['house_id']])->lock(true)
               ->whereTime('start_time', '<=',$endtime)
               ->whereTime('end_time', '>=',$endtime)
               ->whereTime('create_time','>=',time()-30)
               ->whereTime('create_time','<=',time())                
               ->find();  
            if($isOrderStartTime||$isOrderEndTime){
                  return fetchJson([],'该时间段已经有人正在预定！',1);
            }
            if($isxDOrderStartTime||$isxDOrderEndTime){
                  return fetchJson([],'该时间段已经有人正在续单！',1);
            }
            Db::commit();
         } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            return fetchJson([],$e->getMessage(),1);
 
        }
         $house=House::where('id',$order['house_id'])->find();
         $xdOrder=new HouseOrderContinue();
         $xdOrder->save([
            'order_no'=>HouseOrderContinue::crateOrderNo(),
            'start_time'=>$start_time,
            'end_time'=>$end_time,
            'order_id'=>$order->id,
            'user_id'=>-1,
            'acid'=>$order->acid,
            'house_id'=>$order->house_id,
            'store_id'=>$order->store_id,   
            'pay_type'=>2
         ]);
         $xdOrder->price=self::getTimePirce($house,$start_time,$end_time);
         $xdOrder->pay_price=$xdOrder->price;
         $time=time();
 
         $orderPrice=$xdOrder->price;
         $orderPayPrice=$orderPrice;

         $is_repeat_order_original=0;
         $store=Store::where('id',$order->store_id)->find();
         if(isset($store['is_repeat_order_original'])){
            $is_repeat_order_original=$store['is_repeat_order_original']==1?1:0;
         }
         $xdOrder->save();
         return fetchJson($xdOrder);
    }
    //订单续单支付
    public function orderContinuePay(){
       $order_id=input('order_id');
       $order=HouseOrderContinue::where(['id'=>$order_id,'is_pay'=>0])->find();
       if(!$order){
          return fetchJson([],'暂无订单',1);
       }
       
       if($order->is_pay==1){
           return fetchJson([],'订单已支付',1);
        }
        $order->pay_time=time();
        $order->status=1;
        $order->pay_type=2;
        $order->xml_array=[];
        $order->is_pay=1;
        $order->save();
        $stockInsert=[];
        $start_time=$order->start_time;
        $numB=($order->end_time-$start_time)/1800;
        for ($j=0;$j<$numB+1;$j++){
           $time=$start_time+(1800*$j);
           if($time>($start_time-1800)&&$time<($order->end_time+1800)){
                $stockOrder=HouseStock::where([
                    'acid'=>$order->acid,
                    'date'=>strtotime(date('Y-m-d',$time)),
                    'house_id'=>$order->house_id,
                    'hour'=>$time,
                    'store_id'=>$order->store_id,
                ])->find(); 
                if(!$stockOrder){
                    $stockInsert[]=[
                        'acid'=>$order->acid,
                        'date'=>strtotime(date('Y-m-d',$time)),
                        'house_id'=>$order->house_id,
                        'hour'=>$time,
                        'order_id'=>$order->order_id,
                        'store_id'=>$order->store_id,
                        'create_time'=>time(),
                        'update_time'=>time()
                    ];
                }else{
                    $stockOrder->order_id=$order->order_id;
                    $stockOrder->status=0;
                    $stockOrder->save();
                }
           } 
        }
        HouseStock::insertAll($stockInsert);
        self::addStoreBill($order);
        self::openRoom($order);//设备开锁
        self::sendSubscribeXd($order);
        return fetchJson([],'支付成功');
    }
    //提前结束订单
    public function endOrdersEarly(){
        $order=HouseOrder::where(['id'=>input('order_id'),'is_pay'=>1,'is_qianya'=>1])->where('status','in','1,2')->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        } 
        $form= new \app\task\controller\Wechat();
        $form->endOrdersEarly($order);
        return fetchJson([],'提前结束订单');
    }
    public function timePus($start_time='',$end_time='',$book_interval_status=1){
         $dateHi=[];
         $start_time_H=strtotime(date('Y-m-d H',$start_time).':00');
         if($start_time>$start_time_H&&$start_time<$start_time_H+1800){
            $start_time=$start_time_H;
         }
         if($start_time>$start_time_H+1800&&$start_time<$start_time_H+3600){
            $start_time=$start_time_H+1800;
         }
         $end_time_H=strtotime(date('Y-m-d H',$end_time).':00');
         if($end_time<$end_time_H+1800){
            if($end_time>($end_time_H+900)){
                $end_time=$end_time_H+1800;
            }
         }
         if($end_time>$end_time_H+1800&&$end_time<$end_time_H+3600){
            if($end_time>($end_time_H+1800+900)){
                 $end_time=$end_time_H+3600;
            }
         }
         $numB=($end_time-$start_time)/1800;
         if($book_interval_status){
            $numB=$numB+1;
            $x=0;
         }else{
            $x=0;
         }
         for ($j=$x;$j<$numB;$j++){
           $time=$start_time+(1800*$j);
           $dateHi[date('Y-m-d H:i',$time)]=$time;
           //$dateHi[]=$time;
         }
         return $dateHi;
    }
    //提前使用订单
    public function useOrdersEarly(){
        $order=HouseOrder::where(['id'=>input('order_id'),'is_pay'=>1,'status'=>1])->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        $start_time=time();
        $start_time1=$start_time;
        $numB=($order->end_time-$order->start_time)/1800;
        
        $end_time=$start_time+$numB*1800;
        self::storeBusinessHours($order->store_id,$start_time,$end_time);
        $dayArr=houseTimePus($start_time,$end_time);
        $use_booKtime=HouseStock::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'house_id'=>$order->house_id,'status'=>0])
         ->where('order_id','<>',$order->id)
        ->where('hour', 'in', $dayArr)
        ->order('hour ASC')
        ->value('hour');
        if($use_booKtime){
            return fetchJson([],date('Y-m-d H:i',$use_booKtime).'提前失败现在时间段已被预订',1);
        }
        $is_room_status=Store::where(['id'=>$order->store_id])->value('is_room_status');
        if($is_room_status==1){
            $house_room_status=House::where('id',$order->house_id)->value('room_status');
            if($house_room_status==2){
                return fetchJson([],'提前失败该房间还未打扫',1);
            }
        }
        $num=($end_time-$start_time)/1800;
        $book_interval_status=Store::where('id',$order->store_id)->value('book_interval_status');
        $book_interval_status=$book_interval_status==0?0:1;
        if(($end_time%1800)!=0){
            $book_interval_status=1;
        }
        $timeArray=self::timePus($start_time1,$end_time,$book_interval_status);
        foreach($timeArray as $time){
              $stockOrder=HouseStock::where([
                    'acid'=>$order->acid,
                    'date'=>strtotime(date('Y-m-d',$time)),
                    'house_id'=>$order->house_id,
                    'hour'=>$time,
                    'store_id'=>$order->store_id,
                ])->find(); 
                if(!$stockOrder){
                    $stockInsert[]=[
                        'acid'=>$order->acid,
                        'date'=>strtotime(date('Y-m-d',$time)),
                        'house_id'=>$order->house_id,
                        'hour'=>$time,
                        'order_id'=>$order->order_id,
                        'store_id'=>$order->store_id,
                        'create_time'=>time(),
                        'update_time'=>time()
                    ];
                }else{
                    $stockOrder->order_id=$order->order_id;
                    $stockOrder->status=0;
                    $stockOrder->save();
                }
        }
        HouseStock::where(['order_id'=>$order->id])->update(['status'=>1,'order_id'=>0]);
        HouseStock::insertAll($stockInsert);
        $order->start_time=$start_time1;
        $order->end_time=$end_time;
        $order->save();
        $form=new HouseOrderDoorForm();
        $form->openDoor($order);
        return fetchJson([],'提前成功');
    }
     //续单增加商户账单
    public function addStoreBill($order=[]){
        $store=Store::where('id',$order->store_id)->find();
        $fee=($store->fee*0.01)*$order->price;
        $fee=$fee>0?$fee:0;//手续费
        $orderPrice=$order->price-$fee; //总金额   
        $stockHouse=StockHouseUser::alias('h_u')
               ->leftJoin([StockHouse::getTable()=>'h'],'h_u.stock_house_id=h.id')
               ->where(['h_u.acid'=>$order->acid,'h.house_id'=>$order->house_id,'h_u.is_delete'=>0,'h.is_delete'=>0])
               ->field('h_u.stock_user_id,h_u.ratio,h.house_id,h_u.stock_house_id')
               ->select()
               ->toArray(); 
        //只能用微信支付结算了
        if(isset($store->is_actually_weixin_pay)){
            if($store->is_actually_weixin_pay){
                return false;
            }
        }               
        //分红金额
        $sharePrice=0;           
        foreach($stockHouse as $hu){
           (new StockHouseUserOrder())->save([
              'acid'=>$order->acid,
              'type'=>2,
              'order_id'=>$order->id,
              'stock_house_id'=>$hu['stock_house_id'],
              'stock_user_id'=>$hu['stock_user_id'],
              'ratio'=>$hu['ratio'],
              'price'=>$hu['ratio']*$orderPrice*0.01, 
            ]);
           $user=StockUser::where('id',$hu['stock_user_id'])->field('money,total_price')->find();
           if($user){
             $user->money+=$hu['ratio']*$orderPrice*0.01;
             $user->total_price+=$hu['ratio']*$orderPrice*0.01;
             $user->save();
           }
           $sharePrice+=$hu['ratio']*$orderPrice*0.01;
        }  
        if($sharePrice>0){
             $store->money+=$orderPrice-$sharePrice;
            (new Bill())->save([
                'acid'=>$order['acid'],
                'type'=>Bill::TYPE_HOUSE_CONTINUE,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order->store_id,
                'order_id'=>$order->id,
                'price'=>$orderPrice-$sharePrice,
                'price_type'=>$order->pay_type,
                'balance'=>$store->money,
                'status'=>1,
                'fee'=>$fee,
                'des'=>'商户: 【'.$store->name.'】茶室续单收入其中股东分红扣除'.$sharePrice.'元'
            ]);
           
        }else{
             $store->money+=$orderPrice-$sharePrice;
            (new Bill())->save([
                'acid'=>$order['acid'],
                'type'=>Bill::TYPE_HOUSE_CONTINUE,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order->store_id,
                'order_id'=>$order->id,
                'price'=>$orderPrice-$sharePrice,
                'price_type'=>$order->pay_type,
                'balance'=>$store->money,
                'status'=>1,
                'fee'=>$fee,
                'des'=>'商户: 【'.$store->name.'】茶室续单收入'
            ]);
           
        }        
        $store->save();
    }
    private function openRoom($order=[]){
        $smart_device=Store::where('id',$order->store_id)->value('smart_device');
        if(empty($smart_device)){
           return false;
        }
        $smart_device=@json_decode($smart_device,1);
        $house=House::where('id',$order->house_id)->find();
        $houseOrder=HouseOrder::where('id',$order->order_id)->find();
        $config=[
            'appKey'=>$smart_device['electronic_mandun_appKey'],
            'appSecret'=>$smart_device['electronic_mandun_appSecret'],
            'uname'=>$smart_device['electronic_mandun_uname'],
            'passwd'=>$smart_device['electronic_mandun_passwd'],
            'projectCode'=>$smart_device['electronic_mandun_projectCode'],
            'api_url'=>$smart_device['electronic_mandun_apiUrl'],
        ];
        if($houseOrder->end_time>time()&&$houseOrder->start_time<time()){
            $start_time=time();
        }else if($houseOrder->end_time<time()){
            $start_time=time();
        }else{
            $start_time=$houseOrder->start_time;
        }
        $end_time=$order->end_time;

        if($house['electricityid']=="-1"||$house['electricityid']=="0"||$house['electricityid']==''){
            self::lvjoinTask($house,$order,$start_time,$end_time);
        }else{
            $lineList=ElectricityLine::where([
                'acid'=>$house['acid'],
                'store_id'=>$house['store_id'],
                'mac'=>$house['electricityid'],
                'house_id'=>$house['id'],
                'is_delete'=>0
             ])->column('line,ahead_time,forward_time');
            foreach ($lineList as $key => $value) {
               $ahead_time=$value['ahead_time']*60;
               $forward_time=$value['forward_time']*60;
               self::joinTask($house['lockid'],$order,$order->id,2,$config,$house['electricityid'],$value['line'],($start_time-$ahead_time),($end_time+$forward_time));
            }
        }
    }
     //加入绿米任务
    public function lvjoinTask($house,$order,$start_time,$end_time){
        $lumi_electricity_config=LumiElectricityConfig::where([
            'acid'=>$order->acid,
            'store_id'=>$house['store_id'],
            'house_id'=>$house['id'],
            'is_delete'=>0
        ])->column('dev_did,dev_model,resource,ahead_time,forward_time,reset_time');
        $params=[];
        $lvmi_device=Store::where(['id'=>$house['store_id']])->value('lvmi_device');
        $lvmi_device=@json_decode($lvmi_device,1);
        $accessToken=isset($lvmi_device['accessToken'])?$lvmi_device['accessToken']:'';
        $storeConfig=Store::where('id',$house['store_id'])->value('lvmi_developer');
        $storeConfig=@json_decode($storeConfig,1);

        foreach ($lumi_electricity_config as &$vlm){
            $resources=[];
            $resource=@json_decode($vlm['resource'],1);
            foreach ($resource as $v){
              $resources[]=[
                'resourceId'=>$v['resuors'],
                'value'=>$v['status'],
              ];
              $ahead_time=$v['ahead_time']*60;
              $forward_time=$v['forward_time']*60;
              $config=json_encode([
                [
                    'subjectId'=>$vlm['dev_did'],
                    'resources'=>$resources,
                ]
              ]);
              $form=Electricity::where(['acid'=>$order->acid,'order_id'=>$order->order_id,'config'=>$config])->find();
              if(!$form){
                    $form=new Electricity();
                    $form->status=0;
              }
              $form->save([
                  'acid'=>$order->acid,
                  'lvmi_developer'=>json_encode($storeConfig,JSON_UNESCAPED_UNICODE),
                  'config'=>$config,
                  'order_id'=>$order->order_id,
                  'mac'=>$accessToken,
                  'line'=>-1,
                  'start_time'=>$start_time-$ahead_time,
                  'end_time'=>$end_time+$forward_time,
                  'reset_time'=>$vlm['reset_time']>0?$end_time+$forward_time+($vlm['reset_time']*60):0,
              ]);
              $task=new \app\shared\controller\Task();
              $task->lvhandleOther($form->id,$form->start_time,$form->end_time);
           }
        }
    }
    //加入任务
    public function joinTask($lockid,$order,$order_id,$type,$config,$mac,$line,$start_time,$end_time){
        if(!$mac)return;
        $form=Electricity::where(['acid'=>$order->acid,'line'=>$line,'order_id'=>$order->order_id])->find();
        if($form){
            $form->start_time=$start_time;
            $form->end_time=$end_time;
            $form->save();
            $task=new \app\shared\controller\Task();
            $task->handleOther($form->id,$start_time,$end_time);
        }
    }
    public function sendSubscribeXd($order=[]){
        $app=App::where('id',$order->acid)->field('id acid,wx_app_id,wx_app_secret,wxapp_app_id,wxapp_app_secret')->find()->toArray();
        $app['wx_subscibe_book_finish']=Option::get_data($order->acid,'platform','wx_subscibe_book_finish');
        $app['wx_subscibe_book_overtime']=Option::get_data($order->acid,'platform','wx_subscibe_book_overtime');
        $app['wx_subscibe_book_inform']=Option::get_data($order->acid,'platform','wx_subscibe_book_inform');
        $app['wx_subscibe_book_sweep']=Option::get_data($order->acid,'platform','wx_subscibe_book_sweep');
        $app['wx_template_cleaning_inform']=Option::get_data($order->acid,'platform','wx_template_cleaning_inform');
        $app['wx_template_cleaning_port_inform']=Option::get_data($order->acid,'platform','wx_template_cleaning_port_inform');
        $store=Store::where('id',$order['store_id'])->field('name,openid')->find();
        $houseOrder=HouseOrder::where('id',$order->order_id)->find();
        $snapshoot=@json_decode($houseOrder->snapshoot,1);
        
        //发送保洁人员
        $weixin=new \weixin\Wechat();
        $data=[
            "first"    =>[
              "value"  =>"用户下单加时提醒",
              "color"  =>"#173177"
            ],
            "keyword1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
              "color"  =>"#173177"
            ],
            "keyword2" =>[
              "value"  =>$store['name'],//保洁员：
              "color"  =>"#173177"
            ],
            "keyword3" =>[
              "value"  =>"共享茶室",//保洁类型：
              "color"  =>"#173177"
            ],
            "keyword4" =>[
              "value"  =>date('Y-m-d H:i:s',$houseOrder['start_time']).'之前', //保洁时间：
              "color"  =>"#173177"
            ],
            "remark"   =>[
              "value"  =>'用户订单时间'.date('Y-m-d H:i:s',$order->start_time).'至'.date('Y-m-d H:i:s',$order->end_time),
              "color"  =>"#173177"
            ]
        ];

        $openidArr=explode(',', $store['openid']);
        $res=$weixin->sendWxopenTemplatePro($app,$app['wx_template_cleaning_inform'],$openidArr,"pages/index/index",$data);
        
        self::sendCleaningTplXD($app,$order);
    }
    //保洁端用户下单提醒
    public function sendCleaningTplXD($app,$order){
        $cleaning= StoreCleaning::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'is_delete'=>0,'status'=>1])->where('openid','<>','')->column('openid,account');
        $houseOrder=HouseOrder::where('id',$order->order_id)->find();
        $snapshoot=@json_decode($houseOrder->snapshoot,1);
        $store=Store::where('id',$houseOrder->store_id)->field('address,name')->find();
        //发送保洁人员
        $weixin=new \weixin\Wechat();
        $data=[
            "first"    =>[
              "value"  =>"用户在店【{$store['name']}】"."续单提醒",
              "color"  =>"#173177"
            ],
            "keyword1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
              "color"  =>"#173177"
            ],
            "keyword2" =>[
              "value"  =>$store['address'],//房间地址：
              "color"  =>"#173177"
            ],
            "keyword3" =>[
              "value"  =>date('Y-m-d H:i:s',$order->end_time).'之后', //保洁时间：
              "color"  =>"#173177"
            ],
            "remark"   =>[
              "value"  =>'用户续单时间'.date('Y-m-d H:i:s',$order->start_time).'至'.date('Y-m-d H:i:s',$order->end_time),
              "color"  =>"#173177"
            ]
        ];
        $openidArr=array_column($cleaning,'openid','account');
        $res=$weixin->sendWxopenTemplatePro($app,$app['wx_template_cleaning_port_inform'],$openidArr,"pages/index/index",$data);
        foreach($cleaning as $value){
            \app\shared\model\MessageLog::pushMsg($order->acid,$value['account'],$order->order_no,json_encode($data,JSON_UNESCAPED_UNICODE),json_encode($res));

        }
    }
}


