<?php
namespace app\api\logic;
use app\shared\model\Option;
use app\shared\model\Store;
use app\shared\model\Tags;
use app\shared\model\HouseOrder;
use app\shared\model\HouseStock;
use app\shared\model\User;
use app\shared\model\CardUser;
use app\shared\model\House;
use app\shared\model\Card;
use app\shared\model\App;
use app\BaseController;
use wechatpay\WechatPay;
//茶室列表
class HouseForm extends Base
{	
	public function list(){
		$lat=input('lat')?input('lat'):0;
        $lng=input('lng')?input('lng'):0;
		$list=House::alias('h')
		 ->leftJoin([Store::getTable()=>'s'],'h.store_id=s.id')
		 ->where(['h.acid'=>$this->acid,'h.is_delete'=>0,'h.status'=>1])
		 ->field('s.name store_name,s.logo,s.lat,s.lng,s.score,h.id,h.name,h.status,h.store_id,h.cover,h.virtual_sales,h.price,h.booktime,h.member_price,(6378.138 * 2 * asin(sqrt(pow(sin((s.lat * pi() / 180 - '.$lat.' * pi() / 180) / 2),2) + cos(s.lat * pi() / 180) * cos('.$lat.' * pi() / 180) * pow(sin((s.lng * pi() / 180 - '.$lng.' * pi() / 180) / 2),2))) * 1000) as distance')
         ->order('distance ASC')
         ->page($this->page)
         ->limit(10)
         ->select()
         ->toArray();
         foreach ($list as $key => &$value) {
             $value['logo']=get_file_url($value['logo']);
             $value['booktime']=$value['booktime']?$value['booktime']:1;
             $value['booknum']=HouseOrder::where(['acid'=>$this->acid,'is_pay'=>1,'house_id'=>$value['id']])->where('status','<>',4)->count();
             $virtual_sales=isset($value['virtual_sales'])?$value['virtual_sales']:0;
             $value['booknum']+=$virtual_sales;
             $discount=Card::where(['acid'=>$this->acid,'is_delete'=>0])->order('discount ASC')->value('discount');
             if(!$discount){
                  $value['member_price']=-1;
             }else{
                if($value['member_price']<=0){
                  $value['member_price']=$value['price']*$discount*0.1;
                  $value['member_price']=round($value['member_price'],2);
                }
             }
             $value['discount']=$discount;
             $value['is_book']=HouseStock::where(['acid'=>$this->acid,'house_id'=>$value['id']])->where('hour',"<",time()+$value['booktime']*3600)->where('hour',">",time())->count();
             $value['is_book']=$value['is_book']>0?1:0;
         }
         return fetchJson($list);
	}
    
}