<?php
namespace app\api\logic;
use app\shared\model\Option;
use app\shared\model\Store;
use app\shared\model\Tags;
use app\shared\model\HouseOrder;
use app\shared\model\HouseStock;
use app\shared\model\User;
use app\shared\model\CardUser;
use app\shared\model\House;
use app\shared\model\Card;
use app\shared\model\App;
use app\BaseController;
use wechatpay\WechatPay;
//首页
class HomeForm extends Base
{	
	public function info(){
		 $info=App::where('id',$this->acid)->field('wxapp_app_id,name')->find();
		 $booknum=HouseOrder::where(['acid'=>$this->acid,'is_pay'=>1])->where('status','<>',4)->count();
         $virtual_sales=House::where(['acid'=>$this->acid,'status'=>1,'is_delete'=>0])->sum('virtual_sales');
         $info['tea_house_sales_num']=$virtual_sales+$booknum;
         $info['tea_house_num']=House::where(['acid'=>$this->acid,'status'=>1,'is_delete'=>0])->count();
		 return fetchJson($info);
	}
	//用户列表
	public function userList(){
		$list=User::field('account,avatar_url,nickname')->limit($this->limit)->page($this->page)->select();
		return fetchJson($list);
	}
	//app信息
	public function appInfo(){
		 $info=App::where('id',$this->acid)->find();
		 return fetchJson($info);
	}
}