<?php
namespace app\api\logic;
use app\BaseController;
use slock\Slock;
use slock\Xsj;
use slock\Ttlock;
use think\facade\Cache;
use think\exception\ValidateException;
use think\facade\Db;
use app\shared\model\App;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\CardOrder;
use app\shared\model\RechargeOrder;
use app\shared\model\StoreRechargeOrder;
use app\shared\model\GoodsOrder;
use app\shared\model\TeaSpecialistOrder;
use app\shared\model\GiftCardOrder;
use app\plugin\model\usercashgrade\UsercashgradeOrder;
use app\shared\model\PartnerOrder;
//茶室列表
class H5PayForm extends BaseController
{	
	public function __construct(){
        
     }
	public function orderPay(){
		try {
          $data=request()->post();
          $rule = [
               'order_id|订单ID' => 'require|number',
               'type|类型'=>'require',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $title="商品支付";
       switch ($data['type']) {
       	case '1':
       		//茶室订单
       	    $order=HouseOrder::where(['id'=>$data['order_id'],'status'=>0])->find();
       	    if($order){
       	    	 $order->order_no=HouseOrder::crateOrderNo();
       	    	 $order->save();
       	    	 $title=$order->house_title.'茶室预定';
       	    }
       	    break;
          case '2':
               //茶室订单续单
              $order=HouseOrderContinue::where(['id'=>$data['order_id'],'status'=>0])->find();
              if($order){
                $order->order_no=HouseOrderContinue::crateOrderNo();
                $order->save();
                $title='茶室续单';
              }
              break;
          case '3':
               //会员卡
              $order=CardOrder::where(['id'=>$data['order_id'],'status'=>0])->find();
              if($order){
                $order->order_no=CardOrder::crateOrderNo();
                $order->save();
                $title='会员卡';
              }
              break;
          case '4':
               //充值订单
              $order=RechargeOrder::where(['id'=>$data['order_id'],'status'=>0])->find();
              if($order){
                $order->order_no=RechargeOrder::crateOrderNo();
                $order->save();
                $title='充值订单';
                $order['pay_price']=$order->money;
              }
              break;
          case '5':
               //商户储值卡
              $order=StoreRechargeOrder::where(['id'=>$data['order_id'],'status'=>0])->find();
              if($order){
                $order->order_no=StoreRechargeOrder::crateOrderNo();
                $order->save();
                $title='商户储值卡';
                $order['pay_price']=$order->money;
              }
              break;
          case '6':
               //商品订单
              $order=GoodsOrder::where(['id'=>$data['order_id'],'status'=>0])->find();
              if($order){
                $order->order_no=GoodsOrder::crateOrderNo();
                $order->save();
                $title='商品订单';
              }
              break;
           case '7':
               //茶艺师订单
              $order=TeaSpecialistOrder::where(['id'=>$data['order_id'],'status'=>0])->find();
              if($order){
                $order->order_no=TeaSpecialistOrder::crateOrderNo();
                $order->save();
                $title='茶艺师订单';
              }
              break;
           case '8':
               //礼品卡订单
              $order=GiftCardOrder::where(['id'=>$data['order_id'],'is_pay'=>0])->find();
              if($order){
                $order->order_no=GiftCardOrder::crateOrderNo();
                $order->save();
                $title='礼品卡订单';
              }
              break;
           case '9':
               //用户押金
              $order=UsercashgradeOrder::where(['id'=>$data['order_id'],'is_pay'=>0])->find();
              if($order){
                $order->order_no=UsercashgradeOrder::crateOrderNo();
                $order->save();
                $title='用户押金';
                $order['pay_price']=$order->price;
              }
              break;
           case '10':
               //合伙人订单
              $order=PartnerOrder::where(['id'=>$data['order_id'],'status'=>0])->find();
              if($order){
                $order->order_no=PartnerOrder::crateOrderNo();
                $order->save();
                $title='合伙人订单';
              }
              break;                                      
       	default:
       		$order=[];
       		break;
       }
       if($order){
       	  $app=App::where('id',$order['acid'])->find();
       	  return fetchJson([
       	  	'title'=>$title,
       	  	'pay_price'=>$order['pay_price'],
       	  	'order_no'=>$order['order_no'],
       	  	'mchid'=>$app['wx_mch_id'],
               'key'=>$app['wx_key'],
               'sslcert'=>$app['wx_cert_pem'],
               'sslkey'=>$app['wx_key_pem'],
       	  ]);
       }else{
       	  return fetchJson([],'暂无订单',1);
       }
	}


}