<?php
namespace app\admin\logic;
use app\admin\model\User;
use app\shared\model\App as Platform;
use app\admin\model\Role;
use app\admin\model\Menu;
use app\shared\model\Option;
use think\exception\ValidateException;
use app\BaseController;
class UserForm extends  Base
{
    //获取数据
    public  function index(){
        $list=User::where(['is_delete'=>0])->page($this->page)->limit($this->limit)->select()->toArray();
        $count=User::count();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //查询
    public  function  find(){
        $id=input('id');
        $form=User::where(['id'=>$id])->find();
        return fetchJson($form);
    }
    //编辑
    public function  edit(){
        $id=input('id');
        $form=User::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'nickname|名称'=>'require',
                'username|账号'   => 'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new User();
        }
        if($data['password']){
            $data['password']=md5($data['password']);
        }
        $form->save($data);
        return fetchJson([],'保存成功');
    }
    public  function  delete(){
        $id=input('id');
        if($id==1){
            return fetchJson([],'该账号不可删除',1);
        }
        User::where(['id'=>$id])->update(['is_delete'=>1]);
        return fetchJson([],'删除成功');
    }
     //编辑
    public function  platform_edit(){
        $id=input('id');
        $form=Platform::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'name|名称'=>'require',
                'account|账号'=>'require',
                'logo|LOGO'=>'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new Platform();
            $password=input('password');
            if(!$password){
                return fetchJson([],'密码不得为空',1);
            }
            if(strlen($password)<6){
                return fetchJson([],'密码长度不得小于6位',1);
            }
            if(Platform::where(['account'=>$data['account']])->count()){
                return fetchJson([],'该账号已存在',1);
            }
        }else{
            if(Platform::where(['account'=>$data['account']])->where('id','<>',$form->id)->count()){
                 return fetchJson([],'该账号已存在',1);
            }
        }
        $post['name']=$data['name'];
        $post['account']=$data['account'];
        $post['logo']=$data['logo'];
        if($password=input('password')){
            if(strlen($password)<6){
                return fetchJson([],'密码长度不得小于6位',1);
            }
            $post['password']=md5($password);
        }
        $form->save($post);
        Option::set_data($form->id,'paltform','app_single_merchant',input('app_single_merchant'));
        Option::set_data($form->id,'paltform','app_merchant_number',input('app_merchant_number'));

       
        return fetchJson([],'保存成功');
    }
    //平台列表
    public  function platform_list(){
        $list=Platform::page($this->page)->limit($this->limit)
        ->select()->toArray();
        foreach ($list as &$value) {
            $value['logo_url']=get_file_url($value['logo']);
            $value['app_single_merchant']= Option::get_data($value['id'],'paltform','app_single_merchant');
            $value['app_single_merchant']=$value['app_single_merchant']==1?1:0;
            $value['app_merchant_number']=Option::get_data($value['id'],'paltform','app_merchant_number');
            $value['app_merchant_number']=empty($value['app_merchant_number'])?0:$value['app_merchant_number'];
        }
        $count=Platform::count();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }


}