<?php
namespace app\admin\logic;
use app\admin\model\Role;
use app\shared\model\Option;

use app\admin\model\Attachment;
use app\shared\model\House;
use app\shared\model\User;
use app\shared\model\Store;
use app\shared\model\Advertising;
use think\exception\ValidateException;
use app\BaseController;
class SystemUploadForm extends  Base
{
	public function info(){
		$info=Option::get_data(-1,'admin','system_upload_config');
		if(!$info){
			$info=[
				'al'=>[
					'ak'=>'',
		            'sk'=>'',
		            'bucket'=>'',
		            'endpoint'=>'',
		            'domain'=>'',
		            'cname'=>''
				],
				'tencent'=>[
					'secretId'=>'',
		            'secretKey'=>'',
		            'bucket'=>'',
		            'region'=>'',
		            'domain'=>'',
		            'cname'=>'',
				]
			];
		}else{
			$info=json_decode($info,1);
			if(!isset($info['tencent'])){
				$info['tencent']=[
					'secretId'=>'',
		            'secretKey'=>'',
		            'bucket'=>'',
		            'region'=>'',
		            'domain'=>'',
		            'cname'=>''
				];
			}else{
				if(!isset($info['tencent']['cname'])){
					$info['tencent']['cname']='';
				}
				if(!isset($info['al']['domain'])){
					$info['al']['domain']='';
				}
			}
		}
		return fetchJson($info);
	}
	public function setting(){
		 $data=request()->post();
		 Option::set_data(-1,'admin','system_upload_config',json_encode([
		 	'al'=>input('al'),
		 	'tencent'=>input('tencent'),
		 	'upload'=>input('upload')
		 ]));
		 $res=self::onkeyUploadConfig();
		 return $res;      
	}
	//一键上传配置
	private function onkeyUploadConfig(){
        $info=Option::get_data(-1,'admin','system_upload_config');
        $url=request()->domain().'/';
        $info=json_decode($info,1);
        $config=[];
        if(isset($info[$info['upload']])){
            $config=$info[$info['upload']];
        }
        if(!$config){
            return fetchJson([],'本地存储');
        }

        $domain=$config['domain'];
        $cname=$config['cname'];
        $msg=$info['upload']=="tencent"?"腾讯COS存储":"阿里OSS存储";
        if(!$domain&&!$cname){
            return fetchJson([],$msg.'参数问题',1);
        }
        $list=Attachment::field('id,path,url,driver')->select();
        foreach ($list as $v){
            $v->url=$domain.'/'.$cname.$v->path;
            $v->driver="cos";
            $v->save();
        }
        $list=Advertising::field('id,cover')->select();
        foreach ($list as $v){
            $v->cover=str_replace($url,$domain.'/'.$cname,$v->cover);
            $v->save();
        }
        $list=House::field('id,cover')->select();
        foreach ($list as $v){
            $v->cover=str_replace($url,$domain.'/'.$cname,$v->cover);
            $v->save();
        }
        return fetchJson([],$msg);    
    }

}