<?php
namespace weixin;
use think\facade\Cache;
/**
* 微信
*/
class Wechat{

     public function sendWxopenTemplate($wechat,$template_id,$openid,$wxapp_path,$data){
        //绑定公众号的用户可以发送
       $wxopen_template_url="https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";
        $send_data=
        [
            "touser"         =>$openid,//openid
            "template_id"=>$template_id, //绑定的公众号创建的模板id
            "miniprogram"=>[
              "appid"    =>$wechat['wxapp_app_id'],         //小程序appid
              "pagepath" =>$wxapp_path                  //跳转至小程序的路径
            ],
            'data'=>$data
              //   "data"       =>[
              //     "first"    =>[
              //       "value"  =>"有人下单了哦",
              //       "color"  =>"#173177"
              //     ],
              //     "keyword1" =>[
              //       "value"  =>"巧克力",
              //       "color"  =>"#173177"
              //     ],
              //     "remark"   =>[
              //       "value"  =>"欢迎再次购买！",
              //       "color"  =>"#173177"
              //     ]
              // ]
        ];
        $send_data=json_encode($send_data);
        $get_access_token=self::web_wx_access_token($wechat);
        $access_token=$get_access_token['data'];
        return self::setHttpRequest($wxopen_template_url.$access_token,$send_data);
    }
     //获取access_token
    public function web_wx_access_token($wx){
      $access_token=Cache::get('web_wx_access_token_acid'.$wx['acid']);
      if ($access_token) {
       return ['code'=>0,'msg'=>'','data'=>$access_token];
      }
      $url="https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={$wx['wx_app_id']}&secret={$wx['wx_app_secret']}";
      $res=self::setHttpRequest($url);
      if(isset($res->access_token)){
        Cache::set('web_wx_access_token_acid'.$wx['acid'],$res->access_token,3600);
        return ['code'=>0,'msg'=>'','data'=>$res->access_token];
      }else{
        return ['code'=>$res->errcode,'data'=>'','msg'=>$res->errmsg];
      }
    }
     //获取access_token
    public function wxapp_access_token($wx){
        $access_token=Cache::get('wxapp_access_token_acid'.$wx['acid']);
        if ($access_token) {
          return ['code'=>0,'msg'=>'','data'=>$access_token];
        }
        $url="https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={$wx['wxapp_app_id']}&secret={$wx['wxapp_app_secret']}";
        $res=self::setHttpRequest($url);
         return ['code'=>0,'msg'=>'','data'=>$res->access_token];
        if(isset($res->access_token)){
          Cache::set('wxapp_access_token_acid'.$wx['acid'],$res->access_token,3600);
          return ['code'=>0,'msg'=>'','data'=>$res->access_token];
        }else{
          return ['code'=>$res->errcode,'data'=>'','msg'=>$res->errmsg];
        }
    }
    public function sendSubscibeMsg($wx=[],$data=[]){
        $wxapp=self::wxapp_access_token($wx);
        $access_token=$wxapp['data'];
        $api = 'https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token='. $access_token;
        $data=json_encode($data);
        return self::setHttpRequest($api,$data);
    }
    public  function setHttpRequest($url,$params=array(),$headers='',$method="POST") {
            set_time_limit(0);
            $ci = curl_init();
            curl_setopt($ci, CURLOPT_CONNECTTIMEOUT, 30);
            curl_setopt($ci, CURLOPT_TIMEOUT, 30);
            curl_setopt($ci, CURLOPT_CUSTOMREQUEST, $method);
            curl_setopt($ci, CURLOPT_URL, $url);
            curl_setopt($ci, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ci, CURLOPT_HEADER, FALSE);
            curl_setopt($ci, CURLOPT_SSL_VERIFYPEER, false); // 对认证证书来源的检查
            curl_setopt($ci, CURLOPT_SSL_VERIFYHOST, false); // 从证书中检查SSL加密算法是否存在
            if($headers!=""){
                curl_setopt($ci, CURLOPT_HTTPHEADER, $headers);
            }else {
                curl_setopt($ci, CURLOPT_HTTPHEADER, array('Content-type: application/json'));
            }
            switch (strtoupper($method)){
                case 'POST':
                    curl_setopt($ci, CURLOPT_POST, TRUE);
                    curl_setopt($ci, CURLOPT_POSTFIELDS, $params);
                    break;
                case 'PUT':
                    curl_setopt($ci, CURLOPT_CUSTOMREQUEST, 'PUT');
                    curl_setopt($ci, CURLOPT_POSTFIELDS, $params);
                    break;
                case 'PATCH':
                    curl_setopt($ci, CURLOPT_CUSTOMREQUEST, 'PATCH');
                    curl_setopt($ci, CURLOPT_POSTFIELDS, $params);
                    break;
                case 'DELETE':
                    curl_setopt($ci, CURLOPT_CUSTOMREQUEST, 'DELETE');
                    curl_setopt($ci, CURLOPT_POSTFIELDS, $params);
                    break;
                default:
                    curl_setopt($ci, CURLOPT_HTTPGET, TRUE);
                    break;
            }
            $response = curl_exec($ci);
            $httpCode = curl_getinfo($ci);
            curl_close($ci);
            return json_decode($response);
    }


}
